/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

/* 
TabBook.h - Public definitions for TabBook widget
	See TabBook documentation

Copyright 1996 COMPUTER GENERATION, INC.,

The software is provided "as is", without warranty of any kind, express
or implied, including but not limited to the warranties of
merchantability, fitness for a particular purpose and noninfringement.
In no event shall Computer Generation, inc. nor the author be liable for
any claim, damages or other liability, whether in an action of contract,
tort or otherwise, arising from, out of or in connection with the
software or the use or other dealings in the software.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.

Author:
Gary Aviv 
Computer Generation, Inc.,
gary@compgen.com
*/

/* Revision History:
$Log: TabBook.h,v $
Revision 1.3  2003/11/19 11:53:09  eyan
changed the copyright:
"Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved." -->
"Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved."

Revision 1.2  2003/11/18 10:58:40  eyan
Add License text for source codes.
Add Sun License for WuBi sources.

Revision 1.1  2003/10/24 02:50:54  tajima
cvs add sun_le_asia. Just hoping I won't miss anything...

Revision 1.1  1997/05/01 22:20:51  eric
Initial revision



$log
Initial
$log
*/
#ifndef _XcgTabBook_h
#define _XcgTabBook_h

/***********************************************************************
 *
 * TabBook Widget
 *
 ***********************************************************************/

/*
  New resource names/classes
*/

#define XcgNautoManage	 "autoManage"
#define XcgCAutoManage	"AutoManage"

#define XcgNactivePage	 "activePage"
#define XcgCActivePage	"ActivePage"

#define XcgNnewPageCallback "newPageCallback,"
#define XcgCNewPageCallback "NewPageCallback,"

/*
  Constraint resource names/classes
*/

#define XcgNresizeChild	 "resizeChild"
#define XcgCResizeChild	"ResizeChild"

#define XcgRESIZE_NONE 0
#define XcgRESIZE_VERTICAL 1
#define XcgRESIZE_HORIZONTAL 2
#define XcgRESIZE_BOTH (XcgRESIZE_VERTICAL | XcgRESIZE_HORIZONTAL)

#define XcgNanchorChild	 "anchorChild"
#define XcgCAnchorChild	 "AnchorChild"


#define XcgANCHOR_CENTER	0
#define XcgANCHOR_EAST		1
#define XcgANCHOR_NORTH		2
#define XcgANCHOR_NORTHEAST	3
#define XcgANCHOR_NORTHWEST	4
#define XcgANCHOR_SOUTH		5
#define XcgANCHOR_SOUTHEAST	6
#define XcgANCHOR_SOUTHWEST	7
#define XcgANCHOR_WEST		8


#if defined(__cplusplus) || defined(c_plusplus)
extern "C" { 
#endif

typedef struct _TabBookClassRec	*TabBookWidgetClass;
typedef struct _TabBookRec		*TabBookWidget;

extern WidgetClass xcgTabBookWidgetClass;

#define XcgTabBook_OPT_NO_CB 1
Boolean XcgTabBookSetActivePage(Widget w, int page, int option );
int XcgTabBookGetActivePage(Widget w );
Widget XcgTabBookGetActivePageWidget(Widget w);


#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

/*
 * Callback reasons.  Try to stay out of range of the Motif XmCR_* reasons.
 */
typedef enum _XcgTabBookgReasonType {
    XcgNewPage = 202		/* New page is active */
} XcgTabBookReasonType;


/*
** Struct passed to application when called back
*/
typedef struct _XcgTabBookCallbackData
{
	XcgTabBookReasonType reason;	/* reason for callback */
	XEvent *event;			/* button event, NULL if emulated  */
	int prev_active_page;		/* 0 when initially called */
	int active_page;		/* new active page */
	Widget button;			/* the button widget which was
					   pressed (emulated or actual*/
	Boolean ret_veto;		/* caller may set to True to stop page change */
	int future1;
	void * future2;
} XcgTabBookCallbackData;

 
#endif /* _XcgTabBook_h */
