#ifndef IMLOCK_HH_
#define IMLOCK_HH_
#include <config.h>
#include <threaddef.h>
#include "basictype.hh"

class IMSyncObject
{
    bool locked;
    THREAD_SYNC_OBJECT so;

    // inhibit duplication.
    IMSyncObject(const IMSyncObject& a);
    IMSyncObject& operator=(const IMSyncObject& a);
  public:
    bool locked_p()
    { return locked; }
    void lock()
    {
	LOCK_SYNC_OBJECT(so);
	locked = true;
    }
    void unlock()
    {
	if (locked) {
	    locked = false;
	    UNLOCK_SYNC_OBJECT(so);
	}
    }
    IMSyncObject()
    {
	locked = false;
	INIT_SYNC_OBJECT(so);
    }
    ~IMSyncObject()
    {
	if (locked) UNLOCK_SYNC_OBJECT(so);
	DESTROY_SYNC_OBJECT(so);
    }
};

class IMLock
{
    bool locked;
    IMSyncObject *pso;

    // inhibit duplication.
    IMLock(const IMLock& a);
    IMLock& operator=(const IMLock& a);
  public:
    IMLock(IMSyncObject& so)
    {
	pso = &so;
	pso->lock();
	locked = true;
    }
    IMLock(IMSyncObject& so, bool lockp)
    {
	if (lockp) {
	    pso = &so;
	    pso->lock();
	    locked = true;
	} else {
	    locked = false;
	}
    }
    ~IMLock()
    {
	if (locked) pso->unlock();
    }
};

#endif /* not IMLOCK_HH_ */

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
