/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package com.sun.iiim;

import java.text.AttributedString;
import java.text.AttributedCharacterIterator;

/**
 * This class represents InputMethod's preedit event.
 */
public class IIIMPreeditEvent extends IIIMEvent {

    private AttributedCharacterIterator iterator;
    private String string;
    private int caret;

    public static final int START = 0;
    public static final int DRAW  = 1;
    public static final int DONE  = 2;

    /**
     * Constructor for START/DONE event
     *
     * @param type IIIMPreeditEvent.START or IIIMPreeditEvent.DRAW
     */
    public IIIMPreeditEvent(int type) {
	super(PREEDIT);
	if (type != START && type != DONE) {
	    throw new IllegalArgumentException();
	}
	this.type = type;
    }

    /** 
     * Constructor for DRAW event
     *
     * @param type IIIMPreeditEvent.DRAW
     * @param iterator AttributedCharacterIterator which represents preedit string
     * @param caret caret position
     */
    public IIIMPreeditEvent(int type, AttributedCharacterIterator iterator,
			    int caret) {
	super(PREEDIT);
	if (type != DRAW) {
	    throw new IllegalArgumentException();
	}
	this.type = DRAW;
	this.iterator = iterator;
	this.caret = caret;
    }

    /** 
     * Constructor for DRAW event
     *
     * @param type IIIMPreeditEvent.DRAW
     * @param string String which represents preedity string
     * @param caret caret position
     */
    public IIIMPreeditEvent(int type, String string, int caret) {
	super(PREEDIT);
	if (type != DRAW) {
	    throw new IllegalArgumentException();
	}
	this.type = DRAW;
	this.string = string;
	this.caret = caret;
    }

    /**
     * Get preedit string
     *
     * @return 	preedit string AttributedCharacterIterator
     */
    public AttributedCharacterIterator getIterator() {
	if (iterator == null) {
	    iterator = new AttributedString(string).getIterator();
	}
	return iterator;
    }

    /**
     *
     * @return preedit string String
     */
    public String getString() {
	if (string == null) {
	    string = iteratorToString(iterator);
	}
	return string;
    }

    /**
     * Get caret position
     *
     * @return 	caret position
     */
    public int getCaret() {
	return caret;
    }
}
