#if !defined(IIIMF_ROLE_DATA_CLIENT_H)
#define IIIMF_ROLE_DATA_CLIENT_H

/* $Id: role-data-client.h,v 1.1.1.1 2002/08/31 04:18:03 himi Exp $ */


#include <iiimp.h>


#ifdef	__cplusplus
extern "C" {
#endif


typedef struct {
    char *	user_name;		/* User name */
    char *	password;		/* password (if exists). */
    char *	home_dir;		/* Home directory */
    char *	node;			/* client node name */

    char *	server_node;		/* server node name or address */
    char *	service;		/* service name or port number */

    char *	type;			/* Application type */
    char *	os_name;		/* Operating system name */
    char *	os_arch;		/* Operating system architecture */
    char *	os_version;		/* Operating system version */
    char *	X_display_name;		/* X display name */
    char *	X_server_vendor;	/* X service vendor */
} IIIMF_role_data_client;


extern IIIMF_status	iiimf_role_data_client_new(
				const char *			server_node,
				const char *			service,
				IIIMF_role_data_client **	client);
extern void		iiimf_role_data_client_delete(
				IIIMF_role_data_client *	client);


#ifdef	__cplusplus
}
#endif

#endif /* !IIIMF_ROLE_DATA_CLIENT_H */


/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
