/*
 * Copyright 2003 Sun Microsystems Inc.
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Karl Park <karl.park@sun.com>
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include "unicode_block.h"

enum {
  COLUMN_BLOCK_NAME,
  COLUMN_BLOCK_BEGIN,
  COLUMN_BLOCK_END,
  COLUMN_COUNT};

static void unicodelookup_init (UnicodeLookup *obj);
static GtkWidget *make_unicode_block_selector ();
static GtkWidget *make_unicode_chartable ();
static void unicode_block_changed (GtkTreeSelection *, gpointer );
static void set_active_char_event_handler (GtkWidget *, gunichar, UnicodeLookup *);

GType
unicodelookup_get_type (void)
{
  static GType unicodelookup_type = 0;
  if (!unicodelookup_type){
    static const GTypeInfo unicodelookup_info = {
      sizeof (UnicodeLookupClass),
      NULL, /* base init */
      NULL, /* base finalize */
      (GClassInitFunc) NULL, /* class init */
      NULL, /* class finalize */
      NULL, /* class data */
      sizeof (UnicodeLookup),
      0,
      (GInstanceInitFunc) unicodelookup_init, /* obj init */
      NULL /* value table */
    };
    unicodelookup_type =
      g_type_register_static (GTK_TYPE_HPANED, "unicodelookup",
			      &unicodelookup_info, 0);
  }
  return unicodelookup_type;
}

static void
unicodelookup_init (UnicodeLookup *obj)
{
  obj->block_selector = make_unicode_block_selector (obj);
  obj->char_table =  make_unicode_chartable ();

  g_signal_connect (G_OBJECT (obj->char_table),
		    "set_active_char",
		    G_CALLBACK (set_active_char_event_handler), obj);

  gtk_paned_pack1 (GTK_PANED (obj), obj->block_selector, FALSE, TRUE);
  gtk_paned_pack2 (GTK_PANED (obj), obj->char_table, TRUE, TRUE);
  
  gtk_widget_show (obj->block_selector);
  gtk_widget_show (obj->char_table);
}


static GtkWidget *
make_unicode_block_selector (UnicodeLookup *obj)
{
  GtkWidget *tv;
  GtkTreeStore *tv_model;
  GtkTreeIter iter;
  GtkCellRenderer *cell;
  GtkTreeViewColumn *column;
  
  tv_model = gtk_tree_store_new (
				 COLUMN_COUNT, G_TYPE_STRING,
				 G_TYPE_UINT, G_TYPE_UINT);
  gtk_tree_store_append (tv_model, &iter, NULL);
  gtk_tree_store_set (tv_model, &iter,
		      COLUMN_BLOCK_NAME, "--ga--",
		      COLUMN_BLOCK_BEGIN, 0xac00,
		      COLUMN_BLOCK_END, 0xb097, -1);
  gtk_tree_store_append (tv_model, &iter, NULL);
  gtk_tree_store_set (tv_model, &iter,
			 COLUMN_BLOCK_NAME, "--na--",
			 COLUMN_BLOCK_BEGIN, 0xb098,
			 COLUMN_BLOCK_END, 0xb2e3, -1);
  tv = gtk_tree_view_new_with_model (GTK_TREE_MODEL (tv_model));
  obj->tree_selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (tv));
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (tv), FALSE);
  cell = gtk_cell_renderer_text_new ();
  column =
    gtk_tree_view_column_new_with_attributes (NULL, cell,
					      "text", COLUMN_BLOCK_NAME, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (tv), column);
  gtk_widget_show_all (tv);

  obj->block_selection_changed_handler_id =
    g_signal_connect (
	      G_OBJECT (obj->tree_selection), "changed",
		      G_CALLBACK (unicode_block_changed), obj);

       
  return tv;
}
static void
set_active_char_event_handler (GtkWidget *widget,
			       gunichar uc,
			       UnicodeLookup *obj)
{
  g_print ("set_active_char_event_handler called\n");
}


static GtkWidget *
make_unicode_chartable ()
{
  GtkWidget *char_table;
  
  char_table = unicharinfo_new ();
  gtk_widget_show (char_table);

  return char_table;
}

GtkWidget *
unicodelookup_new (void)
{
  return GTK_WIDGET (g_object_new (unicodelookup_get_type (), NULL));
}

static void
unicode_block_changed (GtkTreeSelection *selection, gpointer data)
{
  GtkTreeModel *model;
  GtkTreeIter iter;
  gchar *buffer;
  gint i_page;
  GtkWidget *page;
  UnicodeLookup *obj = UNICODELOOKUP(data);
  
  if (gtk_tree_selection_get_selected (selection, &model, &iter)){
    gtk_tree_model_get (model, &iter, COLUMN_BLOCK_NAME, &buffer, -1);

    g_printf (buffer);
  }
}

#ifdef TEST_RUN
int
main (int argc, char *argv[])
{
  GtkWidget *main_window;
  GtkWidget *paned_widget;
  GtkWidget *hangul_block_selector;
  GtkWidget *text_entry2;

  gtk_init (&argc, &argv);

  main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  paned_widget = gtk_hpaned_new ();
  gtk_container_add (GTK_CONTAINER (main_window), paned_widget);
  gtk_widget_show (paned_widget);
  
  hangul_block_selector = make_unicode_block_selector ();
  gtk_paned_add1 (GTK_PANED (paned_widget), hangul_block_selector);
  gtk_widget_show (hangul_block_selector);
  
  text_entry2 = gtk_entry_new ();
  gtk_paned_add2 (GTK_PANED (paned_widget), text_entry2);
  gtk_widget_show (text_entry2);

  gtk_widget_show (main_window);
  gtk_main ();
  return 0;
  
  
}

#endif
