/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "hzinput.h"
#include "PYIM.h"
#include "encode.h"
#include <iconv.h>
#include <assert.h>

#define IME_Status		ime_buffer->return_status
#define Input_Buf		ime_buffer->inputkey_buf
#define Input_Len		ime_buffer->inputkey_len
#define Preedit_Buf		ime_buffer->preedit_buf
#define Preedit_Len		ime_buffer->preedit_len
#define Preedit_CaretPos	ime_buffer->preedit_caretpos
#define Commit_Buf		ime_buffer->commit_buf
#define Commit_Len		ime_buffer->commit_len
#define Status_Buf		ime_buffer->status_buf
#define Status_Len		ime_buffer->status_len
#define Lookup_Buf		ime_buffer->lookup_buf
#define Lookup_Num		ime_buffer->lookup_num
#define Lookup_Pos		ime_buffer->cur_lookup_pos
#define Candidates_Buf		ime_buffer->candidates_buf
#define Additions_Buf		ime_buffer->additions_buf

int convert_to_imebuffer(ImToXSun* pIeh, IMEBuffer ime_buffer);

int newzy_open(JINT nSesID)
{
	ImToXSun *pIeh;

	pIeh = (ImToXSun *)NewZY_open(nSesID);
	if (pIeh == NULL) {
		printf("NewZY_open failed\n");
		return (-1);
	}

	return(0);
}

int newzy_close(JINT nSesID)
{
	NewZY_close(nSesID);
	return(0);
}

int newzy_filter(keycode, keychar, keystatus, ime_buffer)
int keycode;
int keychar;
int keystatus;
IMEBuffer ime_buffer;
{
	ImToXSun *pIeh;
	JINT ret;
	JINT nSesID = ime_buffer->session_id;

	IME_Status = 0;
   	pIeh = (ImToXSun *)NewZY_trans (nSesID, (JINT)keycode, (JINT)keychar, (JINT)keystatus);

	if (pIeh == NULL)
		return(IME_NOT_USED_KEY);
		
	ret = convert_to_imebuffer(pIeh, ime_buffer);
	return (ret);
}

/*
**  Convert from Struct ImToXSun to Struct ImToXSunChar
*/
int convert_to_imebuffer(ImToXSun* pIeh, IMEBuffer ime_buffer)
{
	JINT   i, j; 
	JWORD  tmp;
	UCHAR   preedit[512], lookup[10][48], commit[512];

	char   outbuf[512];
	char *tptr;
	const char *fptr;
	size_t inleft, outleft;

/*
	iconv_t converter;

	converter = (iconv_t)iconv_open("UTF-8", "zh_TW-big5");
	if(converter == (iconv_t)-1) printf("can't open iconv module\n");
*/

	IME_Status = 0;

	if (pIeh->nType == IMXSUN_TYPE_BOUNCEKEY)
		return(IME_NOT_USED_KEY);

	ime_buffer->lookup_label_type = UPPER_LABEL;
	Lookup_Num = pIeh->nChoiceNum;
	IME_Status |= IME_LOOKUP_AREA;

	j = 0; 
	for (i = 0; pIeh->pwPreedit[i] != 0x0000; i ++) {
	    tmp = pIeh->pwPreedit[i];
	    if(pIeh->pwPreedit[i] >= 0xa140) {
	        preedit[j++] = tmp / 256; 
		preedit[j++] = tmp & 0xff;
	    }
	    else if(pIeh->pwPreedit[i] == 0x0020) {
		preedit[j++] = 0x0020;
	    }
	    else {
		preedit[j++] = tmp & 0xff;
	    }
	}
	preedit[j] = 0;
	Preedit_CaretPos = pIeh->nCaretPos;

	inleft = (size_t)strlen((char *)preedit);
	outleft = (size_t)512;
	fptr = (char *)preedit;
	tptr = outbuf;
	Convert_Native_To_UTF8(ENCODE_BIG5HK, (char *)fptr, inleft, &tptr, &outleft);
/*
	iconv(converter, &fptr, &inleft, &tptr, &outleft);
*/
	outbuf[512 - outleft] = 0;
	strncpy((char *)Preedit_Buf, (char *)(outbuf), MAX_PREEDIT_CHAR_NUM-1);

/*
	strncpy((char *)Preedit_Buf, (char *)(preedit), MAX_PREEDIT_CHAR_NUM-1);
*/

	Jword2Uchar(pIeh->pwCommit,  commit,  256);

	inleft = (size_t)strlen((char *)commit);
	outleft = (size_t)512;
	fptr = (char *)commit;
	tptr = outbuf;
	Convert_Native_To_UTF8(ENCODE_BIG5HK, (char *)fptr, inleft, &tptr, &outleft);
/*
	iconv(converter, &fptr, &inleft, &tptr, &outleft);
*/
	outbuf[512 - outleft] = 0;
	strncpy((char *)Commit_Buf,  (char *)(outbuf),  MAX_COMMIT_CHAR_NUM-1);
	
/*
	strncpy((char *)Commit_Buf,  (char *)(commit),  MAX_COMMIT_CHAR_NUM-1);
*/

	Preedit_Len = strlen((char *)Preedit_Buf);
	IME_Status |= IME_PREEDIT_AREA;

	Commit_Len  = strlen((char *)Commit_Buf);
	IME_Status |= IME_COMMIT;

	for(i = 0; i < 8; i ++) {
	    Jword2Uchar(pIeh->pwLookupChoice[i], lookup[i],  24);
	    inleft = (size_t)strlen((char *)lookup[i]);
	    outleft = (size_t)512;
	    fptr = (char *)lookup[i];
	    tptr = outbuf;
	    Convert_Native_To_UTF8(ENCODE_BIG5HK, (char *)fptr, inleft, &tptr, &outleft);
/*
	    iconv(converter, &fptr, &inleft, &tptr, &outleft);
*/
	    outbuf[512 - outleft] = 0;
	    strncpy((char *)Lookup_Buf[i], (char *)outbuf, 24);
/*
	    strncpy((char *)Lookup_Buf[i], (char *)lookup[i], 24);
*/
	}
	
	return(IME_USED_KEY);
}

