/* GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
                                                                                
/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GTK+ at ftp://ftp.gtk.org/pub/gtk/.
 */
                                                                                
/******************************************************
*Imported from gtk+-2.0 source by phill.zhang@sun.com
******************************************************/

#ifndef __IM_LABEL_H__
#define __IM_LABEL_H__

#include <gdk/gdk.h>
#include <gtk/gtkmisc.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtkmenu.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define IM_TYPE_LABEL		  (im_label_get_type ())
#define IM_LABEL(obj)		  (G_TYPE_CHECK_INSTANCE_CAST ((obj), IM_TYPE_LABEL, ImLabel))
#define IM_LABEL_CLASS(klass)	  (G_TYPE_CHECK_CLASS_CAST ((klass), IM_TYPE_LABEL, ImLabelClass))
#define IM_IS_LABEL(obj)	  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IM_TYPE_LABEL))
#define IM_IS_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IM_TYPE_LABEL))
#define IM_LABEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), IM_TYPE_LABEL, ImLabelClass))


typedef struct _ImLabel       ImLabel;
typedef struct _ImLabelClass  ImLabelClass;

typedef struct _ImLabelSelectionInfo ImLabelSelectionInfo;

struct _ImLabel
{
  GtkMisc misc;

  /*< private >*/
  gchar  *label;
  guint   jtype : 2;
  //guint   wrap : 1;
  //guint   use_underline : 1;
  guint   use_markup : 1;

  //guint   mnemonic_keyval;

  gchar  *text;
  PangoAttrList *attrs;
  PangoAttrList *effective_attrs;
  PangoLayout *layout;
  ImLabelSelectionInfo *select_info;
  gint    caret_index, showing_caret, delay_hide_caret, timer_id;

  //GtkWidget *mnemonic_widget;
  //GtkWindow *mnemonic_window;

};

struct _ImLabelClass
{
  GtkMiscClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
  void (*_gtk_reserved5) (void);
  void (*_gtk_reserved6) (void);
  void (*_gtk_reserved7) (void);
};

GType                 im_label_get_type          (void) G_GNUC_CONST;
GtkWidget*            im_label_new               (const char    *str);
void                  im_label_set_text          (ImLabel      *label,
                                                   const char    *str);
G_CONST_RETURN gchar* im_label_get_text          (ImLabel      *label);

void                  im_label_set_attributes    (ImLabel      *label,
                                                   PangoAttrList *attrs);
PangoAttrList        *im_label_get_attributes    (ImLabel      *label);

void                  im_label_set_label         (ImLabel      *label,
                                                   const gchar   *str);
G_CONST_RETURN gchar *im_label_get_label         (ImLabel      *label);
void                  im_label_set_markup        (ImLabel      *label,
                                                   const gchar   *str);
void                  im_label_set_use_markup    (ImLabel      *label,
                                                   gboolean       setting);
gboolean              im_label_get_use_markup    (ImLabel      *label);
void                  im_label_set_justify       (ImLabel         *label,
                                                  GtkJustification  jtype);
GtkJustification      im_label_get_justify       (ImLabel         *label);
void                  im_label_set_pattern       (ImLabel         *label,
                                                  const gchar      *pattern);
void                  im_label_set_selectable    (ImLabel         *label,
                                                  gboolean          setting);
gboolean              im_label_get_selectable    (ImLabel         *label);
void                  im_label_select_region     (ImLabel         *label,
                                                   gint              start_offset,
                                                   gint              end_offset);
gboolean              im_label_get_selection_bounds(ImLabel         *label,
                                                   gint             *start,
                                                   gint             *end);


void                  im_label_set_caret_index   (ImLabel *label, gint caret);
//gint                  im_label_get_caret_index   (ImLabel *label);

PangoLayout *         im_label_get_layout         (ImLabel *label);
void                  im_label_get_layout_offsets (ImLabel *label,
                                                   gint     *x,
                                                   gint     *y);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __IM_LABEL_H__ */
