/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <locale.h>
#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/List.h>
#include <Xm/PushB.h>
#include <Xm/SeparatoG.h>
#include <Xm/LabelG.h>
#include <Xm/Form.h>
#include <Xm/MwmUtil.h>
#include <locale.h>

#include "hzinput.h"

typedef struct _SelectAuxData {
	Widget 	wdtShell;
	Widget 	wdtSelectedList;
	Widget 	wdtUnSelectedList;
	Widget	wdtAddBtn;
	Widget	wdtAddAllBtn;
	Widget	wdtRemoveBtn;
	Widget	wdtRemoveAllBtn;
	Widget	wdtMoveUpBtn;
	Widget	wdtMoveDownBtn;
	Widget	wdtOKBtn;
	Widget	wdtApplyBtn;

	int 	nActiveUnselectItem;
	int 	nActiveSelectItem;

} SelectAuxData;

SelectAuxData 	gSelData;
char 		gLocaleID;
Display		*gDisplay;

IMEListRec 		TempSelectedIMEList;
extern IMEListRec	AllIMEList, SelectedIMEList;

void SelectAux_InitObjects();
void SelectAux_FreeObjects();
void SelectAux_DestroyProc(Widget widget, XtPointer pClientData, XtPointer pCallData);
void SelectAux_Reset_IMEList(IMEListRec *selected_imelist);
void SelectAux_Add_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void SelectAux_AddAll_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void SelectAux_Remove_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void SelectAux_RemoveAll_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void SelectAux_MoveUp_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void SelectAux_MoveDown_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void SelectAux_OK_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void SelectAux_Apply_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void SelectAux_Reset_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void SelectAux_Cancel_cb(Widget widget, XtPointer pClientData, XtPointer pCallData);
void SelectAux_Show();
void SelectAux_Hide();

int main(int argc, char **argv)
{
	XtAppContext    app;

	Widget shell, form, unselectlist_w, selectlist_w, separator;
	Widget sel_label;
	Widget add_button, addall_button, remove_button, removeall_button;
	Widget moveup_button, movedown_button;
	Widget ok_button, apply_button, reset_button, cancel_button;
	XmString xmstr;
	Atom xa_ct;
	int nXPos, nYPos, nWidth, nHeight;
	int nFrameWidth, nFrameHeight;
	int nYList, nListWidth, nSelectListHeight, nUnSelectListHeight;
	int nButtonWidth, nXLabel, nYLabel;
	int i, nXDelta, nYDelta, nSpacing;

	/* creates all of the widgets in the dialog box. */
	Arg arrArg[24];
	int nArg;

	char *msg, *lpszTitle;
	char *locale_name = NULL;

	nFrameWidth = 390;
	nFrameHeight = 400;
	nListWidth = 54;
	nButtonWidth = 16;

	nSelectListHeight = 36;
	nUnSelectListHeight = 20;
	nXLabel = 4;
	nYLabel = 4;
	nSpacing = 8;
	nXDelta = (100 - nXLabel - nListWidth - nButtonWidth) / 2;
	nYDelta = 5;

	XtSetLanguageProc((XtAppContext)0, (XtLanguageProc)0, (XtPointer)0) ;

	/* create but do NOT manage the container dialog. */
	nArg = 0;
	XtSetArg(arrArg[nArg], XmNx, 600); nArg++;
	XtSetArg(arrArg[nArg], XmNy, 400); nArg++;
	XtSetArg(arrArg[nArg], XmNinput, FALSE); nArg++;
	XtSetArg(arrArg[nArg], XmNdefaultPosition, FALSE); nArg++;
	XtSetArg(arrArg[nArg], XmNheight, nFrameHeight); nArg++;
	XtSetArg(arrArg[nArg], XmNwidth, nFrameWidth); nArg++;
	XtSetArg(arrArg[nArg], XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE); nArg++;
	shell = XtAppInitialize(&app, "SelectAux", NULL, 0, &argc, argv, NULL, arrArg, nArg);

	locale_name = setlocale(LC_CTYPE, NULL);
	if (locale_name == NULL) return;
	locale_name = (char *) strdup(locale_name);
	gLocaleID = get_encodeid_from_locale(locale_name);
	Msg_Init(locale_name);
	free(locale_name);

	XtAddCallback(shell, XmNdestroyCallback, SelectAux_DestroyProc, NULL);
	gSelData.wdtShell = shell;
	gDisplay = XtDisplay(shell);

	/* Set the window title */
	msg = (char *)get_msg_by_msgid(0, "IME Selection");
	xa_ct = XmInternAtom(XtDisplay(shell), "COMPOUND_TEXT", FALSE);
	xmstr = XmStringCreateLocalized(msg);
	lpszTitle = XmCvtXmStringToCT(xmstr);
	XtVaSetValues(shell, XmNtitle, lpszTitle, XmNtitleEncoding, xa_ct, NULL);
	XmStringFree(xmstr);
	free(msg);

	form = XtVaCreateManagedWidget("Form", xmFormWidgetClass, shell, NULL);

	/* create hint label indicate which IM have been added */
	nXPos = nXLabel;
	nYPos = nYLabel;
	msg = (char *)get_msg_by_msgid(1, "Selected input methods:");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	sel_label = XtVaCreateManagedWidget ("label", 
		xmLabelGadgetClass,  form, 
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNlabelString, xmstr,
		NULL);
	XmStringFree(xmstr);
		
	nYList = nYPos + nYDelta;
	nYPos = nYList;
	nArg=0;
	XtSetArg(arrArg[nArg],XmNselectionPolicy, XmBROWSE_SELECT); nArg++;
	XtSetArg(arrArg[nArg],XmNlistSizePolicy, XmCONSTANT); nArg++;
	XtSetArg(arrArg[nArg],XmNrecomputeSize, FALSE); nArg++;
	XtSetArg(arrArg[nArg],XmNresizable, FALSE); nArg++;
	XtSetArg(arrArg[nArg],XmNleftAttachment, XmATTACH_POSITION); nArg++;
	XtSetArg(arrArg[nArg],XmNleftPosition, nXPos); nArg++;
	XtSetArg(arrArg[nArg],XmNrightAttachment, XmATTACH_POSITION); nArg++;
	XtSetArg(arrArg[nArg],XmNrightPosition, nXPos+nListWidth); nArg++;
	XtSetArg(arrArg[nArg],XmNtopAttachment, XmATTACH_POSITION); nArg++;
	XtSetArg(arrArg[nArg],XmNtopPosition, nYPos); nArg++;
	XtSetArg(arrArg[nArg],XmNbottomAttachment, XmATTACH_POSITION); nArg++;
	XtSetArg(arrArg[nArg],XmNbottomPosition, nYPos+nSelectListHeight); nArg++;
	selectlist_w = XmCreateScrolledList(form, "scroll_list", arrArg, nArg);
	XtManageChild(selectlist_w);
	gSelData.wdtSelectedList = selectlist_w;

	nXPos += nListWidth + nXDelta;
	nYPos = nYList;
	nWidth = nButtonWidth;
	nButtonWidth += 2;
	msg = (char *)get_msg_by_msgid(2, "Remove");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	remove_button = XtVaCreateWidget ("Remove",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(remove_button);
	gSelData.wdtRemoveBtn = remove_button;
	XtAddCallback(remove_button, XmNactivateCallback, SelectAux_Remove_cb, 0);
	XmStringFree(xmstr);

	nYPos += nSelectListHeight/4;
	msg = (char *)get_msg_by_msgid(3, "Remove All");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	removeall_button = XtVaCreateWidget ("Remove_All",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(removeall_button);
	gSelData.wdtRemoveAllBtn = removeall_button;
	XtAddCallback(removeall_button, XmNactivateCallback, SelectAux_RemoveAll_cb, 0);
	XmStringFree(xmstr);

	nYPos += nSelectListHeight/4;
	msg = (char *)get_msg_by_msgid(4, "Up");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	moveup_button = XtVaCreateWidget ("MoveUp",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(moveup_button);
	gSelData.wdtMoveUpBtn = moveup_button;
	XtAddCallback(moveup_button, XmNactivateCallback, SelectAux_MoveUp_cb, 0);
	XmStringFree(xmstr);

	nYPos += nSelectListHeight/4;
	msg = (char *)get_msg_by_msgid(5, "Down");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	movedown_button = XtVaCreateWidget ("MoveDown",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(movedown_button);
	gSelData.wdtMoveDownBtn = movedown_button;
	XtAddCallback(movedown_button, XmNactivateCallback, SelectAux_MoveDown_cb, 0);
	XmStringFree(xmstr);

	/* Create separator line */
	nYPos = nYList + nSelectListHeight + nYDelta;
	separator = XtVaCreateManagedWidget ("separator",
		xmSeparatorGadgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		NULL);
	
	/* create hint label indicate which IM not added */
	nXPos = nXLabel;
	nYPos += nYDelta;
	msg = (char *)get_msg_by_msgid(6, "Unselected input methods:");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	sel_label = XtVaCreateManagedWidget ("label", 
		xmLabelGadgetClass,  form, 
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNlabelString, xmstr,
		NULL);
	XmStringFree(xmstr);
		
	nYList = nYPos + nYDelta;
	nYPos = nYList;
	nArg=0;
	XtSetArg(arrArg[nArg],XmNselectionPolicy, XmBROWSE_SELECT); nArg++;
	XtSetArg(arrArg[nArg],XmNlistSizePolicy, XmCONSTANT); nArg++;
	XtSetArg(arrArg[nArg],XmNrecomputeSize, FALSE); nArg++;
	XtSetArg(arrArg[nArg],XmNresizable, FALSE); nArg++;
	XtSetArg(arrArg[nArg],XmNleftAttachment, XmATTACH_POSITION); nArg++;
	XtSetArg(arrArg[nArg],XmNleftPosition, nXPos); nArg++;
	XtSetArg(arrArg[nArg],XmNrightAttachment, XmATTACH_POSITION); nArg++;
	XtSetArg(arrArg[nArg],XmNrightPosition, nXPos+nListWidth); nArg++;
	XtSetArg(arrArg[nArg],XmNtopAttachment, XmATTACH_POSITION); nArg++;
	XtSetArg(arrArg[nArg],XmNtopPosition, nYPos); nArg++;
	XtSetArg(arrArg[nArg],XmNbottomAttachment, XmATTACH_POSITION); nArg++;
	XtSetArg(arrArg[nArg],XmNbottomPosition, nYPos+nUnSelectListHeight); nArg++;
	unselectlist_w = XmCreateScrolledList(form, "scroll_list1", arrArg, nArg);
	XtManageChild(unselectlist_w);
	gSelData.wdtUnSelectedList = unselectlist_w;

	/* Create the 4 buttons: Add/Add_all */
	nXPos += nListWidth + nXDelta;
	nYPos = nYList;
	msg = (char *)get_msg_by_msgid(7, "Add");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	add_button = XtVaCreateWidget ("add",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(add_button);
	gSelData.wdtAddBtn = add_button;
	XtAddCallback(add_button, XmNactivateCallback, SelectAux_Add_cb, 0);
	XmStringFree(xmstr);

	nYPos += nUnSelectListHeight/2;
	msg = (char *)get_msg_by_msgid(8, "Add All");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	addall_button = XtVaCreateWidget ("add_all",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(addall_button);
	gSelData.wdtAddAllBtn = addall_button;
	XtAddCallback(addall_button, XmNactivateCallback, SelectAux_AddAll_cb, 0);
	XmStringFree(xmstr);

	/* Create separator line */
	nYPos = nYList + nUnSelectListHeight + nYDelta;
	separator = XtVaCreateManagedWidget ("separator",
		xmSeparatorGadgetClass, form,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		NULL);
	
	/* Create 4 Buttons: OK/Apply/Reset/Cancel */
	nButtonWidth -= 2;
	nXPos = (100 - 3 * nSpacing - 4 * nButtonWidth) / 2;
	nYPos += nYDelta;
	msg = (char *)get_msg_by_msgid(9, "OK");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	ok_button = XtVaCreateWidget ("OK",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(ok_button);
	gSelData.wdtOKBtn = ok_button;
	XtAddCallback(ok_button, XmNactivateCallback, SelectAux_OK_cb, 0);
	XmStringFree(xmstr);

	nXPos += nSpacing + nButtonWidth;
	msg = (char *)get_msg_by_msgid(10, "Apply");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	apply_button = XtVaCreateWidget ("rowcol",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(apply_button);
	gSelData.wdtApplyBtn = apply_button;
	XtAddCallback(apply_button, XmNactivateCallback, SelectAux_Apply_cb, 0);
	XmStringFree(xmstr);

	nXPos += nSpacing + nButtonWidth;
	msg = (char *)get_msg_by_msgid(11, "Reset");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	reset_button = XtVaCreateWidget ("Reset",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(reset_button);
	XtAddCallback(reset_button, XmNactivateCallback, SelectAux_Reset_cb, 0);
	XmStringFree(xmstr);

	nXPos += nSpacing + nButtonWidth;
	msg = (char *)get_msg_by_msgid(12, "Cancel");
	xmstr = XmStringCreateLtoR(msg, XmSTRING_DEFAULT_CHARSET);
	free(msg);
	cancel_button = XtVaCreateWidget ("Cancel",
		xmPushButtonWidgetClass, form,
		XmNrecomputeSize, True,
		XmNlabelString, xmstr,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, nXPos,
		XmNtopAttachment, XmATTACH_POSITION,
		XmNtopPosition, nYPos,
		XmNrightAttachment, XmATTACH_POSITION,
		XmNrightPosition, nXPos+nButtonWidth,
		NULL);
	XtManageChild(cancel_button);
	XtAddCallback(cancel_button, XmNactivateCallback, SelectAux_Cancel_cb, 0);
	XmStringFree(xmstr);

	gSelData.nActiveUnselectItem = 0;
	gSelData.nActiveSelectItem = 0;

	XtSetMappedWhenManaged(shell, FALSE);
	XtRealizeWidget(shell);

	/* Make dtsession do not save the geometry information */
	XSetCommand(XtDisplay(shell), XtWindow(shell), NULL, 0);

	SelectAux_InitObjects();

	/* Register aux class */
	if (xaux_ext_register_classes(shell) == -1) {
		return(-1);
	}

	XtAppMainLoop(app);
}

void SelectAux_InitObjects()
{
	IMEList_Init();
}

void SelectAux_FreeObjects()
{
	Msg_Done();
	IMEList_Free();
}
	
void SelectAux_DestroyProc(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	SelectAux_FreeObjects();
}

void SelectAux_Reset_IMEList(IMEListRec *selected_imelist)
{
	int i, j, nIME_Num, nActiveRow;
	int engine_id, nSelected;
	IMEListRec  UnSelectedIMEList;
	XmStringTable str_list;

	/* Get UnSelectedIMEList for AllIMEList and SelectedIMEList */
	nIME_Num = 0;
	DEBUG_printf("AllIMEList.nIME_Num:%d\n", AllIMEList.nIME_Num);
	if (AllIMEList.nIME_Num <= 0) return;

	for (i=0; i<AllIMEList.nIME_Num; i++) {

		nSelected = False;

		engine_id = AllIMEList.arrIME_Base[i]->engine_id;
		for (j=0; j<selected_imelist->nIME_Num; j++) {
			if (engine_id == selected_imelist->arrIME_Base[j]->engine_id) {
				nSelected = True;
				break;
			}
		}

		if (nSelected == False) {
			UnSelectedIMEList.arrIME_Base[nIME_Num] = AllIMEList.arrIME_Base[i];
			nIME_Num ++;
		}
	}

	UnSelectedIMEList.nIME_Num = nIME_Num;
	DEBUG_printf("UnSelectedIMEList.nIME_Num:%d\n", UnSelectedIMEList.nIME_Num);

	str_list = (XmStringTable)XtMalloc(nIME_Num * sizeof (XmString *));
	for ( i = 0; i < nIME_Num; i++ ) {
		str_list[i] = XmStringCreateLocalized((char *)UnSelectedIMEList.arrIME_Base[i]->cname);
	}
	
	XtVaSetValues(gSelData.wdtUnSelectedList,
		XmNitemCount, nIME_Num,
		XmNitems, str_list,
		NULL);
	XtManageChild(gSelData.wdtUnSelectedList);
	
	for (i = 0; i < nIME_Num; i++ )
		XmStringFree(str_list[i]);
	XtFree((char *)str_list);

	nIME_Num = selected_imelist->nIME_Num;
	str_list = (XmStringTable)XtMalloc(nIME_Num * sizeof (XmString *));
	for ( i = 0; i < nIME_Num; i++ ) {
		str_list[i] = XmStringCreateLocalized((char *)selected_imelist->arrIME_Base[i]->cname);
	}

	XtVaSetValues(gSelData.wdtSelectedList,
		XmNitemCount, nIME_Num,
		XmNitems, str_list,
		NULL);
	XtManageChild(gSelData.wdtSelectedList);

	for (i = 0; i < nIME_Num; i++ )
		XmStringFree(str_list[i]);
	XtFree((char *)str_list);

	nIME_Num = UnSelectedIMEList.nIME_Num;
	if (nIME_Num ==0) {
		XtSetSensitive(gSelData.wdtAddBtn, False);
		XtSetSensitive(gSelData.wdtAddAllBtn, False);
	} else {
		XtSetSensitive(gSelData.wdtAddBtn, True);
		XtSetSensitive(gSelData.wdtAddAllBtn, True);
	}

/*
	nActiveRow = gSelData.nActiveUnselectItem;
	if (nActiveRow >= nIME_Num)
		nActiveRow = nIME_Num;
	if (nActiveRow >= 0)
		XmListSelectPos(gSelData.wdtUnSelectedList, nActiveRow, True); 
*/

	nIME_Num = selected_imelist->nIME_Num;
	if (nIME_Num ==0) {
		XtSetSensitive(gSelData.wdtRemoveBtn, False);
		XtSetSensitive(gSelData.wdtRemoveAllBtn, False);
		XtSetSensitive(gSelData.wdtMoveUpBtn, False);
		XtSetSensitive(gSelData.wdtMoveDownBtn, False);
		XtSetSensitive(gSelData.wdtOKBtn, False);
		XtSetSensitive(gSelData.wdtApplyBtn, False);
	} else {
		XtSetSensitive(gSelData.wdtRemoveBtn, True);
		XtSetSensitive(gSelData.wdtRemoveAllBtn, True);
		XtSetSensitive(gSelData.wdtMoveUpBtn, True);
		XtSetSensitive(gSelData.wdtMoveDownBtn, True);
		XtSetSensitive(gSelData.wdtOKBtn, True);
		XtSetSensitive(gSelData.wdtApplyBtn, True);
	}

/*
	nActiveRow = gSelData.nActiveSelectItem;
	if (nActiveRow >= nIME_Num)
		nActiveRow = nIME_Num;
	if (nActiveRow >= 0)
		XmListSelectPos(gSelData.wdtSelectedList, nActiveRow, True);
*/
}

void SelectAux_Add_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	XmString *strlist, *selectlist = NULL;
	char *text;
	int i, j, matched, cnt = 0;

	DEBUG_printf(" SelectAux_Add_cb ===\n");
	XtVaGetValues (gSelData.wdtUnSelectedList,
		XmNselectedItemCount, &cnt,
		XmNselectedItems,     &selectlist,
		NULL);

	DEBUG_printf("cnt:%d\n", cnt);

	for(i=0; i<cnt; i++) {
		if (!XmStringGetLtoR (selectlist[i], XmFONTLIST_DEFAULT_TAG, &text))
			continue;
		
		DEBUG_printf("%d:  %s\n", i, text);

		/* check if already in the selected list */
		matched = -1;
		for (j=0; j<TempSelectedIMEList.nIME_Num; j++) {
			if (!strcmp (text, (char *)TempSelectedIMEList.arrIME_Base[j]->cname)) {
				matched = j;
				break;
			}
		}

		/* if already in the selected list, skip it */
		if (matched != -1) {
			gSelData.nActiveSelectItem = matched;
			continue;
		}

		/* check the sequence number of the item */
		matched = -1;
		for (j=0; j<AllIMEList.nIME_Num; j++) {
			if (!strcmp (text, (char *)AllIMEList.arrIME_Base[j]->cname)) {
				matched = j;
				break;
			}
		}

		if (matched == -1) continue;

		TempSelectedIMEList.arrIME_Base[TempSelectedIMEList.nIME_Num] = AllIMEList.arrIME_Base[matched];
		TempSelectedIMEList.nIME_Num++;
		gSelData.nActiveSelectItem = TempSelectedIMEList.nIME_Num;
	}

	if (cnt > 0) SelectAux_Reset_IMEList(&TempSelectedIMEList);
}

void SelectAux_AddAll_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	DEBUG_printf(" SelectAux_AddAll_cb ===\n");

	TempSelectedIMEList = AllIMEList;
	SelectAux_Reset_IMEList(&TempSelectedIMEList);
}

void SelectAux_Remove_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	XmString *selectlist = NULL;
	char *text;
	int i, j, matched, cnt = 0;

	DEBUG_printf(" SelectAux_Remove_cb ===\n");
	XtVaGetValues (gSelData.wdtSelectedList,
		XmNselectedItemCount, &cnt,
		XmNselectedItems,     &selectlist,
		NULL);

	DEBUG_printf("cnt:%d\n", cnt);

	for(i=0; i<cnt; i++) {
		if (!XmStringGetLtoR (selectlist[i], XmFONTLIST_DEFAULT_TAG, &text))
			continue;
		
		DEBUG_printf("%d:  %s\n", i, text);

		/* check the sequence number of the item */
		matched = -1;
		for (j=0; j<TempSelectedIMEList.nIME_Num; j++) {
			if (!strcmp (text, (char *)TempSelectedIMEList.arrIME_Base[j]->cname)) {
				matched = j;
				break;
			}
		}

		if (matched == -1) continue;

		for (j = matched; j<TempSelectedIMEList.nIME_Num; j++) 
			TempSelectedIMEList.arrIME_Base[j] = TempSelectedIMEList.arrIME_Base[j+1];
		TempSelectedIMEList.nIME_Num--;
	}

	if (cnt > 0) SelectAux_Reset_IMEList(&TempSelectedIMEList);
}

void SelectAux_RemoveAll_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	DEBUG_printf(" SelectAux_RemoveAll_cb ===\n");
	TempSelectedIMEList.nIME_Num = 0;
	SelectAux_Reset_IMEList(&TempSelectedIMEList);
}

void SelectAux_MoveUp_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	XmString *selectlist = NULL;
	char *text;
	int i, j, matched, cnt = 0;
	IMEBaseRec *temp;

	DEBUG_printf(" SelectAux_MoveUp_cb ===\n");
	XtVaGetValues (gSelData.wdtSelectedList,
		XmNselectedItemCount, &cnt,
		XmNselectedItems,     &selectlist,
		NULL);

	DEBUG_printf("cnt:%d\n", cnt);

	for(i=0; i<cnt; i++) {
		if (!XmStringGetLtoR (selectlist[i], XmFONTLIST_DEFAULT_TAG, &text))
			continue;
		
		DEBUG_printf("%d:  %s\n", i, text);

		/* check the sequence number of the item */
		matched = -1;
		for (j=0; j<TempSelectedIMEList.nIME_Num; j++) {
			if (!strcmp (text, (char *)TempSelectedIMEList.arrIME_Base[j]->cname)) {
				matched = j;
				break;
			}
		}

		/* if matched is -1 or 0, skip it */
		if (matched <= 0) continue;

		temp = TempSelectedIMEList.arrIME_Base[matched - 1];
		TempSelectedIMEList.arrIME_Base[matched - 1] = TempSelectedIMEList.arrIME_Base[matched];
		TempSelectedIMEList.arrIME_Base[matched] = temp;
	}

	if (cnt > 0) SelectAux_Reset_IMEList(&TempSelectedIMEList);
}

void SelectAux_MoveDown_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	XmString *selectlist = NULL;
	char *text;
	int i, j, matched, cnt = 0;
	IMEBaseRec *temp;

	DEBUG_printf(" SelectAux_MoveDown_cb ===\n");
	XtVaGetValues (gSelData.wdtSelectedList,
		XmNselectedItemCount, &cnt,
		XmNselectedItems,     &selectlist,
		NULL);

	DEBUG_printf("cnt:%d\n", cnt);

	for(i=0; i<cnt; i++) {
		if (!XmStringGetLtoR (selectlist[i], XmFONTLIST_DEFAULT_TAG, &text))
			continue;
		
		DEBUG_printf("%d:  %s\n", i, text);

		/* check the sequence number of the item */
		matched = -1;
		for (j=0; j<TempSelectedIMEList.nIME_Num; j++) {
			if (!strcmp (text, (char *)TempSelectedIMEList.arrIME_Base[j]->cname)) {
				matched = j;
				break;
			}
		}

		/* if matched is -1 or the last item, skip it */
		if (matched == -1) continue;
		if (matched == TempSelectedIMEList.nIME_Num - 1) continue;

		temp = TempSelectedIMEList.arrIME_Base[matched + 1];
		TempSelectedIMEList.arrIME_Base[matched + 1] = TempSelectedIMEList.arrIME_Base[matched];
		TempSelectedIMEList.arrIME_Base[matched] = temp;
	}

	if (cnt > 0) SelectAux_Reset_IMEList(&TempSelectedIMEList);
}

void SelectAux_OK_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	int i, nSelected = 0;

	DEBUG_printf(" SelectAux_OK_cb ===\n");
	SelectedIMEList = TempSelectedIMEList;

	Save_IMEList_To_Profile(&SelectedIMEList);
	SelectAux_Update_IMEInfo_Request();

	SelectAux_Hide();
	SelectAux_Change_Status_Request(0);
}

void SelectAux_Apply_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	DEBUG_printf(" SelectAux_Apply_cb ===\n");

	SelectedIMEList = TempSelectedIMEList;

	Save_IMEList_To_Profile(&SelectedIMEList);
	SelectAux_Update_IMEInfo_Request();
}

void SelectAux_Reset_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	DEBUG_printf(" SelectAux_Reset_cb ===\n");

	TempSelectedIMEList = SelectedIMEList;
	SelectAux_Reset_IMEList(&TempSelectedIMEList);
}

void SelectAux_Cancel_cb(Widget widget, XtPointer pClientData, XtPointer pCallData)
{
	DEBUG_printf(" SelectAux_Cancel_cb ===\n");
	SelectAux_Hide();
	SelectAux_Change_Status_Request(0);
}

void SelectAux_Show()
{
	Display *pDisplay = XtDisplay(gSelData.wdtShell);
	Window window = XtWindow(gSelData.wdtShell);

	DEBUG_printf("Show SelectAux\n");
	XtMapWidget(gSelData.wdtShell);
	XRaiseWindow(pDisplay, window);
	
	TempSelectedIMEList = SelectedIMEList;
	SelectAux_Reset_IMEList(&TempSelectedIMEList);
	XFlush(pDisplay);
}

void SelectAux_Hide()
{
	XtUnmapWidget(gSelData.wdtShell);
}
