/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "IMProtocol.hh"
#include "IMProtoHandler.hh"
#include "IMArg.h"

int
IMProtocol::countOnKeys() const {
  return on_keys.count();
}

int
IMProtocol::countOffKeys() const {
  return off_keys.count();
}

IMTriggerKey&
IMProtocol::getOnKey(unsigned int index) const {
  return on_keys.getKey(index);
}

IMTriggerKey&
IMProtocol::getOffKey(unsigned int index) const {
  return off_keys.getKey(index);
}

int
IMProtocol::countLanguages() const {
  return lang_list.count();
}

CompoundString&
IMProtocol::getLang(unsigned int index) const {
  return lang_list.getLang(index);
}

int
IMProtocol::countObjectDescriptors() const {
  return od_list.count();
}

IMObjectDescriptorStruct&
IMProtocol::getObjectDescriptor(unsigned int index) const {
  return od_list.getObjectDescriptor(index);
}

IMObjectDescriptorStruct&
IMProtocol::getFirstObjectDescriptor() {
  return od_list.getFirstObjectDescriptor();
}

IMObjectDescriptorStruct&
IMProtocol::getNextObjectDescriptor() {
  return od_list.getNextObjectDescriptor();
}

int
IMProtocol::countIME() const {
  return ime_list.count();
}

IMEditorStruct&
IMProtocol::getIME(unsigned int index) const {
  return ime_list.getIME(index);
}

IMEditorStruct&
IMProtocol::getFirstIME() {
  return ime_list.getFirstIME();
}

IMEditorStruct&
IMProtocol::getNextIME() {
  return ime_list.getNextIME();
}

const CompoundString&
IMProtocol::getPrimaryLocale() const {
  return input_locale;
}

int
IMProtocol::parseArgs(int mode, IMArg *args, int n) {
  if (n == 0) return 0;
  if (mode == IMProtocol::OPEN || mode == IMProtocol::SET) {
    for (IMArg *argp = args; argp < &args[n]; argp++) {
      switch (argp->id) {
      case ServerName:
	im_name = argp->value;
	break;
      case TransportAddress:
	im_address = argp->value;
	break;
      case VendorName:
	vendor_name = argp->value;
	break;
      case PrimaryInputLocale:
	input_locale = argp->value;
	break;
      case LanguageList:
	lang_list = *(IMLanguageList*)argp->value;
	break;
      case ConversionOnKeys:
	on_keys = *(IMTriggerKeyList*)argp->value;
	break;
      case ConversionOffKeys:
	off_keys = *(IMTriggerKeyList*)argp->value;
	break;
      case ProtocolHandler:
	proto_handler = (IMProtoHandler*)argp->value;
	break;
      case ObjectDescriptors:
	od_list = *(IMObjectDescriptorList*)argp->value;
	break;
      case IMEDescriptors:
	ime_list = *(IMEditorDescriptorList*)argp->value;
	break;
      default:
	break;
      }
    }
  } else if (mode == IMProtocol::GET) {
    for (IMArg *argp = args; argp < &args[n]; argp++) {
      switch (argp->id) {
      case ServerName:
	{
	  char **pp = (char**)argp->value;
	  *pp = im_name;
	  break;
	}
      case TransportAddress:
	{
	  char **pp = (char**)argp->value;
	  *pp = im_address;
	  break;
	}
      }
    }
    return 0;
  }
  return 0;
}

IMProtocol::IMProtocol(IMArg *args, int n) {
  proto_handler = 0;
  parseArgs(IMProtocol::OPEN, args, n);
}

IMProtocol::~IMProtocol() {}

int
IMProtocol::set_values(IMArg *args, int n) {
  return parseArgs(IMProtocol::SET, args, n);
}

int
IMProtocol::get_values(IMArg *args, int n) {
  return parseArgs(IMProtocol::GET, args, n);
}

IMTransAccept*
IMProtocol::getIMTransAccept(IMTransListen *trans_listen) const
{
  return proto_handler->getIMTransAccept(trans_listen);
}
