/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

// IceIconPreview.cpp
// header -> IceIconPreview.h

#include "IceIconPreview.h"

#include <qpixmap.h>
#include <qlabel.h>
#include <qimage.h>

#include "noIcon.xpm"

// constructor
IceIconPreview::IceIconPreview(QWidget *parent) : QWidget(parent) {
  setMinimumWidth(60);
  // label for displaying preview pixmap
  label = new QLabel(this);
  label->setFixedSize(32,32);
  label->setFrameStyle(QFrame::Panel | QFrame::Raised);
  label->setLineWidth(2);
  label->setScaledContents(true);
  label->setPixmap(QPixmap(noIcon));
}

// public
void IceIconPreview::previewUrl(const QUrl &u) {
  QString path = u.path();
  QPixmap pix(path);
  if (pix.isNull())
    label->setPixmap(QPixmap(noIcon));
  else
    label->setPixmap(pix);
}
