
#include <stdlib.h>
#include <stdio.h>

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN
/* #include <winsock2.h> */
#include <winsock.h>
#include <mmsystem.h>
#include <fcntl.h>
#include <io.h>
#include <direct.h>
#include <process.h>
#include <winbase.h>
#else /*  *NIX  */
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <stdarg.h>
#include <signal.h>
#include <ctype.h>
#include <stdarg.h>
#include <errno.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <unistd.h>
#endif /* !win32 */

#include "sock.h"
#include "util.h"
#include "shout.h"

sock_t
sock_connect (char *hostname, int port)
{
	sock_t sockfd;
	struct sockaddr_in sin, server;
	struct hostent *host;

#ifdef _WIN32
	unsigned int addr;

#endif /* WIN32 */

	sockfd = socket (AF_INET, SOCK_STREAM, 0);	/* Use TCP */
	if (sockfd == INVALID_SOCKET) {
		sock_close (sockfd);
		return INVALID_SOCKET;
	}
	memset (&sin, 0, sizeof (sin));
	memset (&server, 0, sizeof (struct sockaddr_in));

	scream(VERBOSE, "Resolving hostname %s...\n", hostname);

#ifdef _WIN32
	/*
	 * Attempt to detect if we should call gethostbyname() or 
	 * gethostbyaddr() 
	 */

	if (isalpha (hostname[0])) {	/* server address is a name */
		host = gethostbyname (hostname);
	} else {		/* Convert nnn.nnn address to a usable one */
		addr = inet_addr (hostname);
		host = gethostbyaddr ((char *) &addr, 4, AF_INET);
	}
	if (host == NULL) {
		fprintf (stderr, "Cannot resolve address [%s]: Error %d\n",
			 hostname, WSAGetLastError ());
		sock_close (sockfd);
		return -1;
	}
	memcpy (&server.sin_addr, host->h_addr, host->h_length);
#else
	/* Bet you this works under win32 too */
	if (isdigit ((int) hostname[0]) && isdigit ((int) (hostname[strlen (hostname) - 1]))) {
		if (inet_aton (hostname, (struct in_addr *) &sin.sin_addr) == 0) {
			scream (VERBOSE, "ERROR: Invalid ip number %s", hostname);
			sock_close (sockfd);
			return -1;
		}
		memcpy (&server.sin_addr, &sin.sin_addr, sizeof (sin));
	} else {
		host = gethostbyname (hostname);
		if (host == NULL) {
			sock_close (sockfd);
			return -1;
		}
		memcpy (&server.sin_addr, host->h_addr, host->h_length);
	}
#endif /* win32 */

	server.sin_family = AF_INET;
	server.sin_port = htons (port);

	if (connect (sockfd, (struct sockaddr *) &server, sizeof (server)) == 0) {
		return sockfd;
	} else {
		sock_close (sockfd);
		return SOCKET_ERROR;
	}
}

int 
sock_close (sock_t sockfd)
{
#ifdef _WIN32
	return closesocket (sockfd);
#else
	return close (sockfd);
#endif
}

#define HEX_ESCAPE '%'
#define ACCEPTABLE(a)  (a >= 32 && a < 128 && ((isAcceptable[a - 32]) & mask))

unsigned char isAcceptable[96] =
{
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF, 0xE, 0x0, 0xF, 0xF, 0xC,
	0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0x8, 0x0, 0x0, 0x0, 0x0, 0x0,
	0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF,
	0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0x0, 0x0, 0x0, 0x0, 0xF,
	0x0, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF,
	0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0xF, 0x0, 0x0, 0x0, 0x0, 0x0
};

char *hex = "0123456789ABCDEF";

int mask = 0x8;

char *
url_encode (char *str, char **result_p)
{
	const char *p;
	char *q;
	char *result;
	int unacceptable = 0;

	if (!str) {
		return NULL;
	}
	for (p = str; *p; p++)
		if (!ACCEPTABLE ((unsigned char) (*p)))
			unacceptable++;

	result = (char *) malloc (p - str + unacceptable + unacceptable + 1);

	*result_p = result;

	for (q = result, p = str; *p; p++) {
		unsigned char a = *p;

		if (!ACCEPTABLE (a)) {
			*q++ = HEX_ESCAPE;	/* Means hex commming */
			*q++ = hex[a >> 4];
			*q++ = hex[a & 15];
		} else
			*q++ = *p;
	}
	*q++ = 0;		/* Terminate */
	return result;
}

/* Never, ever, _ever_ ever _ever_ put a write_log or sock_write in here */
int 
sock_write (sock_t sockfd, char *fmt,...)
{
	char buff[BUFSIZE];
	va_list ap;
	int write_bytes;

	va_start (ap, fmt);
#ifdef HAVE_VSNPRINTF
	vsnprintf (buff, BUFSIZE, fmt, ap);
#else
	vsprintf (buff, fmt, ap);
#endif

	write_bytes = send (sockfd, buff, strlen (buff), 0);

	va_end (ap);
	return ((unsigned) write_bytes == strlen (buff) ? 1 : 0);
}

int
is_recoverable (int error)
{
#ifdef _WIN32
	error = WSAGetLastError();
	if ((error == WSAEWOULDBLOCK) || (error == WSAEINTR)) 
		return 1;
#else
	if ((error == EAGAIN) || (error == EINTR))
		return 1;
#endif
	return 0;
}



