<?php
// File           showimage.php / ibWebAdmin
// Purpose        called by showblob to load the given blob and display the data as an image
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <01/10/25 21:36:41 lb>
//
// $Id: showimage.php,v 1.5 2003/10/05 16:17:19 lbrueckner Exp $


// GET-Variables specifying the blob
//
//       $table: table containing the blob
//       $col  : column containing the blob
//       $where: sql-where-clause specifying the primary keys to fetch the blob

require('./inc/configuration.inc.php');
require('./inc/session.inc.php');

session_start();
localize_session_vars();

require('./lang/' . (isset($s_cust) ? $s_cust['language'] : LANGUAGE) . '.inc.php');
require('./inc/functions.inc.php');

$dbhandle = db_connect()
     or ib_error();

$table = $HTTP_GET_VARS['table'];
$col   = $HTTP_GET_VARS['col'];
$where = $HTTP_GET_VARS['where'];
$sql = sprintf('SELECT %s FROM %s %s', $col, $table, $where);
$blob = get_blob_content($sql);

switch ($s_watch_blobas[$col]) {
    case 'png':
        header('Content-Type: image/png');
        break;
    case 'jpg':
        header('Content-Type: image/jpg');
        break;
    case 'gif':
        header('Content-Type: image/gif');
        break;
}

echo $blob;

?>
