<?php
// File           sql_output.php / ibWebAdmin
// Purpose        html sequence for the sql_output-panel in sql.php
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <00/09/12 15:03:13 lb>
//
// $Id: sql_output.php,v 1.9 2004/01/28 15:27:49 lbrueckner Exp $


// Variables      $results   :   array holding the results from the ibase_query calls
//                $isql_flag :   TRUE if the query was done by isql, FALSE if by php 
//                $binary_output : output lines from isql

?>
<form method="post" action="<?php echo $HTTP_SERVER_VARS['PHP_SELF']; ?>" name="sql_output_form">
<?php hidden_session_field(); ?>
<table cellpadding="3" cellspacing="0">
  <tr>
    <td>
<?php

// display the output from isql
if (isset($isql_flag)  ||  isset($plan_flag)) {
    array_shift($binary_output);      // discard the first line
    foreach($binary_output as $line) {
        $line = str_replace(' ', '&nbsp;', $line);
	$line = nl2br($line);
	echo $line."<br>\n";
    }
}

elseif (isset($results)) {

    ob_start();

    foreach ($results as $idx => $result) {
        if (!is_array($result)  ||  empty($result)) {
            continue;
        }
       echo get_result_table($result, $fieldinfo[$idx], $idx);
       echo sql_export_button($idx);
    }

    $s_sql['buffer'] = ob_get_contents();
    ob_end_flush();
}

elseif ($s_sql['buffer'] != '') {
    echo $s_sql['buffer'];
    echo '('.$sql_strings['DisplBuf'].')';
}

echo "    </td>\n  </tr>\n";

if ($s_sql['more'] === TRUE) {
?>
  <tr>
    <td>
      <input type="submit" name="sql_display_all" value="<?php echo $button_strings['DisplAll']; ?>">
    </td>
  </tr>
<?php

}

?>
</table>
</form>
