/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: PlayerControl.h,v 1.22 2004/05/03 14:02:29 comix Exp $
 *
 */


#ifndef PLAYER_CONTROL_H
#define PLAYER_CONTROL_H

#include "qwidget.h"
#include "qpixmap.h"
#include "qtimer.h"
#include "qlabel.h"
#include "config.h"
#include "qmessagebox.h"
#include "qspinbox.h"
#include "qtooltip.h"


#include "lib/Object.h"

class Hydrogen;
class MidiActivityWidget;
class CpuLoadWidget;
class Button;
class ToggleButton;
class HydrogenApp;
class CpuLoadWidget;
class MidiActivityWidget;


///
/// Player control panel
///
class PlayerControl : public QWidget, public Object
{
	Q_OBJECT
	public:
		PlayerControl(QWidget *parent);
		~PlayerControl();

	public slots:
		void playBtnClicked(Button* ref);
		void stopBtnClicked(Button* ref);
		void updatePlayerControl();
		void songModeBtnClicked(Button* ref);
		void liveModeBtnClicked(Button* ref);
		void bpmChanged();
		void jackTransportBtnClicked(Button* ref);

	private:
		static const uint width = 1500;	// FIXME... ;)
		static const uint height = 30;

		Hydrogen *m_pEngine;
		QPixmap m_background;

		ToggleButton *m_pPlayBtn;
		ToggleButton *m_pStopBtn;

		ToggleButton *m_pSongModeBtn;
		ToggleButton *m_pLiveModeBtn;

		ToggleButton *m_pJackTransportBtn;

		QSpinBox *m_pBpmSpinBox;

		CpuLoadWidget *m_pCpuLoadWidget;
		MidiActivityWidget *m_pMidiActivityWidget;
};



#endif
