/*
 *  JLib - Jacob's Library.
 *  Copyright (C) 2003, 2004  Juan Carlos Seijo Prez
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 * 
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Juan Carlos Seijo Prez
 *  jacob@mainreactor.net
 */

/** Menu en pantalla compuesto de imgenes.
 * @file    JImageMenu.h
 * @author  Juan Carlos Seijo Prez
 * @date    28/04/2004
 * @version 0.0.1 - 28/04/2004 - Primera versin.
 * @version 0.0.2 - 25/09/2004 - Modificacin del mtodo 2D de Pos() para aceptar floats (quita libertad sino).
 */

#ifndef _JIMAGEMENU_INCLUDED
#define _JIMAGEMENU_INCLUDED

#include <JLib/Graphics/JDrawable.h>
#include <JLib/Graphics/JImage.h>
#include <JLib/Util/JApp.h>
#include <JLib/Util/JString.h>
#include <JLib/Util/JTree.h>
#include <JLib/Util/JTimer.h>

/** Distribucin del men.
 */
typedef enum 
{
	JIMAGEMENU_LEFT = 1,                   /**< Alineado a la izquierda. */
	JIMAGEMENU_RIGHT,                      /**< Alineado a la derecha. */
	JIMAGEMENU_CENTER,                     /**< Centrado. */
	JIMAGEMENU_SAMELINE,                   /**< Todas las opciones en la misma lnea. */
	JIMAGEMENU_FREE,                       /**< Opciones en cualquier posicin */
} JImageMenuLayout;

/** Estructura de configuracin del men.
 */
struct JImageMenuConfig
{
	JImageMenuLayout layout;              /**< Distribucin del men. */
	bool trackMouse;                      /**< Indica si puede manejarse con ratn. */
	bool trackKeyboard;                   /**< Indica si puede manejarse con teclado. */
	bool trackJoystick;                   /**< Indica si puede manejarse con joystick/pad. */
	bool autoEnter;                       /**< Indica si desciende si no hay accin asociada. */
};

/** Opcin de men bsica.
 */
class JImageMenuEntry
{
 protected:
	JImage *image;                        /**< Imagen asociada a la opcin. */
	JImage *hiImage;                      /**< Imagen asociada a la opcin resaltada. */

	void (*Action)(void *data);           /**< Accin asociada a la opcin de men. */
	void *data;                           /**< Datos asociados a la opcin de men. */

 public:
	JImageMenuEntry(JImage *img, JImage *hiImg, void (*pAct)(void *) = 0, void *actionData = 0)
	: image(img), hiImage(hiImg), Action(pAct), data(actionData)
	{}

	/** Selecciona la opcin de men, llamando a la callback asociada, si existe.
	 * @return <b>true</b> en caso de haber accin asociada, <b>false</b> si no.
	 */
	bool Select();

	/** Devuelve la imagen asociada.
	 * @return La imagen asociada.
	 */
	JImage * Image() {return image;}

	/** Devuelve la imagen asociada al estado resaltado.
	 * @return La imagen asociada al estado resaltado.
	 */
	JImage * HiImage() {return hiImage;}

	/** Destruye el objeto.
	 */
	~JImageMenuEntry()
	{}
};

/** Encapsula un men de texto en pantalla.
 */
class JImageMenu : public JDrawable
{
	JTree<JImageMenuEntry *> options;       /**< rbol de opciones de men. */
	JTree<JImageMenuEntry *>::Iterator *curOption; /**< Opcin actual. */
	JImageMenuConfig config;              /**< Parmetros de configuracin del men. */
	
	/** Aplica la distribucin de men.
	 */
	void ApplyLayout(JTree<JImageMenuEntry *>::Iterator *it);

 public:
	/** Crea un men vaco.
	 */
	JImageMenu();

	/** Inicializa el men con la configuracin dada. Esta funcin debe
	 * ser llamada despus de haber rellenado el rbol del men.
	 * @param  cfg Configuracin del men.
	 * @return <b>true</b> Si todo fue bien, <b>false</b> si no se encontr la
	 * fuente dada.
	 */
	bool Init(JImageMenuConfig &cfg);

	/** Devuelve el iterador de opcin actual.
	 * @return Iterador de opcin actual.
	 */
	JTree<JImageMenuEntry *>::Iterator * Menu() {return curOption;}

	/** Establece la posicin del men. La alineacin se hace respecto de
	 * esta posicin.
	 * @param  x Posicin x.
	 * @param  y Posicin y.
	 */
	virtual void Pos(float x, float y);

	/** Funcin de dibujo del men.
	 */
	virtual void Draw();

	/** Procesa tecla arriba
	 */
	virtual void TrackKeyboard(SDL_keysym key);

	/** Procesa movimiento de mouse
	 */
	virtual void TrackMouse(s32 bt, s32 x, s32 y);

	/** Destruye el objeto y libera la memoria asociada.
	 */
	virtual ~JImageMenu()
	{
		for (options.Begin(); options.End(); options.Next())
			JDELETE(options.Cur());
		
		options.Clear();
	}
};

#endif // _JIMAGEMENU_INCLUDED
