/*
 *  JLib - Jacob's Library.
 *  Copyright (C) 2003, 2004  Juan Carlos Seijo Prez
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 * 
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Juan Carlos Seijo Prez
 *  jacob@mainreactor.net
 */

/** Funciones de utilidad para FLTK v1.1.4 (www.fltk.org).
 * @file    JFLTK.h
 * @author  Juan Carlos Seijo Prez
 * @date    07/01/2004
 * @version 0.0.1 - 07/01/2004 - Primera versin
 */

#ifndef _JFLTK_INCLUDED
#define _JFLTK_INCLUDED

#include <JLib/Util/JTypes.h>

/** Desplaza los elementos seleccionados en el navegador una lnea hacia arriba
 * @param brw Navegador a manipular.
 */
void JFLTK_SelectedUp(Fl_Browser *brw)
{
  for (s32 i = 2; i <= brw->size(); ++i)
  {
    if (0 != brw->selected(i) &&
        0 == brw->selected(i - 1))
    {
			brw->move(i - 1, i);
    }
  }
}

/** Desplaza los elementos seleccionados en el navegador una lnea hacia abajo.
 * @param brw Navegador a manipular.
 */
void JFLTK_SelectedDown(Fl_Browser *brw)
{
  for (s32 i = brw->size() - 1; i >= 1; --i)
  {
    if (0 != brw->selected(i))
    {
      if (0 == brw->selected(i + 1))
      {
        brw->move(i + 1, i);
      }
    }
  }
}

/** Borra los elementos seleccionados en el navegador.
 * @param brw Navegador a manipular.
 */
void JFLTK_RemoveSelected(Fl_Browser *brw)
{
  // Borra los seleccionados
  for (s32 i = 1; i <= brw->size(); ++i)
  {
    if (0 != brw->selected(i))
    {
      brw->remove(i);
      --i;
    }
  }
}

/** Comprueba si el navegador dado contiene la cadena dada ya.
 * @param brw Navegador donde buscar.
 * @param text Texto a buscar.
 * @return Si existe devuelve su ndice de lista. Si no, devuelve 0.
 */
s32 JFLTK_Contains(Fl_Browser *brw, const s8 *text)
{
  bool exists = false;
	s32 i = 0;
  for (i = 1; i <= brw->size() && !exists; ++i)
  {
    if (0 == strcmp(brw->text(i), text))
      exists = true;
  }
	
	if (exists)
		return i - 1;

  return 0;
}

/** Pide un nombre y comprueba que no exista ya el nombre en la lista.
 * 'filename' es un posible nombre de fichero o el valor por defecto.
 * @param  filename Nombre de fichero del que extraer el nombre a mostrar por defecto.
 * @param  brw Navegador donde buscar coincidencias del nombre elegido.
 * @return Nombre escogido o 0 si se cancela.
 */
const s8 * JFLTK_InputName(const s8 *filename, Fl_Browser *brw)
{
  const s8 *name = "";
  s8 *s;

  if (filename)
  {
    // Ofrece el nombre del fichero sin extensin por defecto
    // Busca el primer punto desde el final
    if (0 != (s = strrchr(filename, '.')))
      *s = 0;

    // Busca la primera barra desde el final
    if (0 == (s = strrchr(filename, '/')))
      name = filename;
    else
      name = s + 1;
  }

  name = fl_input("Nombre", name);
  while (name != 0 && JFLTK_Contains(brw, name))
  {
    fl_ask("El nombre ya existe,\npor favor elija otro.");
    name = fl_input("Nombre", name);
  }

  return name;
}

#endif // _JFLTK_INCLUDED
