.TH "hmmalign" 1 "Dec 1998" "HMMER 2.1.1" "HMMER Manual"

.SH NAME
.TP 
hmmalign - align sequences to an HMM profile

.SH SYNOPSIS
.B hmmalign
.I [options]
.I hmmfile
.I seqfile

.SH DESCRIPTION

.B hmmalign
reads an HMM file from
.I hmmfile
and a set of sequences from 
.I seqfile,
aligns the sequences to the profile HMM, 
and outputs a multiple sequence alignment.

.PP
.I seqfile 
may be in any unaligned or aligned file format
accepted by HMMER. If it is in a multiple alignment format
(e.g. MSF, SELEX, ClustalW), the existing alignment
is ignored.

.SH OPTIONS

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.B -m
Include in the alignment only those symbols aligned to match states.
Do not show symbols assigned to insert states. 

.TP 
.BI -o " <f>"
Save alignment to file
.I <f>
instead of to standard output.

.TP
.B -q
quiet; suppress all output except the alignment itself.
Useful for piping or redirecting the output.

.SH EXPERT OPTIONS

.TP
.BI --mapali " <f>"
Reads an alignment from file 
.I <f>
and aligns it as a single object to the HMM; e.g. the alignment in 
.I <f> 
is held fixed. 
This allows you to align sequences to a model with 
.B hmmalign
and view them in the context of an existing trusted
multiple alignment. 
The alignment to the alignment is defined by a "map" kept
in the HMM, and so is fast and guaranteed to be consistent
with the way the HMM was constructed from the alignment.
The alignment in the file
.I <f> 
must be exactly the alignment that the HMM was built from.
Compare the
.B --withali 
option.

.TP 
.BI --withali " <f>"
Reads an alignment from file 
.I <f>
and aligns it as a single object to the HMM; e.g. the alignment in 
.I <f> 
is held fixed.
This allows you to align sequences to a model with 
.B hmmalign
and view them in the context of an existing trusted
multiple alignment. The alignment to the alignment is
done with a heuristic (nonoptimal) dynamic programming procedure,
which may be somewhat slow and is not guaranteed to
be completely consistent with the way the HMM was
constructed (though it should be quite close).
However, any alignment can be used, not just the alignment that
the HMM was built from. Compare the
.B --mapali 
option.

.SH SEE ALSO

.PP
hmmalign hmmbuild hmmcalibrate hmmconvert hmmemit hmmfetch hmmindex hmmpfam hmmsearch
.PP
User guide and tutorial: Userguide.ps
.PP
WWW: 
.B http://hmmer.wustl.edu/

.SH AUTHOR

This software and documentation is Copyright (C) 1992-1998 Washington
University School of Medicine.  It is freely distributable under terms
of the GNU General Public License. See COPYING in the source code
distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


