# include "gui.h"

/*
 *  interface for parameter window
 */
GtkWidget*
create_wpar (void)
{
  GtkWidget *wpar;
  GtkWidget *param_vbox;
  GtkWidget *paramnotebook;

  GtkWidget *table_fsk;
  GtkWidget *label_mark;
  GtkWidget *label_space;
  GtkWidget *fskmark;
  GList *fskmark_items = NULL;
  GtkWidget *fskmarkfreq;
  GtkWidget *fskspace;
  GList *fskspace_items = NULL;
  GtkWidget *fskspacefreq;
  GtkWidget *label_FSK;

  GtkWidget *table_rtty;
  GtkWidget *label_baudrate;
  GtkWidget *rttyinvert;
  GtkWidget *rttyrxtxinvert;
  GtkWidget *rttybaudrate;
  GtkWidget *label_RTTY;

  GtkWidget *table_amtor;
  GtkWidget *label_amtor_retries;
  GtkWidget *label_amtor_txdelay;
  GtkWidget *label_amtor_mycall;
  GtkWidget *label_amtor_selfeccall;
  GtkWidget *label_amtor_destcall;
  GtkWidget *amtorrxtxinvert;
  GtkWidget *amtorinvert;
  GtkWidget *amtordestcall;
  GtkWidget *amtorselfeccall;
  GtkWidget *amtormycall;
  GtkWidget *amtortxdelay;
  GtkWidget *amtorretry;
  GtkWidget *label_amtor;

  GtkWidget *hbox_pactor_standard;
  GtkWidget *frame_pactor_standard;
  GtkWidget *table_pactor_standard;
  GtkWidget *label_pactor_mycall;
  GtkWidget *label_pactor_txdelay;
  GtkWidget *label_pactor_retries;
  GtkWidget *pactorlongpath;
  GtkWidget *pactorcall;
  GtkWidget *pactormycall;
  GtkWidget *pactortxdelay;
  GtkWidget *pactorretry;
  GtkWidget *label_pactor_destcall;
  GtkWidget *label_pactor_splp;
  GtkWidget *frame_pactor_advanced;
  GtkWidget *table_pactor_advanced;
  GtkWidget *pactorcrc0;
  GtkWidget *pactorcrc1;
  GtkWidget *pactorcrc3;
  GtkWidget *pactorcrc2;
  GtkWidget *label_pactor_crc100chg;
  GtkWidget *label_pactor_crc100;
  GtkWidget *label_pactor_crc200chg;
  GtkWidget *label_pactor_crc200;
  GtkWidget *label_Pactor;

  GtkWidget *table_Gtor;
  GtkWidget *gtordestcall;
  GtkWidget *gtormycall;
  GtkWidget *gtortxdelay;
  GtkWidget *gtorretry;
  GtkWidget *label_gtor_destcall;
  GtkWidget *label_gtor_mycall;
  GtkWidget *label_gtor_txdelay;
  GtkWidget *label_gtor_retries;
  GtkWidget *label_Gtor;

  GtkWidget *table_mt63;
  GtkWidget *label_mt63;
  GtkWidget *label_mt63_bandwidth;
  GtkWidget *mt63_bandwidth;
  GList *mt63_bandwidth_items = NULL;
  GtkWidget *mt63_bandwidth_value;
  GtkWidget *label_mt63_integration;
  GtkWidget *mt63_integration;
  GtkWidget *label_mt63_cwcall;
  GtkWidget *mt63_cwcall;
  GtkWidget *mt63_doubleinterleave;

  GtkWidget *toolbar1;
  GtkWidget *parok;
  GtkWidget *parcancel;
  GtkAccelGroup *par_accels;

  wpar = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (wpar, "wpar");
  gtk_object_set_data (GTK_OBJECT (wpar), "wpar", wpar);
  gtk_window_set_title (GTK_WINDOW (wpar), _("Parameters"));
  gtk_window_set_policy (GTK_WINDOW (wpar), FALSE, TRUE, TRUE);
  gtk_window_set_wmclass (GTK_WINDOW (wpar), "hfterm", "hfterm");

  par_accels = gtk_accel_group_new ();
  gtk_accel_group_attach(par_accels, GTK_OBJECT(wpar));
  
  param_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (param_vbox, "param_vbox");
  gtk_widget_ref (param_vbox);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "param_vbox", param_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (param_vbox);
  gtk_container_add (GTK_CONTAINER (wpar), param_vbox);

  paramnotebook = gtk_notebook_new ();
  gtk_widget_set_name (paramnotebook, "paramnotebook");
  gtk_widget_ref (paramnotebook);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "paramnotebook", paramnotebook,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (paramnotebook);
  gtk_box_pack_start (GTK_BOX (param_vbox), paramnotebook, TRUE, TRUE, 0);

  table_fsk = gtk_table_new (2, 2, FALSE);
  gtk_widget_set_name (table_fsk, "table_fsk");
  gtk_widget_ref (table_fsk);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "table_fsk", table_fsk,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_fsk);
  gtk_container_add (GTK_CONTAINER (paramnotebook), table_fsk);

  label_mark = gtk_label_new (_("Mark Frequency"));
  gtk_widget_set_name (label_mark, "label_mark");
  gtk_widget_ref (label_mark);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_mark", label_mark,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_mark);
  gtk_table_attach (GTK_TABLE (table_fsk), label_mark, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_mark), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_mark), 5, 0);

  label_space = gtk_label_new (_("Space Frequency"));
  gtk_widget_set_name (label_space, "label_space");
  gtk_widget_ref (label_space);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_space", label_space,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_space);
  gtk_table_attach (GTK_TABLE (table_fsk), label_space, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_space), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_space), 5, 0);

  fskmark = gtk_combo_new ();
  gtk_widget_set_name (fskmark, "fskmark");
  gtk_widget_ref (fskmark);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "fskmark", fskmark,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fskmark);
  gtk_table_attach (GTK_TABLE (table_fsk), fskmark, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  fskmark_items = g_list_append (fskmark_items, (gpointer) _("1800"));
  fskmark_items = g_list_append (fskmark_items, (gpointer) _("2400"));
  gtk_combo_set_popdown_strings (GTK_COMBO (fskmark), fskmark_items);
  g_list_free (fskmark_items);

  fskmarkfreq = GTK_COMBO (fskmark)->entry;
  gtk_widget_set_name (fskmarkfreq, "fskmarkfreq");
  gtk_widget_ref (fskmarkfreq);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "fskmarkfreq", fskmarkfreq,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fskmarkfreq);
  gtk_entry_set_text (GTK_ENTRY (fskmarkfreq), _("1800"));

  fskspace = gtk_combo_new ();
  gtk_widget_set_name (fskspace, "fskspace");
  gtk_widget_ref (fskspace);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "fskspace", fskspace,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fskspace);
  gtk_table_attach (GTK_TABLE (table_fsk), fskspace, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  fskspace_items = g_list_append (fskspace_items, (gpointer) _("1600"));
  fskspace_items = g_list_append (fskspace_items, (gpointer) _("2200"));
  gtk_combo_set_popdown_strings (GTK_COMBO (fskspace), fskspace_items);
  g_list_free (fskspace_items);

  fskspacefreq = GTK_COMBO (fskspace)->entry;
  gtk_widget_set_name (fskspacefreq, "fskspacefreq");
  gtk_widget_ref (fskspacefreq);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "fskspacefreq", fskspacefreq,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (fskspacefreq);
  gtk_entry_set_text (GTK_ENTRY (fskspacefreq), _("1600"));

  label_FSK = gtk_label_new (_("FSK"));
  gtk_widget_set_name (label_FSK, "label_FSK");
  gtk_widget_ref (label_FSK);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_FSK", label_FSK,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_FSK);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (paramnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (paramnotebook), 0), label_FSK);

  table_rtty = gtk_table_new (3, 2, FALSE);
  gtk_widget_set_name (table_rtty, "table_rtty");
  gtk_widget_ref (table_rtty);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "table_rtty", table_rtty,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_rtty);
  gtk_container_add (GTK_CONTAINER (paramnotebook), table_rtty);

  label_baudrate = gtk_label_new (_("Baud Rate"));
  gtk_widget_set_name (label_baudrate, "label_baudrate");
  gtk_widget_ref (label_baudrate);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_baudrate", label_baudrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_baudrate);
  gtk_table_attach (GTK_TABLE (table_rtty), label_baudrate, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_baudrate), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_baudrate), 5, 0);

  rttyinvert = gtk_check_button_new_with_label (_("Invert"));
  gtk_widget_set_name (rttyinvert, "rttyinvert");
  gtk_widget_ref (rttyinvert);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "rttyinvert", rttyinvert,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (rttyinvert);
  gtk_table_attach (GTK_TABLE (table_rtty), rttyinvert, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  rttyrxtxinvert = gtk_check_button_new_with_label (_("RX/TX invert"));
  gtk_widget_set_name (rttyrxtxinvert, "rttyrxtxinvert");
  gtk_widget_ref (rttyrxtxinvert);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "rttyrxtxinvert", rttyrxtxinvert,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (rttyrxtxinvert);
  gtk_table_attach (GTK_TABLE (table_rtty), rttyrxtxinvert, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  rttybaudrate = gtk_entry_new_with_max_length (5);
  gtk_widget_set_name (rttybaudrate, "rttybaudrate");
  gtk_widget_ref (rttybaudrate);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "rttybaudrate", rttybaudrate,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (rttybaudrate);
  gtk_table_attach (GTK_TABLE (table_rtty), rttybaudrate, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (rttybaudrate), _("45"));

  label_RTTY = gtk_label_new (_("RTTY"));
  gtk_widget_set_name (label_RTTY, "label_RTTY");
  gtk_widget_ref (label_RTTY);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_RTTY", label_RTTY,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_RTTY);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (paramnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (paramnotebook), 1), label_RTTY);

  
  table_amtor = gtk_table_new (7, 2, FALSE);
  gtk_widget_set_name (table_amtor, "table_amtor");
  gtk_widget_ref (table_amtor);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "table_amtor", table_amtor,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_amtor);
  gtk_container_add (GTK_CONTAINER (paramnotebook), table_amtor);

  label_amtor_retries = gtk_label_new (_("Retries"));
  gtk_widget_set_name (label_amtor_retries, "label_amtor_retries");
  gtk_widget_ref (label_amtor_retries);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_amtor_retries", label_amtor_retries,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_amtor_retries);
  gtk_table_attach (GTK_TABLE (table_amtor), label_amtor_retries, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_amtor_retries), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_amtor_retries), 5, 0);

  label_amtor_txdelay = gtk_label_new (_("TX Delay (ms)"));
  gtk_widget_set_name (label_amtor_txdelay, "label_amtor_txdelay");
  gtk_widget_ref (label_amtor_txdelay);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_amtor_txdelay", label_amtor_txdelay,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_amtor_txdelay);
  gtk_table_attach (GTK_TABLE (table_amtor), label_amtor_txdelay, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_amtor_txdelay), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_amtor_txdelay), 5, 0);

  label_amtor_mycall = gtk_label_new (_("Mycall"));
  gtk_widget_set_name (label_amtor_mycall, "label_amtor_mycall");
  gtk_widget_ref (label_amtor_mycall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_amtor_mycall", label_amtor_mycall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_amtor_mycall);
  gtk_table_attach (GTK_TABLE (table_amtor), label_amtor_mycall, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_amtor_mycall), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_amtor_mycall), 5, 0);

  label_amtor_selfeccall = gtk_label_new (_("Selective FEC Call"));
  gtk_widget_set_name (label_amtor_selfeccall, "label_amtor_selfeccall");
  gtk_widget_ref (label_amtor_selfeccall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_amtor_selfeccall", label_amtor_selfeccall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_amtor_selfeccall);
  gtk_table_attach (GTK_TABLE (table_amtor), label_amtor_selfeccall, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_amtor_selfeccall), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_amtor_selfeccall), 5, 0);

  label_amtor_destcall = gtk_label_new (_("Destination Call"));
  gtk_widget_set_name (label_amtor_destcall, "label_amtor_destcall");
  gtk_widget_ref (label_amtor_destcall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_amtor_destcall", label_amtor_destcall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_amtor_destcall);
  gtk_table_attach (GTK_TABLE (table_amtor), label_amtor_destcall, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_amtor_destcall), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_amtor_destcall), 5, 0);

  amtorrxtxinvert = gtk_check_button_new_with_label (_("RX/TX invert"));
  gtk_widget_set_name (amtorrxtxinvert, "amtorrxtxinvert");
  gtk_widget_ref (amtorrxtxinvert);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "amtorrxtxinvert", amtorrxtxinvert,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (amtorrxtxinvert);
  gtk_table_attach (GTK_TABLE (table_amtor), amtorrxtxinvert, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  amtorinvert = gtk_check_button_new_with_label (_("Invert"));
  gtk_widget_set_name (amtorinvert, "amtorinvert");
  gtk_widget_ref (amtorinvert);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "amtorinvert", amtorinvert,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (amtorinvert);
  gtk_table_attach (GTK_TABLE (table_amtor), amtorinvert, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  amtordestcall = gtk_entry_new_with_max_length (4);
  gtk_widget_set_name (amtordestcall, "amtordestcall");
  gtk_widget_ref (amtordestcall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "amtordestcall", amtordestcall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (amtordestcall);
  gtk_table_attach (GTK_TABLE (table_amtor), amtordestcall, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (amtordestcall), _("NONE"));

  amtorselfeccall = gtk_entry_new_with_max_length (4);
  gtk_widget_set_name (amtorselfeccall, "amtorselfeccall");
  gtk_widget_ref (amtorselfeccall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "amtorselfeccall", amtorselfeccall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (amtorselfeccall);
  gtk_table_attach (GTK_TABLE (table_amtor), amtorselfeccall, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (amtorselfeccall), _("NONE"));

  amtormycall = gtk_entry_new_with_max_length (4);
  gtk_widget_set_name (amtormycall, "amtormycall");
  gtk_widget_ref (amtormycall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "amtormycall", amtormycall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (amtormycall);
  gtk_table_attach (GTK_TABLE (table_amtor), amtormycall, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (amtormycall), _("NONE"));

  amtortxdelay = gtk_entry_new ();
  gtk_widget_set_name (amtortxdelay, "amtortxdelay");
  gtk_widget_ref (amtortxdelay);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "amtortxdelay", amtortxdelay,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (amtortxdelay);
  gtk_table_attach (GTK_TABLE (table_amtor), amtortxdelay, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (amtortxdelay), _("30"));

  amtorretry = gtk_entry_new ();
  gtk_widget_set_name (amtorretry, "amtorretry");
  gtk_widget_ref (amtorretry);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "amtorretry", amtorretry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (amtorretry);
  gtk_table_attach (GTK_TABLE (table_amtor), amtorretry, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (amtorretry), _("30"));

  label_amtor = gtk_label_new (_("Amtor"));
  gtk_widget_set_name (label_amtor, "label_amtor");
  gtk_widget_ref (label_amtor);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_amtor", label_amtor,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_amtor);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (paramnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (paramnotebook), 2), label_amtor);

  hbox_pactor_standard = gtk_hbox_new (TRUE, 2);
  gtk_widget_set_name (hbox_pactor_standard, "hbox_pactor_standard");
  gtk_widget_ref (hbox_pactor_standard);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "hbox_pactor_standard", hbox_pactor_standard,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox_pactor_standard);
  gtk_container_add (GTK_CONTAINER (paramnotebook), hbox_pactor_standard);

  frame_pactor_standard = gtk_frame_new (_("Standard"));
  gtk_widget_set_name (frame_pactor_standard, "frame_pactor_standard");
  gtk_widget_ref (frame_pactor_standard);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "frame_pactor_standard", frame_pactor_standard,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_pactor_standard);
  gtk_box_pack_start (GTK_BOX (hbox_pactor_standard), frame_pactor_standard, TRUE, TRUE, 0);

  table_pactor_standard = gtk_table_new (5, 2, FALSE);
  gtk_widget_set_name (table_pactor_standard, "table_pactor_standard");
  gtk_widget_ref (table_pactor_standard);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "table_pactor_standard", table_pactor_standard,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_pactor_standard);
  gtk_container_add (GTK_CONTAINER (frame_pactor_standard), table_pactor_standard);

  label_pactor_mycall = gtk_label_new (_("Mycall"));
  gtk_widget_set_name (label_pactor_mycall, "label_pactor_mycall");
  gtk_widget_ref (label_pactor_mycall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_pactor_mycall", label_pactor_mycall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_pactor_mycall);
  gtk_table_attach (GTK_TABLE (table_pactor_standard), label_pactor_mycall, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_pactor_mycall), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_pactor_mycall), 5, 0);

  label_pactor_txdelay = gtk_label_new (_("TX Delay (ms)"));
  gtk_widget_set_name (label_pactor_txdelay, "label_pactor_txdelay");
  gtk_widget_ref (label_pactor_txdelay);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_pactor_txdelay", label_pactor_txdelay,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_pactor_txdelay);
  gtk_table_attach (GTK_TABLE (table_pactor_standard), label_pactor_txdelay, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_pactor_txdelay), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_pactor_txdelay), 5, 0);

  label_pactor_retries = gtk_label_new (_("Retries"));
  gtk_widget_set_name (label_pactor_retries, "label_pactor_retries");
  gtk_widget_ref (label_pactor_retries);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_pactor_retries", label_pactor_retries,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_pactor_retries);
  gtk_table_attach (GTK_TABLE (table_pactor_standard), label_pactor_retries, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_pactor_retries), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_pactor_retries), 5, 0);

  pactorlongpath = gtk_check_button_new_with_label (_("Longpath"));
  gtk_widget_set_name (pactorlongpath, "pactorlongpath");
  gtk_widget_ref (pactorlongpath);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "pactorlongpath", pactorlongpath,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pactorlongpath);
  gtk_table_attach (GTK_TABLE (table_pactor_standard), pactorlongpath, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  pactorcall = gtk_entry_new_with_max_length (7);
  gtk_widget_set_name (pactorcall, "pactorcall");
  gtk_widget_ref (pactorcall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "pactorcall", pactorcall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pactorcall);
  gtk_table_attach (GTK_TABLE (table_pactor_standard), pactorcall, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_widget_set_usize (pactorcall, 10, -2);
  gtk_entry_set_text (GTK_ENTRY (pactorcall), _("NOCALL"));

  pactormycall = gtk_entry_new_with_max_length (7);
  gtk_widget_set_name (pactormycall, "pactormycall");
  gtk_widget_ref (pactormycall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "pactormycall", pactormycall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pactormycall);
  gtk_table_attach (GTK_TABLE (table_pactor_standard), pactormycall, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_widget_set_usize (pactormycall, 10, -2);
  gtk_entry_set_text (GTK_ENTRY (pactormycall), _("NOCALL"));

  pactortxdelay = gtk_entry_new ();
  gtk_widget_set_name (pactortxdelay, "pactortxdelay");
  gtk_widget_ref (pactortxdelay);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "pactortxdelay", pactortxdelay,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pactortxdelay);
  gtk_table_attach (GTK_TABLE (table_pactor_standard), pactortxdelay, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_widget_set_usize (pactortxdelay, 10, -2);
  gtk_entry_set_text (GTK_ENTRY (pactortxdelay), _("30"));

  pactorretry = gtk_entry_new ();
  gtk_widget_set_name (pactorretry, "pactorretry");
  gtk_widget_ref (pactorretry);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "pactorretry", pactorretry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pactorretry);
  gtk_table_attach (GTK_TABLE (table_pactor_standard), pactorretry, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_widget_set_usize (pactorretry, 10, -2);
  gtk_entry_set_text (GTK_ENTRY (pactorretry), _("30"));

  label_pactor_destcall = gtk_label_new (_("Destination Call"));
  gtk_widget_set_name (label_pactor_destcall, "label_pactor_destcall");
  gtk_widget_ref (label_pactor_destcall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_pactor_destcall", label_pactor_destcall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_pactor_destcall);
  gtk_table_attach (GTK_TABLE (table_pactor_standard), label_pactor_destcall, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_pactor_destcall), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_pactor_destcall), 5, 0);

  label_pactor_splp = gtk_label_new (_("SP/LP"));
  gtk_widget_set_name (label_pactor_splp, "label_pactor_splp");
  gtk_widget_ref (label_pactor_splp);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_pactor_splp", label_pactor_splp,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_pactor_splp);
  gtk_table_attach (GTK_TABLE (table_pactor_standard), label_pactor_splp, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_pactor_splp), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_pactor_splp), 5, 0);

  frame_pactor_advanced = gtk_frame_new (_("Advanced"));
  gtk_widget_set_name (frame_pactor_advanced, "frame_pactor_advanced");
  gtk_widget_ref (frame_pactor_advanced);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "frame_pactor_advanced", frame_pactor_advanced,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_pactor_advanced);
  gtk_box_pack_start (GTK_BOX (hbox_pactor_standard), frame_pactor_advanced, TRUE, TRUE, 0);

  table_pactor_advanced = gtk_table_new (4, 2, FALSE);
  gtk_widget_set_name (table_pactor_advanced, "table_pactor_advanced");
  gtk_widget_ref (table_pactor_advanced);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "table_pactor_advanced", table_pactor_advanced,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_pactor_advanced);
  gtk_container_add (GTK_CONTAINER (frame_pactor_advanced), table_pactor_advanced);

  pactorcrc0 = gtk_entry_new ();
  gtk_widget_set_name (pactorcrc0, "pactorcrc0");
  gtk_widget_ref (pactorcrc0);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "pactorcrc0", pactorcrc0,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pactorcrc0);
  gtk_table_attach (GTK_TABLE (table_pactor_advanced), pactorcrc0, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_widget_set_usize (pactorcrc0, 10, -2);

  pactorcrc1 = gtk_entry_new ();
  gtk_widget_set_name (pactorcrc1, "pactorcrc1");
  gtk_widget_ref (pactorcrc1);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "pactorcrc1", pactorcrc1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pactorcrc1);
  gtk_table_attach (GTK_TABLE (table_pactor_advanced), pactorcrc1, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_widget_set_usize (pactorcrc1, 10, -2);

  pactorcrc3 = gtk_entry_new ();
  gtk_widget_set_name (pactorcrc3, "pactorcrc3");
  gtk_widget_ref (pactorcrc3);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "pactorcrc3", pactorcrc3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pactorcrc3);
  gtk_table_attach (GTK_TABLE (table_pactor_advanced), pactorcrc3, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_widget_set_usize (pactorcrc3, 10, -2);

  pactorcrc2 = gtk_entry_new ();
  gtk_widget_set_name (pactorcrc2, "pactorcrc2");
  gtk_widget_ref (pactorcrc2);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "pactorcrc2", pactorcrc2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pactorcrc2);
  gtk_table_attach (GTK_TABLE (table_pactor_advanced), pactorcrc2, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_widget_set_usize (pactorcrc2, 10, -2);

  label_pactor_crc100chg = gtk_label_new (_("CRC 100 Chg"));
  gtk_widget_set_name (label_pactor_crc100chg, "label_pactor_crc100chg");
  gtk_widget_ref (label_pactor_crc100chg);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_pactor_crc100chg", label_pactor_crc100chg,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_pactor_crc100chg);
  gtk_table_attach (GTK_TABLE (table_pactor_advanced), label_pactor_crc100chg, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_pactor_crc100chg), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_pactor_crc100chg), 5, 0);

  label_pactor_crc100 = gtk_label_new (_("CRC 100"));
  gtk_widget_set_name (label_pactor_crc100, "label_pactor_crc100");
  gtk_widget_ref (label_pactor_crc100);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_pactor_crc100", label_pactor_crc100,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_pactor_crc100);
  gtk_table_attach (GTK_TABLE (table_pactor_advanced), label_pactor_crc100, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label_pactor_crc100), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (label_pactor_crc100), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_pactor_crc100), 5, 0);

  label_pactor_crc200chg = gtk_label_new (_("CRC 200 Chg"));
  gtk_widget_set_name (label_pactor_crc200chg, "label_pactor_crc200chg");
  gtk_widget_ref (label_pactor_crc200chg);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_pactor_crc200chg", label_pactor_crc200chg,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_pactor_crc200chg);
  gtk_table_attach (GTK_TABLE (table_pactor_advanced), label_pactor_crc200chg, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_pactor_crc200chg), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_pactor_crc200chg), 5, 0);

  label_pactor_crc200 = gtk_label_new (_("CRC 200"));
  gtk_widget_set_name (label_pactor_crc200, "label_pactor_crc200");
  gtk_widget_ref (label_pactor_crc200);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_pactor_crc200", label_pactor_crc200,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_pactor_crc200);
  gtk_table_attach (GTK_TABLE (table_pactor_advanced), label_pactor_crc200, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_pactor_crc200), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_pactor_crc200), 5, 0);

  label_Pactor = gtk_label_new (_("Pactor"));
  gtk_widget_set_name (label_Pactor, "label_Pactor");
  gtk_widget_ref (label_Pactor);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_Pactor", label_Pactor,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_Pactor);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (paramnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (paramnotebook), 3), label_Pactor);

  table_Gtor = gtk_table_new (4, 2, FALSE);
  gtk_widget_set_name (table_Gtor, "table_Gtor");
  gtk_widget_ref (table_Gtor);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "table_Gtor", table_Gtor,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_Gtor);
  gtk_container_add (GTK_CONTAINER (paramnotebook), table_Gtor);

  gtordestcall = gtk_entry_new_with_max_length (12);
  gtk_widget_set_name (gtordestcall, "gtordestcall");
  gtk_widget_ref (gtordestcall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "gtordestcall", gtordestcall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (gtordestcall);
  gtk_table_attach (GTK_TABLE (table_Gtor), gtordestcall, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (gtordestcall), _("NOCALL"));

  gtormycall = gtk_entry_new_with_max_length (12);
  gtk_widget_set_name (gtormycall, "gtormycall");
  gtk_widget_ref (gtormycall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "gtormycall", gtormycall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (gtormycall);
  gtk_table_attach (GTK_TABLE (table_Gtor), gtormycall, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (gtormycall), _("NOCALL"));

  gtortxdelay = gtk_entry_new ();
  gtk_widget_set_name (gtortxdelay, "gtortxdelay");
  gtk_widget_ref (gtortxdelay);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "gtortxdelay", gtortxdelay,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (gtortxdelay);
  gtk_table_attach (GTK_TABLE (table_Gtor), gtortxdelay, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (gtortxdelay), _("30"));

  gtorretry = gtk_entry_new ();
  gtk_widget_set_name (gtorretry, "gtorretry");
  gtk_widget_ref (gtorretry);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "gtorretry", gtorretry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (gtorretry);
  gtk_table_attach (GTK_TABLE (table_Gtor), gtorretry, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (gtorretry), _("30"));

  label_gtor_destcall = gtk_label_new (_("Destination Call"));
  gtk_widget_set_name (label_gtor_destcall, "label_gtor_destcall");
  gtk_widget_ref (label_gtor_destcall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_gtor_destcall", label_gtor_destcall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_gtor_destcall);
  gtk_table_attach (GTK_TABLE (table_Gtor), label_gtor_destcall, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_gtor_destcall), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_gtor_destcall), 5, 0);

  label_gtor_mycall = gtk_label_new (_("Mycall"));
  gtk_widget_set_name (label_gtor_mycall, "label_gtor_mycall");
  gtk_widget_ref (label_gtor_mycall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_gtor_mycall", label_gtor_mycall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_gtor_mycall);
  gtk_table_attach (GTK_TABLE (table_Gtor), label_gtor_mycall, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_gtor_mycall), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_gtor_mycall), 5, 0);

  label_gtor_txdelay = gtk_label_new (_("TX Delay (ms)"));
  gtk_widget_set_name (label_gtor_txdelay, "label_gtor_txdelay");
  gtk_widget_ref (label_gtor_txdelay);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_gtor_txdelay", label_gtor_txdelay,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_gtor_txdelay);
  gtk_table_attach (GTK_TABLE (table_Gtor), label_gtor_txdelay, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_gtor_txdelay), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_gtor_txdelay), 5, 0);

  label_gtor_retries = gtk_label_new (_("Retries"));
  gtk_widget_set_name (label_gtor_retries, "label_gtor_retries");
  gtk_widget_ref (label_gtor_retries);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_gtor_retries", label_gtor_retries,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_gtor_retries);
  gtk_table_attach (GTK_TABLE (table_Gtor), label_gtor_retries, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_gtor_retries), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_gtor_retries), 5, 0);

  label_Gtor = gtk_label_new (_("GTOR"));
  gtk_widget_set_name (label_Gtor, "label_Gtor");
  gtk_widget_ref (label_Gtor);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_Gtor", label_Gtor,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_Gtor);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (paramnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (paramnotebook), 4), label_Gtor);

  toolbar1 = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_TEXT);
  gtk_widget_set_name (toolbar1, "toolbar1");
  gtk_widget_ref (toolbar1);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "toolbar1", toolbar1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (toolbar1);
  gtk_box_pack_start (GTK_BOX (param_vbox), toolbar1, FALSE, FALSE, 0);
// mt63

  table_mt63 = gtk_table_new (4, 2, FALSE);
  gtk_widget_set_name (table_mt63, "table_mt63");
  gtk_widget_ref (table_mt63);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "table_mt63", table_mt63,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_mt63);
  gtk_container_add (GTK_CONTAINER (paramnotebook), table_mt63);

  label_mt63_bandwidth = gtk_label_new (_("Bandwidth"));
  gtk_widget_set_name (label_mt63_bandwidth, "label_mt63_bandwidth");
  gtk_widget_ref (label_mt63_bandwidth);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_mt63_bandwidth", label_mt63_bandwidth,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_mt63_bandwidth);
  gtk_table_attach (GTK_TABLE (table_mt63), label_mt63_bandwidth, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_mt63_bandwidth), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_mt63_bandwidth), 5, 0);

  mt63_bandwidth = gtk_combo_new ();
  gtk_widget_set_name (mt63_bandwidth, "mt63_bandwidth");
  gtk_widget_ref (mt63_bandwidth);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "mt63_bandwidth", mt63_bandwidth,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (mt63_bandwidth);
  gtk_table_attach (GTK_TABLE (table_mt63), mt63_bandwidth, 1, 2, 0, 1, 
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  mt63_bandwidth_items = g_list_append (mt63_bandwidth_items, (gpointer) _(" 500"));
  mt63_bandwidth_items = g_list_append (mt63_bandwidth_items, (gpointer) _("1000"));
  mt63_bandwidth_items = g_list_append (mt63_bandwidth_items, (gpointer) _("2000"));
  gtk_combo_set_popdown_strings (GTK_COMBO (mt63_bandwidth), mt63_bandwidth_items);
  g_list_free (mt63_bandwidth_items);

  mt63_bandwidth_value = GTK_COMBO (mt63_bandwidth)->entry;
  gtk_widget_set_name (mt63_bandwidth_value, "mt63_bandwidth_value");
  gtk_widget_ref (mt63_bandwidth_value);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "mt63_bandwidth_value", 
                              mt63_bandwidth_value,
                    	    (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (mt63_bandwidth_value);
  gtk_entry_set_editable (GTK_ENTRY (mt63_bandwidth_value), FALSE);
  gtk_entry_set_text (GTK_ENTRY (mt63_bandwidth_value), _("1000"));

  label_mt63_integration = gtk_label_new (_("Integration Period"));
  gtk_widget_set_name (label_mt63_integration, "label_mt63_integration");
  gtk_widget_ref (label_mt63_integration);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_mt63_integration", label_mt63_integration,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_mt63_integration);
  gtk_table_attach (GTK_TABLE (table_mt63), label_mt63_integration, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_mt63_integration), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_mt63_integration), 5, 0);

  mt63_integration = gtk_entry_new_with_max_length (3);
  gtk_widget_set_name (mt63_integration, "mt63_integration");
  gtk_widget_ref (mt63_integration);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "mt63_integration", mt63_integration,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (mt63_integration);
  gtk_table_attach (GTK_TABLE (table_mt63), mt63_integration, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (mt63_integration), _("32"));

  label_mt63_cwcall = gtk_label_new (_("CW ID (none if empty)"));
  gtk_widget_set_name (label_mt63_cwcall, "label_mt63_cwcall");
  gtk_widget_ref (label_mt63_cwcall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_mt63_cwcall", label_mt63_cwcall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_mt63_cwcall);
  gtk_table_attach (GTK_TABLE (table_mt63), label_mt63_cwcall, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_mt63_cwcall), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label_mt63_cwcall), 5, 0);

  mt63_cwcall = gtk_entry_new_with_max_length (10);
  gtk_widget_set_name (mt63_cwcall, "mt63_cwcall");
  gtk_widget_ref (mt63_cwcall);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "mt63_cwcall", mt63_cwcall,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (mt63_cwcall);
  gtk_table_attach (GTK_TABLE (table_mt63), mt63_cwcall, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);
  gtk_entry_set_text (GTK_ENTRY (mt63_cwcall), _("MT63"));

  mt63_doubleinterleave = gtk_check_button_new_with_label (_("Double Interleave"));
  gtk_widget_set_name (mt63_doubleinterleave, "mt63_doubleinterleave");
  gtk_widget_ref (mt63_doubleinterleave);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "mt63_doubleinterleave", mt63_doubleinterleave,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (mt63_doubleinterleave);
  gtk_table_attach (GTK_TABLE (table_mt63), mt63_doubleinterleave, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 3);

  label_mt63 = gtk_label_new (_("MT63"));
  gtk_widget_set_name (label_mt63, "label_mt63");
  gtk_widget_ref (label_mt63);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "label_mt63", label_mt63,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_mt63);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (paramnotebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (paramnotebook), 5), label_mt63);

// mt63 end
  parok = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar1),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                _("OK"),
                                NULL, NULL,
                                NULL, NULL, NULL);
  gtk_widget_set_name (parok, "parok");
  gtk_widget_ref (parok);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "parok", parok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (parok);
  gtk_container_set_border_width (GTK_CONTAINER (parok), 3);

  parcancel = gtk_button_new_with_label (_("Cancel"));
  gtk_widget_set_name (parcancel, "parcancel");
  gtk_widget_ref (parcancel);
  gtk_object_set_data_full (GTK_OBJECT (wpar), "parcancel", parcancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (parcancel);
  gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar1), parcancel, NULL, NULL);

  gtk_signal_connect (GTK_OBJECT (wpar), "delete_event",
                      GTK_SIGNAL_FUNC (gtk_widget_hide),
                      NULL);
  gtk_widget_add_accelerator (wpar, "hide",
  			par_accels,
			GDK_p, GDK_SHIFT_MASK,
      	                GTK_ACCEL_VISIBLE);

  
  gtk_signal_connect (GTK_OBJECT (parok), "clicked",
                      GTK_SIGNAL_FUNC (on_parok_clicked),
                      NULL);
  
  gtk_widget_add_accelerator (parok, "clicked",
  			par_accels,
			GDK_Return, 0, 
      	                GTK_ACCEL_VISIBLE);
 
  gtk_signal_connect (GTK_OBJECT (parcancel), "clicked",
                      GTK_SIGNAL_FUNC (on_parcancel_clicked),
                      NULL);

  gtk_widget_add_accelerator (parcancel, "clicked",
  			par_accels,
			GDK_Escape, 0, 
      	                GTK_ACCEL_VISIBLE);
 

  return wpar;
}

