/* $Log: utils.c,v $
/* Revision 1.1  2003/10/15 15:59:00  emery
/* Initial check-in.
/*
/* Revision 1.1  2001/08/23 17:20:27  emery
/* The big fig newton.
/*
/* Revision 1.1.1.1  2001/06/28 19:48:19  dgay
/* Initial import of RC tests
/*
 * Revision 1.12  1997/08/04 22:17:24  arda
 * Fix mudlle so that it compiles with g++
 *
 * Revision 1.11  1996/07/04 00:31:27  arda
 * Simple stuff, mostly.
 *
 * Revision 1.10  1996/01/26 18:11:23  arda
 * Unknown
 *
 * Revision 1.9  1994/10/09  06:43:11  arda
 * Libraries
 * Type inference
 * Many minor improvements
 *
 * Revision 1.8  1994/09/16  13:07:15  arda
 * Rename protect to catch.
 * New protect/unprotect functions (like dynpro/undynpro).
 *
 * Revision 1.7  1994/02/11  09:59:30  dgay
 * Owl: -Wall
 *      new shared string handling
 *      configuration file
 *
 * Revision 1.6  1993/12/23  20:48:56  dgay
 * Owl: New alloc.c: semi-generational collector.
 *      Included Amiga makefile for convenience.
 *
 * Revision 1.5  1993/12/06  19:20:54  arda
 * divers CLI
 *
 * Revision 1.4  1993/11/27  11:29:12  arda
 * Owl: Major changes to affect.
 *      Save mudlle data with players & objects.
 *      Change skill format on disk.
 *      Other minor changes.
 *      Still needs full debugging.
 *
 * Revision 1.3  1993/08/15  21:00:34  un_mec
 * Owl: Overload [].
 *      Added xcalloc, xrealloc.
 *
 * Revision 1.2  1993/03/29  09:24:50  un_mec
 * Owl: Changed descriptor I/O
 *      New interpreter / compiler structure.
 *
 * Revision 1.3  1993/03/14  16:15:18  dgay
 * Optimised stack & gc ops.
 *
 * Revision 1.1  1992/12/27  21:41:45  un_mec
 * Mudlle source, without any Mume extensions.
 *
 */

static char rcsid[] = "$Id: utils.c,v 1.1 2003/10/15 15:59:00 emery Exp $";

#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "mudlle.h"
#include "mudio.h"
#include "utils.h"
#ifdef MUME
#include "macro.h"
#endif

int erred;

void error(const char *msg, ...)
{
  va_list args;
  char err[4096];

  va_start(args, msg);
  vsprintf(err, msg, args);
  va_end(args);
  if (mudout) mflush(mudout);
  mprintf(muderr, "%s" EOL, err);
  if (muderr) mflush(muderr);
  erred = 1;
}

void warning(const char *msg, ...)
{
  va_list args;
  char err[4096];

  va_start(args, msg);
  vsprintf(err, msg, args);
  va_end(args);
  if (mudout) mflush(mudout);
  mprintf(muderr, "warning: %s" EOL, err);
  if (muderr) mflush(muderr);
}

#ifdef DEBUG_MEMORY
void *debug_xmalloc(const char *file, int line, int size)
{
  void *newp = debug_malloc(file, line, size);

  if (!newp)
    {
      fprintf(stderr, "No memory!\n");
      abort();
    }

  return newp;
}

void *debug_xcalloc(const char *file, int line, int number, int size)
{
  void *newp = debug_calloc(file, line, number, size);

  if (!newp) abort();

  return newp;
}

void *debug_xrealloc(const char *file, int line, void *old, int size)
{
  void *newp = debug_realloc(file, line, old, size);

  if (!newp) abort();

  return newp;
}

char *debug_xstrdup(const char *file, int line, const char *s)
{
  char *newp = debug_xmalloc(file, line, strlen(s) + 1);

  return strcpy(newp, s);
}
#else
void *xmalloc(int size)
{
  void *newp = malloc(size);

  if (!newp) abort();

  return newp;
}

void *xcalloc(int number, int size)
{
  void *newp = calloc(number, size);

  if (!newp) abort();

  return newp;
}

void *xrealloc(void *old, int size)
{
  void *newp = realloc(old, size);

  if (!newp) abort();

  return newp;
}

char *xstrdup(const char *s)
{
  char *newp = xmalloc(strlen(s) + 1);

  return strcpy(newp, s);
}
#endif

char *strlwr(char *s)
{
  char *t = s;

  while (*t) { *t = tolower(*t); t++; }

  return s;
}

#ifndef HAVE_MEMMOVE
void memmove(char *to, const char *from, int n)
{
  if (to == from) return;

  if (to > from && to < from + n)
    {
      from += n;
      to += n;
      while (n--) *--to = *--from;
    }
  else if (from > to && from < to + n)
    {
      while (n--) *to++ = *from++;
    }
  else memcpy(to, from, n);
}

#endif
