// chooselr.c	- ignores okset and simply goes left to right.
// ----------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Implementation of class: see choose.h for spec.
// Different implementations will try different policies.
// The class is instantiatied ONCE.

#include "node.h"
#include "choose.h"
#include <stream.h>

extern node nodes[];
extern int cube_size;
extern const int bitmask[];	// bitmask[i] is 2**i

chooseclass choose;		// ONLY INSTANCE
/*************************************************/
chooseclass::chooseclass()
{
}
/*******************************************/
void chooseclass::sanitycheck()
{
	cout << "Choose algorithm: lr (strict left-right, no history tag)\n";
}
/*******************************************/
void chooseclass::noteack( nodenum here, linknum lout, struct message *pm )
{
}
/*******************************************/
void chooseclass::notenak( nodenum here, linknum lout, struct message *pm )
{
}
/*****************************************/
//
// rightmost returns the bit position (0..15) of the rightmost set bit.
// Returns -1 if no bit set.

linknum rightmost( int mask )
{
	if( (mask <0) || (mask > cube_size)){
		cout << "ERROR: rightmost invalid argument " << mask NL;
		return 1;
	}
	if( mask == 0 ) return -1;
	int i;
	for( i=0;; i++ ) {
		if( mask & 1 ) break;
		mask >>= 1;
	}
	return i;
}
/*****************************************/
// chooselink returns a link# that is free at that node,
// and that is in both the linkset and the okset.
// Returns -1 if no such.
// The search is done right-to-left (LS -> MS).

linknum chooseclass::outlink( nodenum here, int linkset, int okset )
{
	struct node *phere = &nodes[ here ];
	linknum l;
	for(;;) {
		l = rightmost( linkset );		// index of bit
		if( l < 0 ) break;
		if( phere->links[l].busy == false ) break;	// found one
		linkset ^= bitmask[l];			// turn off bit l
	}
	return l;
}
/*******************************************/
//	int goodlinkset, badlinkset;
//	linknum lastlink;
//	char bestlink[ MAX_CUBE_SIZE ];
