// -*- C++ -*-

#ifndef _CACHEONESUPERBLOCK_H_
#define _CACHEONESUPERBLOCK_H_

template <class SuperHeap>
class CacheOneSuperblock : public SuperHeap {
public:

  typedef typename SuperHeap::SuperblockType SuperblockType;

  CacheOneSuperblock (void)
    : _current (NULL)
  {}

  inline void * malloc (size_t) { abort(); }
  inline void free (void *) { abort(); }

  SuperblockType * get (size_t sz, SuperHeap * dest) {
    if (_current) {
      SuperblockType * p = _current;
      _current = NULL;
      return p;
    } else {
      return SuperHeap::get (sz, dest);
    }
  }

  void put (SuperblockType * p, size_t sz) {
    if (!_current) {
      SuperHeap::put (_current, sz);
    }
    _current = p;
  }


private:
  SuperblockType * _current;

};


#endif
