#include <gtk/gtk.h>

#include "main.h"
#include "preferences.h"
#include "helpings.h"

GtkWidget *destination_create() // initialize the "destination" notebook
{
	GtkWidget *destination; // a "Notebook" for the "destinations"

	destination=gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(destination),GTK_POS_LEFT);
   	
   	main_settip(destination,"Destination Area");
	
	return destination;
}
;

void destination_add(GtkNotebook *destination,GtkWidget *page,gchar **data) // add page to Notebook with pixmap
{
        GdkPixmap *xpm;
	GdkBitmap *mask;
	GtkStyle  *style;
	GtkWidget *icon;
		
	style=gtk_widget_get_style(window);
	xpm= gdk_pixmap_create_from_xpm_d (window->window,&mask,
					 &style->bg[GTK_STATE_NORMAL],
					 data);
	icon= gtk_pixmap_new(xpm,mask);
	gtk_widget_show(icon);
	
	gtk_notebook_append_page(destination,page,icon);
	
}
;
