/*  GtkRecover
 *  Copyright (C) 1999, 2000 by Tom Pycke <Tom.Pycke@advalvas.be>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/wait.h>
#include <signal.h>
#include "ui.h"
#include "grecover.h"

// These are the pointers to the questions
extern char *ask_device,
	    *ask_year,
	    *ask_month,
	    *month_eg,
	    *ask_weekd,
	    *weekd_eg,
	    *ask_day1,
	    *ask_day2,
	    *ask_minsize,
	    *ask_maxsize,
	    *ask_hour1,
	    *ask_hour2,
	    *ask_min1,
	    *ask_min2,
	    *ask_id,
	    *ask_dump,
	    *ask_refilter;
int num_del_inodes;

FILE *
get_output (char *command)
{
    int fd[2], pid;

    pipe (fd);
    switch ((pid = fork ())) {
    case 0:
      close (fd[0]);
      dup2 (fd[1], 1);
      if (execl ("/bin/sh", "sh", "-c", command, NULL) == -1)
	{
	  strcat (command, ": can't run it");
	  prn_error (command);
	  exit (0);
	  return NULL;
	}
      break;
    case -1:
      perror(command);
      exit(1);
    default:
      break;
    }
    //	  waitpid (pid, NULL, 0);
    close (fd[1]);
    return fdopen (fd[0], "r");
}

void strtoupper (char *str)
{
    int x;
    for (x=0;str[x]!=0;x++)
	str[x]=toupper(str[x]);
}
		

void cleanstr (char *str)
{
    int x;
    for (x=0;str[x]!=0;x++)
	if (str[x]=='\n' || str[x]=='\0')
	    break;
    str[x-1] = ' ';
    str[x] = '\0';
}

inode *
get_inodes (char *device)
{
    char temp[256], dummy[12];
    int x, pid, fd[2];
    int blocks;
    inode *cur_inode, *lastinode = NULL, *firstinode;
    FILE *list;
    GtkWidget *wait_ui;
    GtkWidget *vbox2;
    GtkWidget *label;
//  printf ("Getting inodes (this can take some time)...\n");
#ifdef lsdel_file
    list = get_output ("cat lsdel");
#else
    sprintf (temp, "debugfs -R lsdel %s", device);
    list = get_output (temp);
#endif
    fgets (temp, 256, list);
    sscanf (temp, "%d", &num_del_inodes);
    fgets (temp, 256, list);
    for (x = 0; x </*=*/ num_del_inodes; x++)
    {
	cur_inode = new inode;
	if (lastinode != NULL)
	    lastinode->next_inode = cur_inode;
	else
	    firstinode = cur_inode;
	fgets (temp, 256, list);
	sscanf (temp, "%d %d %d %d %[^/]/%d %s %s %d %d:%d:%d %d",
		&(cur_inode->number),
		&(cur_inode->UID),
		&(cur_inode->mode),
		&(cur_inode->size),
		&dummy,
		&blocks,
		&(cur_inode->weekd),
		&(cur_inode->month),
		&(cur_inode->day),
		&(cur_inode->hour),
		&(cur_inode->min),
		&(cur_inode->sec),
		&(cur_inode->year));
	strtoupper (cur_inode->weekd);
	strtoupper (cur_inode->month);
	lastinode = cur_inode;
    }
    fclose (list);
    cur_inode->next_inode = NULL;
    return (firstinode);
}


int get_questions(char *lang)
{
    char    line[101],
	    header[20],
	    temp[20],
	    temp2[20],
	    temp3[20];
    FILE *txt;
    int x,
	langcount=1,
	tmp,
	place;
    
    txt = fopen (QUESTIONS_LOCATION, "r");
    if (txt == NULL)
    {
	txt = fopen("recover_questions", "r");
	if (txt == NULL)
	{
	    printf ("cannot find %s", QUESTIONS_LOCATION);
	    exit(1);
	}
    }
    for (; line!=NULL ;)
    {
	if (fgets (line, 80, txt) == 0)
	    break;
	if (line[0]=='#')
	    continue;
	if (line[0]=='[')
	{
	    if (strncmp (line, "[language",9)==0)
	    {
		for (x=1; temp[0]!='#';x++)
		{
		    tmp = fscanf (txt, "%s%s%s", &temp, &temp2, &temp3);
		    strtoupper (temp);
		    strtoupper (temp2);
		    strtoupper (temp3);
		    if (strcmp (lang, temp)==0 ||
			strcmp (lang, temp2)==0 ||
			strcmp (lang, temp3)==0 )
		    {
			langcount = x;
#ifdef DEBUG
			printf ("langcount = %d\n", langcount);
#endif
			break;
		    }
		}
		
	    }
	    else if (strncmp (line, "[ask_device", 11)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_device = (char*)malloc (strlen (line)+1);
		strcpy (ask_device, line);
#ifdef DEBUG
		printf ("ask_device = %s\n", ask_device);
#endif
	    }
	    else if (strncmp (line, "[ask_year",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_year = (char*)malloc (strlen (line)+1);
		strcpy (ask_year, line);
#ifdef DEBUG
		printf ("ask_year = %s\n", ask_year);
#endif
	    }
	    else if (strncmp (line, "[ask_month",10)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_month = (char*)malloc (strlen (line)+1);
		strcpy (ask_month, line);
#ifdef DEBUG
		printf ("ask_device = %s\n", ask_year);
#endif
	    }
	    else if (strncmp (line, "[month_eg",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		month_eg = (char*)malloc (strlen (line)+1);
		strcpy (month_eg, line);
#ifdef DEBUG
		printf ("month_eg = %s\n", month_eg);
#endif
	    }
	    else if (strncmp (line, "[ask_weekd",10)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_weekd = (char*)malloc (strlen (line)+1);
		strcpy (ask_weekd, line);
#ifdef DEBUG
		printf ("ask_weekd = %s\n", ask_weekd);
#endif
	    }
	    else if (strncmp (line, "[weekd_eg",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		weekd_eg = (char*)malloc (strlen (line)+1);
		strcpy (weekd_eg, line);
#ifdef DEBUG
		printf ("week_eg = %s\n", week_eg);
#endif
	    }
	    else if (strncmp (line, "[ask_day1",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_day1 = (char*)malloc (strlen (line)+1);
		strcpy (ask_day1, line);
#ifdef DEBUG
		printf ("ask_day1 = %s\n", ask_day1);
#endif
	    }
	    else if (strncmp (line, "[ask_day2",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_day2 = (char*)malloc (strlen (line)+1);
		strcpy (ask_day2, line);
#ifdef DEBUG
		printf ("ask_day2 = %s\n", ask_day2);
#endif
	    }
	    else if (strncmp (line, "[ask_minsize",12)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_minsize = (char*)malloc (strlen (line)+1);
		strcpy (ask_minsize, line);
#ifdef DEBUG
		printf ("ask_minsize = %s\n", ask_minsize);
#endif
	    }
	    else if (strncmp (line, "[ask_maxsize",12)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_maxsize = (char*)malloc (strlen (line)+1);
		strcpy (ask_maxsize, line);
#ifdef DEBUG
		printf ("ask_maxsize = %s\n", ask_maxsize);
#endif
	    }
	    else if (strncmp (line, "[ask_hour1",10)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_hour1 = (char*)malloc (strlen (line)+1);
		strcpy (ask_hour1, line);
#ifdef DEBUG
		printf ("ask_hour1 = %s\n", ask_hour1);
#endif
	    }
	    else if (strncmp (line, "[ask_hour2",10)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_hour2 = (char*)malloc (strlen (line)+1);
		strcpy (ask_hour2, line);
#ifdef DEBUG
		printf ("ask_hour2 = %s\n", ask_hour2);
#endif
	    }
	    else if (strncmp (line, "[ask_min1",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_min1 = (char*)malloc (strlen (line)+1);
		strcpy (ask_min1, line);
#ifdef DEBUG
		printf ("ask_min1 = %s\n", ask_min1);
#endif
	    }
	    else if (strncmp (line, "[ask_min2",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_min2 = (char*)malloc (strlen (line)+1);
		strcpy (ask_min2, line);
#ifdef DEBUG
		printf ("ask_min2 = %s\n", ask_min2);
#endif
	    }
	    else if (strncmp (line, "[ask_id",7)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_id = (char*)malloc (strlen (line)+1);
		strcpy (ask_id, line);
#ifdef DEBUG
		printf ("ask_id = %s\n", ask_id);
#endif
	    }
	    else if (strncmp (line, "[ask_dump",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_dump = (char*)malloc (strlen (line)+1);
		strcpy (ask_dump, line);
#ifdef DEBUG
		printf ("ask_dump = %s\n", ask_dump);
#endif
	    }
	    else if (strncmp (line, "[ask_refilter",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_refilter = (char*)malloc (strlen (line)+1);
		strcpy (ask_refilter, line);
#ifdef DEBUG
		printf ("ask_refilter = %s\n", ask_refilter);
#endif
	    }
	}
    }
    fclose (txt);
}


/*// This function reads recover_questions
int get_questions(char *lang)
{
    char    line[101],
	    header[20],
	    temp[20],
	    temp2[20],
	    temp3[20];
    FILE *txt;
    int x,
	langcount=1,
	tmp,
	place;

    txt = fopen (QUESTIONS_LOCATION, "r");
    if (txt == NULL)
    {
	txt = fopen("recover_questions", "r");
	if (txt == NULL)
	{
	    printf ("cannot find %s", QUESTIONS_LOCATION);
	    exit(1);
	}
    }
    for (; line!=NULL ;)
    {
	if (fgets (line, 80, txt) == 0)
	    break;
	if (line[0]=='#')
	    continue;
	if (line[0]=='[')
	{
	    if (strncmp (line, "[language",9)==0)
	    {
		for (x=1; temp[0]!='#';x++)
		{
		    tmp = fscanf (txt, "%s %s %s", &temp, &temp2, &temp3);
		    strtoupper (temp);
		    strtoupper (temp2);
		    strtoupper (temp3);
		    if (strcmp (lang, temp)==0 ||
			strcmp (lang, temp2)==0 ||
			strcmp (lang, temp3)==0 )
		    {	    
			langcount = x;
#ifdef DEBUG
			printf ("langcount = %d\n", langcount);
#endif
			break;
		    }
		}
	    }
	    else if (strncmp (line, "[ask_device", 11)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_device = (char*)malloc (strlen (line)+1);
		strcpy (ask_device, line);
#ifdef DEBUG
		printf ("ask_device = %s\n", ask_device);
#endif
	    }
	    else if (strncmp (line, "[ask_year",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_year = (char*)malloc (strlen (line)+1);
		strcpy (ask_year, line);
#ifdef DEBUG
		printf ("ask_year = %s\n", ask_year);
#endif
	    }
	    else if (strncmp (line, "[ask_month",10)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_month = (char*)malloc (strlen (line)+1);
		strcpy (ask_month, line);
#ifdef DEBUG
		printf ("ask_device = %s\n", ask_year);
#endif
	    }
	    else if (strncmp (line, "[month_eg",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		month_eg = (char*)malloc (strlen (line)+1);
		strcpy (month_eg, line);
#ifdef DEBUG
		printf ("month_eg = %s\n", month_eg);
#endif
	    }
	    else if (strncmp (line, "[ask_weekd",10)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_weekd = (char*)malloc (strlen (line)+1);
		strcpy (ask_weekd, line);
#ifdef DEBUG
		printf ("ask_weekd = %s\n", ask_weekd);
#endif
	    }
	    else if (strncmp (line, "[weekd_eg",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		weekd_eg = (char*)malloc (strlen (line)+1);
		strcpy (weekd_eg, line);
#ifdef DEBUG	
		printf ("week_eg = %s\n", week_eg);
#endif
	    }
	    else if (strncmp (line, "[ask_day1",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_day1 = (char*)malloc (strlen (line)+1);
		strcpy (ask_day1, line);
	    }
	    else if (strncmp (line, "[ask_day2",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_day2 = (char*)malloc (strlen (line)+1);
		strcpy (ask_day2, line);
	    }
	    else if (strncmp (line, "[ask_minsize",12)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_minsize = (char*)malloc (strlen (line)+1);
		strcpy (ask_minsize, line);
	    }
	    else if (strncmp (line, "[ask_maxsize",12)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_maxsize = (char*)malloc (strlen (line)+1);
		strcpy (ask_maxsize, line);
	    }
	    else if (strncmp (line, "[ask_hour1",10)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_hour1 = (char*)malloc (strlen (line)+1);
		strcpy (ask_hour1, line);
	    }
	    else if (strncmp (line, "[ask_hour2",10)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_hour2 = (char*)malloc (strlen (line)+1);
		strcpy (ask_hour2, line);
	    }
	    else if (strncmp (line, "[ask_min1",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_min1 = (char*)malloc (strlen (line)+1);
		strcpy (ask_min1, line);
	    }
	    else if (strncmp (line, "[ask_min2",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_min2 = (char*)malloc (strlen (line)+1);
		strcpy (ask_min2, line);
	    }
	    else if (strncmp (line, "[ask_id",7)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_id = (char*)malloc (strlen (line)+1);
		strcpy (ask_id, line);
	    }
	    else if (strncmp (line, "[ask_dump",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_dump = (char*)malloc (strlen (line)+1);
		strcpy (ask_dump, line);
	    }
	    else if (strncmp (line, "[ask_refilter",9)==0)
	    {
		for (x=0;x<langcount;x++)
		    fgets (line, 100, txt);
		cleanstr (line);
		ask_refilter = (char*)malloc (strlen (line)+1);
		strcpy (ask_refilter, line);
	    }
	}
    }
    fclose (txt);

    }*/

int
main (int argc, char *argv[])
{
    char    *device,
	    *tmp,
	    lang[30];
    int all,
	x;
    GtkWidget *recover_ui;
printf ("GtkRecover v0.2 based on recover-1.0a");
printf ("\n (C) 1999, 2000 by Tom Pycke <Tom.Pycke@advalvas.be>\n");


  gtk_set_locale ();
  gtk_init (&argc, &argv);

    if (geteuid())
    {
	prn_error ("You must be root to run recover!", "ERROR", 1);
	printf ("You must be root to run recover!\n");
	gtk_main ();
    }

    for (x=0; argv[x]!=NULL; x++)
    {
       if (strcmp (argv[x], "-h") == 0 || strcmp (argv[x], "--help") == 0)
       {
	    printf ("usage: grecover [device]\n" \
		    "  -a, --all	restores all deleted inodes on device\n");
	    exit (0);
	}
	if (strncmp (argv[x], "/dev/", 5) == 0)
	{
	    device = argv[x];
	}
	if (strcmp (argv[x], "-a") == 0 || strcmp (argv[x], "--all") == 0)
	{
	    all = 1;
	}
    }

    if (!argv[1])
    {
	tmp = getenv ("LANG");
	if (tmp != NULL)
	    strcpy (lang, tmp);
	else
	    strcpy (lang, "EN");
	strtoupper (lang);
    }
    else
    {
	for (x=0; *(argv[1]+x) != 0; x++)
	    lang[x] = toupper (*(argv[1]+x));
	lang[x] = '\0';
    }
													


  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  get_questions (lang);
  recover_ui = create_recover_ui ();
  gtk_widget_show (recover_ui);

  gtk_main ();
  return 0;
}


gboolean
on_recover_ui_destroy_event	       (GtkWidget	*widget,
					GdkEvent	*event,
					gpointer	 user_data)
{
    exit (0);
    return FALSE;
}


void
on_list1_selection_changed	       (GtkList		*list,
					gint row,
					gint column,
					GdkEventButton *event,
					gpointer	 user_data)
{
    gchar *txt;
    gtk_clist_get_text (GTK_CLIST (list), row, column, &txt);
    gtk_entry_set_text((GtkEntry*)user_data, txt);
}

void
on_list_selection_changed	       (GtkList		*list,
					gint row,
					gint column,
					GdkEventButton *event,
					gpointer	 user_data)
{
    gchar *txt;
    gtk_clist_get_text (GTK_CLIST (list), row, 0/*column*/, &txt);
    gtk_entry_set_text((GtkEntry*)user_data, txt);
}


void
quit_clicked			       (GtkButton	*button,
					gpointer	 user_data)
{
    exit (0);
}



void
on_ok_clicked			       (GtkButton	*button,
					gpointer	 user_data)
{
    gtk_widget_destroy ((GtkWidget*)user_data);
}

