/* ui.h
 *
 * This file is for use with GTKeyboard, and is released under the terms of
 * the GNU General Public License
 *
 * Written by David Allen <s2mdalle@titan.vcu.edu>
 * http://opop.nols.com/
 *
 * Prototypes for ui.c
 */

#define UI_H
#ifndef MASTER_H
#  include "../master.h"
#endif /* MASTER_H */

#ifndef HTML_H
#  include "html.h"
#endif /* HTML_H */

/* Just make these unique. */
#define ORIGIN                              20
#define BR_CORNER                           21
#define UR_CORNER                           22
#define BL_CORNER                           23
#define UL_CORNER                           24
#define WIN_CENTER                          25
#define T_CENTER                            26
#define B_CENTER                            27
#define L_CENTER                            28
#define R_CENTER                            29
#define NO_HANDLER                          666

#define DIMENSIONS_ERROR(winfu)             (winfu.x==-1 && winfu.y==-1 && \
                                           winfu.width==-1 && winfu.height==-1)
/* Prototypes for ui.c */
void EasterEgg                               (GtkWidget *emitter, 
					      gpointer data);
void setup_output_box                        (void);
gint button_press                            (GtkWidget *widget, 
					      GdkEvent *event);
GtkWidget *get_directional_pixmap            (int index);
void gtkeyboard_window_common_setup          (GtkWidget *window);
void CreateMainWindow                        (void);
void select_all                              (GtkWidget *w, gpointer data);
void move_gtkeyboard                         (const int x, const int y);
GtkWidget *make_browse_button                (GtkWidget *insert_into);
void browse                                  (GtkWidget *emitter, 
					      gpointer data);
void move_window                             (GtkWidget *emitter, 
					      int POSITION);
window_dimensions gtkeyboard_query_window    (Window w);
void gtkeyboard_print_coords                 (GtkWidget *emitter, 
					      gpointer data);
void redirect_explicit                       (GtkWidget *emitter, 
					      gpointer data);
void redirect_implicit                       (GtkWidget *emitter, 
					      gpointer data);
void move_gtkeyboard_offset                  (const int x, const int y);
void gtkeyboard_raise                        (void);
void gtkeyboard_lower                        (void);
void gtkeyboard_hide                         (void);
void gtkeyboard_show                         (void);
void set_handle_box_opts                     (GtkWidget *handlebox);
