// -*- C++ -*-

/* sheet_numeric_with_popup.cc
 * 
 * Copyright (C) 2000 GtkExtra-- Development Team  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "sheet_numeric_withpopup.h"

Sheet_Numeric_WithPopup::Sheet_Numeric_WithPopup(gint rows, gint columns, const nstring& title)
 : Sheet_Numeric(rows, columns, title)
{
  set_selection_mode(GTK_SELECTION_SINGLE);
  
  button_press_event.connect(slot(this, &Sheet_Numeric_WithPopup::on_button_press_event_Popup));

  m_MenuPopup.get_MenuItem_AddRow()->activate.connect(slot(this, &Sheet_Numeric_WithPopup::on_MenuPopup_activate_AddRow));
  m_MenuPopup.get_MenuItem_AddColumn()->activate.connect(slot(this, &Sheet_Numeric_WithPopup::on_MenuPopup_activate_AddColumn));
  m_MenuPopup.get_MenuItem_InsertRow()->activate.connect(slot(this, &Sheet_Numeric_WithPopup::on_MenuPopup_activate_InsertRow));
  m_MenuPopup.get_MenuItem_InsertColumn()->activate.connect(slot(this, &Sheet_Numeric_WithPopup::on_MenuPopup_activate_InsertColumn));
  m_MenuPopup.get_MenuItem_DeleteRow()->activate.connect(slot(this, &Sheet_Numeric_WithPopup::on_MenuPopup_activate_DeleteRow));
  m_MenuPopup.get_MenuItem_DeleteColumn()->activate.connect(slot(this, &Sheet_Numeric_WithPopup::on_MenuPopup_activate_DeleteColumn));
  m_MenuPopup.get_MenuItem_ClearCells()->activate.connect(slot(this, &Sheet_Numeric_WithPopup::on_MenuPopup_activate_ClearCells));
}

Sheet_Numeric_WithPopup::~Sheet_Numeric_WithPopup()
{
}

gint
Sheet_Numeric_WithPopup::on_button_press_event_Popup(GdkEventButton *event)
{ 
  GdkModifierType mods;
  gdk_window_get_pointer( Gtk::Widget::gtkobj()->window, 0, 0, &mods );
  if(mods & GDK_BUTTON3_MASK)
  { 
    configure_menu();
    m_MenuPopup.popup(event->button, event->time);
  }

  return TRUE;
}


void
Sheet_Numeric_WithPopup::configure_menu()
{
  m_MenuPopup.Set_AllSensitive();
	  
  if(get_state() != GTK_SHEET_ROW_SELECTED)
  {  
    m_MenuPopup.get_MenuItem_InsertRow()->set_sensitive(false);
    m_MenuPopup.get_MenuItem_InsertRow()->unset_flags(GTK_CAN_FOCUS);

    m_MenuPopup.get_MenuItem_DeleteRow()->set_sensitive(false);
    m_MenuPopup.get_MenuItem_DeleteRow()->unset_flags(GTK_CAN_FOCUS); 
  }

  if(get_state() != GTK_SHEET_COLUMN_SELECTED)
	{  
	  m_MenuPopup.get_MenuItem_InsertColumn()->set_sensitive(false);
    m_MenuPopup.get_MenuItem_InsertColumn()->unset_flags(GTK_CAN_FOCUS);

    m_MenuPopup.get_MenuItem_DeleteColumn()->set_sensitive(false);
    m_MenuPopup.get_MenuItem_DeleteColumn()->unset_flags(GTK_CAN_FOCUS);
  }
}

void
Sheet_Numeric_WithPopup::on_MenuPopup_activate_AddColumn()
{
  add_column(1);
}

void
Sheet_Numeric_WithPopup::on_MenuPopup_activate_AddRow()
{
  add_row(1);
}

void
Sheet_Numeric_WithPopup::on_MenuPopup_activate_InsertRow()
{ 
  if(get_state() == GTK_SHEET_ROW_SELECTED)
  {
    insert_rows(get_selected_range().row0, get_selected_range().rowi - get_selected_range().row0 + 1);
  }
}

void
Sheet_Numeric_WithPopup::on_MenuPopup_activate_InsertColumn()
{
  if(get_state() == GTK_SHEET_COLUMN_SELECTED)
  {
     insert_columns(get_selected_range().col0, get_selected_range().coli - get_selected_range().col0 + 1);
  }
}

void
Sheet_Numeric_WithPopup::on_MenuPopup_activate_DeleteRow()
{
  if(get_state() == GTK_SHEET_ROW_SELECTED)
  {
    delete_rows(get_selected_range().row0, get_selected_range().rowi - get_selected_range().row0 + 1);
  }
}

void
Sheet_Numeric_WithPopup::on_MenuPopup_activate_DeleteColumn()
{ 
  if(get_state() == GTK_SHEET_COLUMN_SELECTED)
  {
    delete_columns(get_selected_range().col0, get_selected_range().coli - get_selected_range().col0 + 1);
  }
}

void
Sheet_Numeric_WithPopup::on_MenuPopup_activate_ClearCells()
{
  if(get_state() == GTK_SHEET_NORMAL)
  {
    range_clear(get_selected_range());
  }
}
