/* properties.c
 * Copyright (C) 2005 Sylvain Cresto <scresto@gmail.com>
 * 
 * This file is part of graveman!
 *
 * graveman! is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or
 * (at your option) any later version.
 * 
 * graveman! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA. 
 * 
 * URL: http://www.nongnu.org/graveman/
 *
 */

#include "graveman.h"

void remplirecombocharset(GtkComboBox *Acombo, gboolean Ainit, gchar *Asel)
{
  GtkListStore *Lmodel;

  if (Ainit == TRUE) {
    Lmodel = gtk_list_store_new(4, G_TYPE_INT, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING);
    GtkCellRenderer *Lcellrender;

    gtk_combo_box_set_model(Acombo, GTK_TREE_MODEL(Lmodel));
    gtk_cell_layout_clear(GTK_CELL_LAYOUT(Acombo));

    Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_pixbuf_new());
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Acombo), Lcellrender, TRUE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Acombo), Lcellrender,
      "pixbuf", 1, NULL);                    
    Lcellrender = GTK_CELL_RENDERER(gtk_cell_renderer_text_new());
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(Acombo), Lcellrender, TRUE);
    gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(Acombo), Lcellrender,
      "text", 3, NULL);
  } else {
    Lmodel = GTK_LIST_STORE(gtk_combo_box_get_model(Acombo));
  }

  remplirelistecharset(Lmodel, TRUE);
  selectcombocharset(Acombo, Asel);

/*  gtk_combo_box_set_active(Acombo, 0);*/

}

/* fenetre proprietes */
Tgrave *create_dialog_proprietes (GtkWidget *Aparent)
{
  Tgrave *Lg = sc_grave_load("dialog_properties.glade");
  GtkTreeView *Ltreeview, *Ltreeviewcharset;
  GtkWidget *Ldialog;
  GtkTooltips *Ltooltips = gtk_tooltips_new();

  g_assert(Lg);

  Ldialog = sc_grave_get_widget(Lg, "dialog_properties");
  gtk_window_set_transient_for(GTK_WINDOW(Ldialog), GTK_WINDOW(Aparent));
  sc_grave_set_data(Lg, Ldialog, "window");
  sc_grave_set_data(Lg, Ltooltips, "_tooltips");

  /** onglet "General" **/
  
  /* overburn actif ? */
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sc_grave_get_widget(Lg, "overburn")), conf_get_boolean("overburn"));

  /* effacer les cdrw avant ecriture */
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sc_grave_get_widget(Lg, "autoblank")), conf_get_boolean("autoblank"));

  /* effacer les cdrw en mode fast ? */
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sc_grave_get_widget(Lg, "fastblank")), conf_get_boolean("fastblank"));

  /* ejecter le cdr apres l'operation ? */
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sc_grave_get_widget(Lg, "eject")), conf_get_boolean("eject"));

  /* afficher le status bar ? */
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sc_grave_get_widget(Lg, "statusbar")), conf_get_boolean("statusbar"));
  
  /* combo taille des icones */
  remplirecombo(GTK_COMBO_BOX(sc_grave_get_widget(Lg, "iconsizelist")), "", 
      Gtypeicosize, TRUE, conf_get_string("iconsize"));

  /* combo charset */
  remplirecombocharset(GTK_COMBO_BOX(sc_grave_get_widget(Lg, "inputcharset")), TRUE, conf_get_string("charsetdata"));

  /* sauver les donnees lorsque l'on quitte ? */
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(sc_grave_get_widget(Lg, "saveconfig")), conf_get_boolean("saveconfig"));

  /* fonctions etendues ? */
#if 0  
  Ltoggleoption = GTK_TOGGLE_BUTTON(glade_to_hash(Lxml, Lhash, "extended"));
  gtk_toggle_button_set_active(Ltoggleoption, conf_get_boolean("extended"));
#endif

  /* repertoire temporraire */
  gtk_entry_set_text(GTK_ENTRY(sc_grave_get_widget(Lg, "dirtmpvalue")), conf_get_string("tmpdir"));

  /** onglet "Format des medias" **/
#if 0
  Ltreeview = GTK_TREE_VIEW(glade_to_hash(Lxml, Lhash, "medialist"));
  prepare_properties_mediatreeview(Ltreeview);
  remplirelistemedia(Ltreeview);

  Lbtn = GTK_BUTTON(glade_xml_get_widget(Lxml, "addmediaformat"));
  g_signal_connect(G_OBJECT(Lbtn), "clicked", G_CALLBACK(on_addmediaformat), Lhash);
#endif


  Ltreeview = GTK_TREE_VIEW(sc_grave_get_widget(Lg, "periphdata"));
  prepare_properties_devicestreeview(Ltreeview);
  g_signal_connect(G_OBJECT(Ltreeview), "button-press-event", G_CALLBACK(gtk_do_eventbuttonpress), Lg);
  g_signal_connect(G_OBJECT(Ltreeview), "popup-menu", G_CALLBACK(key_popupmenu_devices), Lg);
  g_signal_connect(G_OBJECT(Ltreeview), "key-release-event", G_CALLBACK(gtk_do_eventkeyrelease), Lg);

  /* popup sur les peripheriques */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "popupdevices_edit")),
      "activate", G_CALLBACK(gtk_devices_edit), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "popupdevices_remove")),
      "activate", G_CALLBACK(gtk_devices_remove), Lg);

  Ltreeviewcharset = GTK_TREE_VIEW(sc_grave_get_widget(Lg, "charsetdata"));
  prepare_properties_charsettreeview(Ltreeviewcharset);
  g_signal_connect(G_OBJECT(Ltreeviewcharset), "button-press-event", G_CALLBACK(gtk_do_eventbuttonpress), Lg);
  g_signal_connect(G_OBJECT(Ltreeviewcharset), "popup-menu", G_CALLBACK(key_popupmenu_charset), Lg);
  g_signal_connect(G_OBJECT(Ltreeviewcharset), "key-release-event", G_CALLBACK(gtk_do_eventkeyrelease), Lg);

  /* popup sur les charsets */
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "popupcharset_edit")),
      "activate", G_CALLBACK(gtk_charset_edit), Lg);
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "popupcharset_remove")),
      "activate", G_CALLBACK(gtk_charset_remove), Lg);


  sc_grave_set_data(Lg, Aparent, "topwindow");

  maj_proprietes_prog(Lg);
  remplirelistegraveur(Ltreeview);
  remplirelistecharset(GTK_LIST_STORE(gtk_tree_view_get_model(Ltreeviewcharset)), FALSE);

  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "dirtmp")), "clicked", G_CALLBACK(gtk_file_sel), Lg);

  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "scanprog")), "clicked", G_CALLBACK(chercheprog), Lg);

  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "scandevice")), "clicked", G_CALLBACK(cherchelecteur), Lg);

  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "adddevice")), "clicked", G_CALLBACK(gtk_devices_add), Lg);
 
  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "scancharset")), "clicked", G_CALLBACK(cherchecharset), Lg);

  g_signal_connect(G_OBJECT(sc_grave_get_widget(Lg, "addcharset")), "clicked", G_CALLBACK(gtk_charset_add), Lg);
 
 
  return Lg;
}

/*
 * vim:et:ts=8:sts=2:sw=2
 */
