/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  satplot-print.c: Printing function for radial plots showing a 
                   satellite pass.

  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:   Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/


#include <gnome.h>
#include <libgnomeprint/gnome-print-master-preview.h>
#include <libgnomeprint/gnome-print-master.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gconf/gconf-client.h>
#include "satplot-print.h"




void satplot_print_cb (GtkWidget *widget, gpointer canvas)
{
	/* This function is called when the user clicks on the
	   "Print" button in the satplot dialog. The canvas
	   should be passed as argumenut.
	*/
	GnomePrinter *printer;
	GnomePrintMaster *gpm;
	GnomePrintContext *pc;
	const GnomePaper *paper=NULL;
	gint copies, collate;
	gdouble l, r, t, b;
	GtkWidget *dialog;
	gboolean preview = FALSE;
	GdkPixbuf *pbuf=NULL;

	if (!canvas)
		return;
	

	pbuf = gdk_pixbuf_get_from_drawable (NULL, GTK_WIDGET (canvas)->window,
					     NULL, 0, 0, 0, 0, 500, 500);

	dialog = gnome_print_dialog_new (_("Print Track Plot"), GNOME_PRINT_DIALOG_COPIES);
	gnome_dialog_set_default (GNOME_DIALOG (dialog), GNOME_PRINT_PRINT);
	switch (gnome_dialog_run (GNOME_DIALOG (dialog))) {
	case GNOME_PRINT_PRINT:
		break;
	case GNOME_PRINT_PREVIEW:
		preview = TRUE;
		break;
	case -1:
		return;
	default:
		gnome_dialog_close (GNOME_DIALOG (dialog));
		return;
	}
	/* get values */
	gnome_print_dialog_get_copies (GNOME_PRINT_DIALOG (dialog), &copies, &collate);
	printer = gnome_print_dialog_get_printer (GNOME_PRINT_DIALOG (dialog));
	/* done with dialog */
	gnome_dialog_close (GNOME_DIALOG (dialog));

	/* Create a new Print Master */
	gpm = gnome_print_master_new ();
	paper = gnome_paper_with_name (gnome_paper_name_default ());
	gnome_print_master_set_paper (gpm, paper);
	if (printer)
		gnome_print_master_set_printer (gpm, printer);
	gnome_print_master_set_copies (gpm, copies, collate);

	/* Create a new Print Context from the Master */
	pc = gnome_print_master_get_context (gpm);
	l = gnome_paper_lmargin (paper);
	r = gnome_paper_pswidth (paper) - gnome_paper_rmargin (paper);
	t = gnome_paper_psheight (paper) - gnome_paper_tmargin (paper);
	b = gnome_paper_bmargin (paper);

	/*** DO PRINTING STUFF HERE ***/
	gnome_print_beginpage (pc, _("Track Plot"));

	gnome_print_gsave (pc);
	gnome_print_translate (pc, l, t-gdk_pixbuf_get_height (pbuf));
	gnome_print_scale (pc,
			   gdk_pixbuf_get_width (pbuf),
			   gdk_pixbuf_get_height (pbuf));
	gnome_print_moveto (pc, 0, 0);
	gnome_print_pixbuf (pc, pbuf);
	gnome_print_grestore (pc);
	gnome_print_showpage (pc);
	gnome_print_master_close (gpm);

	if (preview) {
		GnomePrintMasterPreview *gpmp;

		gpmp = gnome_print_master_preview_new (gpm, _("Track Plot Print Preview"));
		gtk_widget_show (GTK_WIDGET (gpmp));
	} else {
		gnome_print_master_print (gpm);
	}
	gtk_object_unref (GTK_OBJECT (gpm));
	gdk_pixbuf_unref (pbuf);
}
