#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "gpc_app.h"
#include "gpc_utils.h"

#include "gpc_image_infos.h"
#include "gpc_image_infos_intf.h"
#include "support.h"


gint      gpc_image_keyword_selection;
gboolean  gpc_image_updating;



 /*
 **
 ** gpc_film_infos private callbacks 
 **
 */

void
gpc_image_dialog_save_options (void);

void
lens_maker_validate_callback (gint reply, 
			      gpointer data);

void
lens_model_validate_callback (gint reply, 
			      gpointer data);

void 
image_keywords_validate_callback (gint reply, 
				  gpointer data);

void
swap_image_table_visibility (gchar *tablename, 
			     gchar *pixmapname);


 /*
 **
 ** User functions
 **
 */
 
void
gpc_image_dialog_update (GpcImageInfos *infos)
{
  gchar   *id;
  gchar   *dim;
  gint    length;
  guint   pos;
  GtkText *description;

  GList *keywords;
  guint elements;
  guint index;
  gchar *fields[2];

  if (!gpc_image_dialog)
    return;
  gpc_image_updating = TRUE;
  if (!gpc_lens_makers)
    gpc_lens_makers = gpc_app_get_keywords (gpc_connection, "GPC_LENS_MAKER");
  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_image_dialog, "lens_maker_combo")), gpc_lens_makers);
  if (!gpc_keywords)
    gpc_keywords = gpc_app_get_keywords (gpc_connection, "GPC_KEY");
  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_image_dialog, "keywords_combo")), gpc_keywords);
  if (!infos) {
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "id_label")), NULL);
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "film_id_label")), NULL);
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "filename_label")), NULL);
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "width_label")), NULL);
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "height_label")), NULL);
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "mime_type_label")), NULL);
    gtk_editable_delete_text (GTK_EDITABLE (lookup_widget (gpc_image_dialog, "number_entry")), 0, -1);
    gtk_editable_delete_text (GTK_EDITABLE (lookup_widget (gpc_image_dialog, "lens_maker_combo_entry")), 0, -1);
    gtk_editable_delete_text (GTK_EDITABLE (lookup_widget (gpc_image_dialog, "lens_model_combo_entry")), 0, -1);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "focal_spinbutton")), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "aperture_spinbutton")), 0);
    gtk_editable_delete_text (GTK_EDITABLE (lookup_widget (gpc_image_dialog, "speed_entry")), 0, -1);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "latitude_spinbutton")), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "longitude_spinbutton")), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "elevation_spinbutton")), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "direction_spinbutton")), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "pitch_spinbutton")), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "roll_spinbutton")), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "interest_note_spinbutton")), 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "quality_note_spinbutton")), 0);
    description = GTK_TEXT (lookup_widget (gpc_image_dialog, "description_text"));
    pos = gtk_text_get_point (description);
    if (pos > 0)
      gtk_text_backward_delete (description, pos);
    pos = gtk_text_get_length (description);
    if (pos > 0)
      gtk_text_forward_delete (description, pos);
    gtk_editable_delete_text (GTK_EDITABLE (lookup_widget (gpc_image_dialog, "keywords_combo_entry")), 0, -1);
    gtk_clist_clear (GTK_CLIST (lookup_widget (gpc_image_dialog, "keywords_clist")));
  }
  else {
    id = g_strdup_printf ("%d", gpc_image_get_id (infos));
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "id_label")), id);
    g_free (id);
    id = g_strdup_printf ("%d", gpc_image_get_film_id (infos));
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "film_id_label")), id);
    g_free (id);
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "filename_label")),
                        gpc_image_get_filename (infos));
    dim = g_strdup_printf ("%d", gpc_image_get_width (infos));
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "width_label")), dim);
    g_free (dim);
    dim = g_strdup_printf ("%d", gpc_image_get_height (infos));
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "height_label")), dim);
    g_free (dim);
    gtk_label_set_text (GTK_LABEL (lookup_widget (gpc_image_dialog, "mime_type_label")),
                        gpc_image_get_mime_type (infos));
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "number_entry")),
                        gpc_image_get_number (infos));
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "lens_maker_combo_entry")),
                        gpc_image_get_lens_maker (infos));
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "lens_model_combo_entry")),
                        gpc_image_get_lens_model (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "focal_spinbutton")),
                              (gfloat) gpc_image_get_focal (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "aperture_spinbutton")),
                              (gfloat) gpc_image_get_aperture (infos));
    gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "speed_entry")),
                        gpc_image_get_speed (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "latitude_spinbutton")),
                              (gfloat) gpc_image_get_latitude (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "longitude_spinbutton")),
                              (gfloat) gpc_image_get_longitude (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "elevation_spinbutton")),
                              (gfloat) gpc_image_get_elevation (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "direction_spinbutton")),
                              (gfloat) gpc_image_get_direction (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "pitch_spinbutton")),
                              (gfloat) gpc_image_get_pitch (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "roll_spinbutton")),
                              (gfloat) gpc_image_get_roll (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "interest_note_spinbutton")),
                              (gfloat) gpc_image_get_interest_note (infos));
    gtk_spin_button_set_value(GTK_SPIN_BUTTON (lookup_widget (gpc_image_dialog, "quality_note_spinbutton")),
                              (gfloat) gpc_image_get_quality_note (infos));
    length = strlen (gpc_image_get_description (infos));
    description = GTK_TEXT (lookup_widget (gpc_image_dialog, "description_text"));
    pos = gtk_text_get_point (description);
    if (pos > 0)
      gtk_text_backward_delete (description, pos);
    pos = gtk_text_get_length (description);
    if (pos > 0)
      gtk_text_forward_delete (description, pos);
    gtk_text_insert (description, NULL, NULL, NULL, gpc_image_get_description (infos), length);
    gtk_editable_delete_text (GTK_EDITABLE (lookup_widget (gpc_image_dialog, "keywords_combo_entry")), 0, -1);
    gtk_clist_clear (GTK_CLIST (lookup_widget (gpc_image_dialog, "keywords_clist")));
    keywords = gpc_image_get_keywords (infos);
    if (keywords) {
      elements = g_list_length (keywords);
      for (index = 0; index < elements; index++) {
        fields[0] = (gchar *) g_list_nth_data (keywords, index);
        fields[1] = NULL;
        gtk_clist_append (GTK_CLIST (lookup_widget (gpc_image_dialog, "keywords_clist")), fields);
      }
    }
  }
  gpc_image_updating = FALSE;
  gpc_image_modified = FALSE;
}


 /*
 **
 ** gpc_image dialog callbacks 
 **
 */

void
gpc_image_dialog_save_options (void)
{
  gint x;
  gint y;

  if (gpc_image_dialog->window) {
    gnome_config_set_bool ("/gphotocoll/image_infos/classification", GTK_WIDGET_VISIBLE (lookup_widget (gpc_image_dialog, "classification_table")));
    gnome_config_set_bool ("/gphotocoll/image_infos/lens", GTK_WIDGET_VISIBLE (lookup_widget (gpc_image_dialog, "lens_table")));
    gnome_config_set_bool ("/gphotocoll/image_infos/position", GTK_WIDGET_VISIBLE (lookup_widget (gpc_image_dialog, "position_table")));
    gnome_config_set_bool ("/gphotocoll/image_infos/notes", GTK_WIDGET_VISIBLE (lookup_widget (gpc_image_dialog, "notes_table")));
    gnome_config_set_bool ("/gphotocoll/image_infos/description", GTK_WIDGET_VISIBLE (lookup_widget (gpc_image_dialog, "description_table")));
    gnome_config_set_bool ("/gphotocoll/image_infos/keywords", GTK_WIDGET_VISIBLE (lookup_widget (gpc_image_dialog, "keywords_table")));
    gdk_window_get_root_origin (GTK_WIDGET (gpc_image_dialog)->window, &x, &y);
    gnome_config_set_int ("/gphotocoll/image_infos/x", x);
    gnome_config_set_int ("/gphotocoll/image_infos/y", y);
  }
  gnome_config_sync ();
}


void
on_gpc_image_dialog_realize (GtkWidget *widget,
                             gpointer   user_data)
{
  gpc_image_updating = FALSE;
}


void
on_gpc_image_dialog_show (GtkWidget *widget,
                          gpointer   user_data)
{
  if (gnome_config_get_bool ("/gphotocoll/image_infos/classification=false"))
    swap_image_table_visibility ("classification_table", "classification_pixmap");
  if (gnome_config_get_bool ("/gphotocoll/image_infos/lens=false"))
    swap_image_table_visibility ("lens_table", "lens_pixmap");
  if (gnome_config_get_bool ("/gphotocoll/image_infos/position=false"))
    swap_image_table_visibility ("position_table", "position_pixmap");
  if (gnome_config_get_bool ("/gphotocoll/image_infos/notes=false"))
    swap_image_table_visibility ("notes_table", "notes_pixmap");
  if (gnome_config_get_bool ("/gphotocoll/image_infos/description=false"))
    swap_image_table_visibility ("description_table", "description_pixmap");
  if (!gnome_config_get_bool ("/gphotocoll/image_infos/keywords=false"))
    swap_image_table_visibility ("keywords_table", "keywords_pixmap");
  gdk_window_move (GTK_WIDGET (gpc_image_dialog)->window, 
                   gnome_config_get_int ("/gphotocoll/image_infos/x=550"),
                   gnome_config_get_int ("/gphotocoll/image_infos/y=20"));
}


gboolean
on_gpc_image_dialog_delete_event (GtkWidget  *widget,
                                  GdkEvent   *event,
                                  gpointer    user_data)
{
  gpc_image_dialog = NULL;
  return FALSE;
}


void
on_image_number_entry_changed (GtkEditable  *editable,
                               gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_number (gpc_image_infos, gtk_entry_get_text (GTK_ENTRY (editable)));
  if (images_clist)
    gtk_clist_set_text (images_clist, gpc_image_selection, 1, g_strdup (gpc_image_get_number (gpc_image_infos)));
  gpc_image_modified = TRUE;
}


void
on_lens_maker_combo_entry_changed (GtkEditable  *editable,
                                   gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_lens_maker (gpc_image_infos, gtk_entry_get_text (GTK_ENTRY (editable)));
  if (gpc_lens_maker_codes) {
    g_list_foreach (gpc_lens_maker_codes, (GFunc) g_free, NULL);
    g_list_free (gpc_lens_maker_codes);
    gpc_lens_maker_codes = NULL;
  }
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "lens_model_combo_entry")), "");
  gpc_image_modified = TRUE;
}


void
lens_maker_validate_callback (gint reply, 
			      gpointer data)
{
  switch (reply) {
    case  0 : gpc_lens_makers = g_list_insert_sorted (gpc_lens_makers, (gchar *) data, (GCompareFunc) g_strcasecmp);
              gpc_added_lens_makers = g_list_insert_sorted (gpc_added_lens_makers, g_strdup ((gchar *) data), (GCompareFunc) g_strcasecmp);
	      gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_image_dialog, "lens_maker_combo")), gpc_lens_makers);
	      gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "lens_maker_combo_entry")), (gchar *) data);
	      break;
    default : gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "lens_maker_combo_entry")), "");
              g_free (data);
  }
}


gboolean
on_lens_maker_combo_entry_focus_out_event (GtkWidget      *widget,
					   GdkEventFocus  *event,
					   gpointer        user_data)
{
  gchar *value;
  gchar *message;
  
  if (!gpc_image_infos || gpc_image_updating)
    return FALSE;
  value = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)));
  if ((strlen (value) > 0) && !gpc_app_check_keyword (gpc_connection, gpc_lens_makers, value, "GPC_LENS_MAKER")) {
    if (gpc_confirm_insert_refs) {
      message = g_strdup_printf (_("Insert value '%s' in lens maker's reference table ?"), value);
      gnome_app_ok_cancel_modal (GNOME_APP (gpc_app), message, lens_maker_validate_callback, value);
      g_free (message);
    }
    else
      lens_maker_validate_callback (0, value);
  }
  return FALSE;
}


gboolean
on_lens_model_combo_entry_focus_in_event (GtkWidget      *widget,
					  GdkEventFocus  *event,
					  gpointer        user_data)
{
  gchar *value;

  if (!gpc_image_infos || gpc_image_updating)
    return FALSE;
  value = g_strdup (gpc_image_get_lens_model (gpc_image_infos));
  if (!gpc_lens_maker_codes)
    gpc_lens_maker_codes = gpc_app_get_maker_codes (gpc_connection, "GPC_LENS_MODEL", gpc_image_get_lens_maker (gpc_image_infos));
  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_image_dialog, "lens_model_combo")), gpc_lens_maker_codes);
  gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "lens_model_combo_entry")), value);
  return FALSE;
}


void
on_lens_model_combo_entry_changed (GtkEditable  *editable,
                                   gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_lens_model (gpc_image_infos, gtk_entry_get_text (GTK_ENTRY (editable)));
  gpc_image_modified = TRUE;
}


void
lens_model_validate_callback (gint reply, 
			      gpointer data)
{
  switch (reply) {
    case  0 : gpc_lens_maker_codes = g_list_insert_sorted (gpc_lens_maker_codes, (gchar *) data, (GCompareFunc) g_strcasecmp);
              gpc_added_lens_maker_codes = g_list_insert_sorted (gpc_added_lens_maker_codes, g_strdup ((gchar *) data), (GCompareFunc) g_strcasecmp);
              gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_image_dialog, "lens_model_combo")), gpc_lens_maker_codes);
              gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "lens_model_combo_entry")), (gchar *) data);
              break;
    default : gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "lens_model_combo_entry")), "");
              g_free (data);
  }
}


gboolean
on_lens_model_combo_entry_focus_out_event (GtkWidget      *widget,
					   GdkEventFocus  *event,
					   gpointer        user_data)
{
  gchar      *value;
  gchar      *message;

  if (!gpc_image_infos || gpc_image_updating)
    return FALSE;
  value = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)));
  if ((strlen (value) > 0) && !gpc_app_check_keyword (gpc_connection, gpc_lens_maker_codes, value, "GPC_LENS_MODEL")) {
    if (gpc_confirm_insert_refs) {
      message = g_strdup_printf (_("Insert value '%s' in %s lens model's table ?"), value, gpc_image_get_lens_maker (gpc_image_infos));
      gnome_app_ok_cancel_modal (GNOME_APP (gpc_app), message, lens_model_validate_callback, value);
      g_free (message);
    }
    else
      lens_model_validate_callback (0, value);
  }
  return FALSE;
}


void
on_focal_spinbutton_changed (GtkEditable  *editable,
                             gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_focal (gpc_image_infos, gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (editable)));
  gpc_image_modified = TRUE;
}


void
on_aperture_spinbutton_changed (GtkEditable  *editable,
                                gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_aperture (gpc_image_infos, gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (editable)));
  gpc_image_modified = TRUE;
}


void
on_speed_entry_changed (GtkEditable  *editable,
                        gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_speed (gpc_image_infos, gtk_entry_get_text (GTK_ENTRY (editable)));
  gpc_image_modified = TRUE;
}


void
on_latitude_spinbutton_changed (GtkEditable  *editable,
                                gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_latitude (gpc_image_infos, gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (editable)));
  gpc_image_modified = TRUE;
}


void
on_longitude_spinbutton_changed (GtkEditable  *editable,
                                 gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_longitude (gpc_image_infos, gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (editable)));
  gpc_image_modified = TRUE;
}


void
on_elevation_spinbutton_changed (GtkEditable  *editable,
                                 gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_elevation (gpc_image_infos, gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (editable)));
  gpc_image_modified = TRUE;
}


void
on_direction_spinbutton_changed (GtkEditable  *editable,
                                 gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_direction (gpc_image_infos, gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (editable)));
  gpc_image_modified = TRUE;
}


void
on_pitch_spinbutton_changed (GtkEditable  *editable,
                             gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_pitch (gpc_image_infos, gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (editable)));
  gpc_image_modified = TRUE;
}


void
on_roll_spinbutton_changed (GtkEditable  *editable,
                            gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_roll (gpc_image_infos, gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (editable)));
  gpc_image_modified = TRUE;
}


void
on_interest_note_spinbutton_changed (GtkEditable  *editable,
                                     gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_interest_note (gpc_image_infos, gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (editable)));
  gpc_image_modified = TRUE;
}


void
on_quality_note_spinbutton_changed (GtkEditable  *editable,
                                    gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_quality_note (gpc_image_infos, gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (editable)));
  gpc_image_modified = TRUE;
}


void
on_image_description_text_changed (GtkEditable  *editable,
                                   gpointer      user_data)
{
  if (!gpc_image_infos || gpc_image_updating)
    return;
  gpc_image_set_description (gpc_image_infos, gtk_editable_get_chars (editable, 0, -1));
  if (images_clist)
    gtk_clist_set_text (images_clist, gpc_image_selection, 2, g_strdup (gpc_image_get_description (gpc_image_infos)));
  gpc_image_modified = TRUE;
}


gboolean
on_image_keywords_combo_entry_key_press_event (GtkWidget    *widget,
					       GdkEventKey  *event,
					       gpointer      user_data)
{
  if (event->keyval == GDK_Return) {
    on_image_add_keyword_button_clicked (NULL, NULL);
    event->keyval = GDK_End;
    gtk_editable_select_region (GTK_EDITABLE (widget), 0, -1);
  }
  return FALSE;
}


void
on_image_keywords_clist_select_row (GtkCList  *clist,
                                    gint       row,
                                    gint       column,
                                    GdkEvent  *event,
                                    gpointer   user_data)
{
  gpc_image_keyword_selection = row;
}


void
image_keywords_validate_callback (gint reply, 
				  gpointer data)
{
  GList       *keywords;

  gchar       *fields[2];

  switch (reply) {
    case  0 : if (g_list_find_custom (gpc_keywords, (gchar *) data, (GCompareFunc) g_strcasecmp) == NULL) {
                gpc_keywords = g_list_insert_sorted (gpc_keywords, (gchar *) data, (GCompareFunc) g_strcasecmp);
                gpc_added_keywords = g_list_insert_sorted (gpc_added_keywords, g_strdup ((gchar *) data), (GCompareFunc) g_strcasecmp);
                gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_image_dialog, "keywords_combo")), gpc_keywords);
                if (gpc_film_dialog)
                  gtk_combo_set_popdown_strings (GTK_COMBO (lookup_widget (gpc_film_dialog, "keywords_combo")), gpc_keywords);
                gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "keywords_combo_entry")), (gchar *) data);
              }
              keywords = gpc_image_get_keywords (gpc_image_infos);
              if (g_list_find_custom (keywords, (gchar *) data, (GCompareFunc) g_strcasecmp) == NULL) {
                keywords = g_list_insert_sorted (keywords, g_strdup ((gchar *) data), (GCompareFunc) g_strcasecmp);
                gpc_image_set_keywords (gpc_image_infos, keywords, FALSE);
                fields[0] = (gchar *) data;
                fields[1] = NULL;
                gtk_clist_append (GTK_CLIST (lookup_widget (gpc_image_dialog, "keywords_clist")), fields);
                gpc_image_modified = TRUE;
              }
              break;
    default : gtk_entry_set_text (GTK_ENTRY (lookup_widget (gpc_image_dialog, "keywords_combo_entry")), "");
              g_free (data);
  }
}


void
on_image_add_keyword_button_clicked (GtkButton  *button,
                                     gpointer    user_data)
{
  gchar       *value;
  gchar       *message;

  if (!gpc_image_infos || gpc_image_updating)
    return;
  value = gtk_editable_get_chars (GTK_EDITABLE (lookup_widget (gpc_image_dialog, "keywords_combo_entry")), 0, -1);
  if (strlen (value) > 0) {
    if ((g_list_find_custom (gpc_added_keywords, value, (GCompareFunc) g_strcasecmp) == NULL) &&
        (g_list_find_custom (gpc_keywords, value, (GCompareFunc) g_strcasecmp) == NULL)) {
      if (gpc_confirm_insert_refs) {
        message = g_strdup_printf (_("Insert value '%s' in keywords reference table ?"), value);
        gnome_app_ok_cancel_modal (GNOME_APP (gpc_app), message, image_keywords_validate_callback, value);
        g_free (message);
      }
      else
        image_keywords_validate_callback (0, value);
    }
    else
      image_keywords_validate_callback (0, value);
  }
  else
    g_free (value);
}


void
on_image_delete_keyword_button_clicked (GtkButton  *button,
                                        gpointer    user_data)
{
  GtkWidget   *list;
  GList       *keywords;
  GList       *deleted;
  gchar       *value;

  if (!gpc_image_infos || (gpc_image_keyword_selection < 0))
    return;
  list = lookup_widget (gpc_image_dialog, "keywords_clist");
  gtk_clist_get_text (GTK_CLIST (list), gpc_image_keyword_selection, 0, &value);
  keywords = gpc_image_get_keywords (gpc_image_infos);
  deleted = g_list_find_custom (keywords, value, (GCompareFunc) g_strcasecmp);
  if (deleted)
    keywords = g_list_remove_link (keywords, deleted);
  gpc_image_set_keywords (gpc_image_infos, keywords, FALSE);
  gtk_clist_remove (GTK_CLIST (list), gpc_image_keyword_selection);
  gpc_image_keyword_selection = -1;
  gpc_image_modified = TRUE;
}


void
on_image_cancel_button_clicked (GtkButton  *button,
                                gpointer    user_data)
{
  gchar *str;

  if (!gpc_image_infos || !gpc_image_modified)
    return;
  gpc_list_free (gpc_lens_maker_codes);
  gpc_lens_maker_codes = NULL;
  gpc_image_infos_free (gpc_image_infos);
  if (gtk_clist_get_text(images_clist, gpc_image_selection, 0, &str)) {
    gpc_image_infos = gpc_image_get_infos (gpc_connection, atoi (str));
    gpc_image_dialog_update (gpc_image_infos);
    if (images_clist) {
      gtk_clist_set_text (images_clist, gpc_image_selection, 1, g_strdup (gpc_image_get_number (gpc_image_infos)));
      gtk_clist_set_text (images_clist, gpc_image_selection, 2, g_strdup (gpc_image_get_description (gpc_image_infos)));
    }
  }
}


void
on_image_hide_button_clicked (GtkButton *button,
                              gpointer   user_data)
{
  gpc_image_dialog_save_options ();
  gtk_widget_destroy (gpc_image_dialog);
  gpc_image_dialog = NULL;
}


void
on_image_apply_button_clicked (GtkButton *button,
                               gpointer   user_data)
{
  if ((gpc_connection != NULL) &&
      (pg_connection_is_active (gpc_connection)) &&
      (gpc_image_infos != NULL) &&
      (gpc_image_modified))
    gpc_image_infos_store (gpc_connection, gpc_image_infos);
}


void
swap_image_table_visibility (gchar *tablename, 
			     gchar *pixmapname)
{
  GtkWidget *table;
  GtkWidget *pixmap;
  gchar     *pixmapfile;
  gint       x;
  gint       y;

  gdk_window_get_root_origin (GTK_WIDGET (gpc_image_dialog)->window, &x, &y);
  table = lookup_widget (gpc_image_dialog, tablename);
  pixmap = lookup_widget (gpc_image_dialog, pixmapname);
  if (GTK_WIDGET_VISIBLE (table)) {
    gtk_widget_hide (table);
    pixmapfile = gnome_pixmap_file ("gphotocoll/arrow-right.xpm");
    gnome_pixmap_load_file (GNOME_PIXMAP (pixmap), pixmapfile);
  }
  else {
    gtk_widget_show (table);
    pixmapfile = gnome_pixmap_file ("gphotocoll/arrow-down.xpm");
    gnome_pixmap_load_file (GNOME_PIXMAP (pixmap), pixmapfile);
  }
  g_free (pixmapfile);
  gdk_window_move (GTK_WIDGET (gpc_image_dialog)->window, x, y);
}


void
on_image_classification_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
  swap_image_table_visibility ("classification_table", "classification_pixmap");
}


void
on_image_lens_button_clicked (GtkButton  *button,
                              gpointer    user_data)
{
  swap_image_table_visibility ("lens_table", "lens_pixmap");
}


void
on_image_position_button_clicked (GtkButton  *button,
                                  gpointer    user_data)
{
  swap_image_table_visibility ("position_table", "position_pixmap");
}


void
on_image_notes_button_clicked (GtkButton  *button,
                               gpointer    user_data)
{
  swap_image_table_visibility ("notes_table", "notes_pixmap");
}


void
on_image_description_button_clicked (GtkButton  *button,
                                     gpointer    user_data)
{
  swap_image_table_visibility ("description_table", "description_pixmap");
}


void
on_image_keywords_button_clicked (GtkButton  *button,
                                  gpointer    user_data)
{
  swap_image_table_visibility ("keywords_table", "keywords_pixmap");
}

