/*
**  ConsoleWindow.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "ConsoleWindow.h"

#include "Constants.h"

@implementation ConsoleWindow

//
//
//
- (void) dealloc
{
  NSDebugLog(@"ConsoleWindow: -dealloc");
  
  RELEASE(currentTaskBox);
  RELEASE(icon);
  RELEASE(tasksTableView);
  RELEASE(tasksScrollView);
  RELEASE(messagesTableView);
  RELEASE(messagesScrollView);
  
  [super dealloc];
}


//
//
//
- (void) layoutWindow
{
  NSTableColumn *taskDateColumn, *descriptionColumn, *messageDateColumn, *messageColumn;
  NSButton *delete, *runNow, *stop, *suspend, *save;
  NSTabViewItem *tabViewItem1, *tabViewItem2;
  NSTextFieldCell *cell;
  NSTabView *tabView;
  NSView *view;
  NSBox *box;
  

  //
  // Our tab view
  //
  tabView = [[NSTabView alloc] initWithFrame: NSMakeRect(0,0,500,278)];
  [tabView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];

  //
  // Our first tabview
  //
  view = [[NSView alloc] initWithFrame: NSMakeRect(0,35,500,280)];
  [view setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];

  //
  // Our first box - current task
  //
  currentTaskBox = [[NSBox alloc] initWithFrame: NSMakeRect(5,175,490,100)];
  [currentTaskBox setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable|NSViewMinYMargin];
  [currentTaskBox setTitlePosition: NSAtTop];
  [currentTaskBox setBorderType: NSGrooveBorder];
  [view addSubview: currentTaskBox];  

  cell = [[NSTextFieldCell alloc] init];
  AUTORELEASE(cell);
  [cell setBordered: NO];
  matrix = [[NSMatrix alloc] initWithFrame:NSMakeRect(5,0,250,90)
			     mode: NSRadioModeMatrix
			     prototype: cell
			     numberOfRows: 3
			     numberOfColumns: 2];
  //[matrix setTarget: parent];
  [matrix setIntercellSpacing: NSMakeSize (0, 8) ];
  [matrix setAutosizesCells: NO];
  //[matrix setAllowsEmptySelection: NO];
  
  [[matrix cellAtRow: 0 column: 0] setStringValue: _(@"A1")];
  [[matrix cellAtRow: 1 column: 0] setStringValue: _(@"A2")];
  [[matrix cellAtRow: 2 column: 0] setStringValue: _(@"A3")];
  [[matrix cellAtRow: 0 column: 1] setStringValue: _(@"B1")];
  [[matrix cellAtRow: 1 column: 1] setStringValue: _(@"B2")];
  [[matrix cellAtRow: 2 column: 1] setStringValue: _(@"B3")];
  [matrix sizeToFit];  
  
  [[currentTaskBox contentView] addSubview: matrix];

  icon = [[NSImageView alloc] initWithFrame: NSMakeRect(390,4,16,16)];
  [icon setAutoresizingMask: NSViewMinXMargin|NSViewMaxYMargin];
  [icon setImageAlignment: NSImageAlignCenter];
  [icon setImage: nil];
  [icon setImageFrameStyle: NSImageFrameNone];
  [icon setEditable: NO];
  [currentTaskBox addSubview: icon];
 
  stop = [[NSButton alloc] initWithFrame: NSMakeRect(410,0,60,ButtonHeight)];
  [stop setButtonType: NSMomentaryPushButton];
  [stop setTitle: _(@"Stop")];
  [stop setTarget: [self windowController]];
  [stop setAction: @selector(stopClicked:)];
  [stop setAutoresizingMask: NSViewMinXMargin|NSViewMaxYMargin];
  [currentTaskBox addSubview: stop];
  RELEASE(stop);


  //
  // Our second box - tasks in the queue
  //
  box = [[NSBox alloc] initWithFrame: NSMakeRect(5,5,490,165)];
  [box setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable|NSViewMaxYMargin];
  [box setTitlePosition: NSAtTop];
  [box setTitle: _(@"Task Queue")];
  [box setBorderType: NSGrooveBorder];
  [view addSubview: box];
  
  descriptionColumn = [[NSTableColumn alloc] initWithIdentifier: @"Description"];
  [descriptionColumn setEditable: NO];
  [descriptionColumn setResizable: YES];
  [[descriptionColumn headerCell] setStringValue: _(@"Description")];
  [descriptionColumn setMinWidth: 115];
  [[descriptionColumn headerCell] setAlignment: NSLeftTextAlignment];
  
  taskDateColumn = [[NSTableColumn alloc] initWithIdentifier: @"Task Date"];
  [taskDateColumn setEditable: NO];
  [taskDateColumn setResizable: YES];
  [[taskDateColumn headerCell] setStringValue: _(@"Date")];
  [taskDateColumn setMinWidth: 140];
  [taskDateColumn setMaxWidth: 140];
  [[taskDateColumn headerCell] setAlignment: NSLeftTextAlignment];

  tasksScrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,35,470,100)];

  tasksTableView = [[NSTableView alloc] initWithFrame: [[tasksScrollView contentView] frame]];
  [tasksTableView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];
  [tasksTableView setDrawsGrid: NO];
  [tasksTableView setAllowsColumnSelection: NO];
  [tasksTableView setAllowsColumnReordering: NO];
  [tasksTableView setAllowsColumnResizing: YES];
  [tasksTableView setAllowsEmptySelection: YES];
  [tasksTableView setAllowsMultipleSelection: NO];
  [tasksTableView addTableColumn: descriptionColumn];
  [tasksTableView addTableColumn: taskDateColumn];
  [tasksTableView setAutoresizesAllColumnsToFit: YES];
  [tasksTableView sizeLastColumnToFit];
  [tasksTableView setDataSource: [self windowController]];
  [tasksTableView setDelegate: [self windowController]];
  RELEASE(descriptionColumn);
  RELEASE(taskDateColumn);

  [tasksScrollView setDocumentView: tasksTableView];
  [tasksScrollView setHasHorizontalScroller: YES];
  [tasksScrollView setHasVerticalScroller: YES];
  [tasksScrollView setBorderType: NSBezelBorder];
  [tasksScrollView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];

  [box addSubview: tasksScrollView];

  runNow = [[NSButton alloc] initWithFrame: NSMakeRect(5,0,70,ButtonHeight)];
  [runNow setButtonType: NSMomentaryPushButton];
  [runNow setTitle: _(@"Run now")];
  [runNow setTarget: self];
  [runNow setAction: @selector(runNowClicked:)];
  [box addSubview: runNow];
  RELEASE(runNow);

  delete = [[NSButton alloc] initWithFrame: NSMakeRect(80,0,70,ButtonHeight)];
  [delete setButtonType: NSMomentaryPushButton];
  [delete setTitle: _(@"Delete")];
  [delete setTarget: self];
  [delete setAction: @selector(deleteClicked:)];
  [box addSubview: delete];
  RELEASE(delete);

  suspend = [[NSButton alloc] initWithFrame: NSMakeRect(155,0,70,ButtonHeight)];
  [suspend setButtonType: NSMomentaryPushButton];
  [suspend setTitle: _(@"Suspend")];
  [suspend setTarget: self];
  [suspend setAction: @selector(suspendClicked:)];
  [box addSubview: suspend];
  RELEASE(suspend);

  save = [[NSButton alloc] initWithFrame: NSMakeRect(375,0,100,ButtonHeight)];
  [save setAutoresizingMask: NSViewMinXMargin];
  [save setButtonType: NSMomentaryPushButton];
  [save setTitle: _(@"Save in Drafts")];
  [save setTarget: self];
  [save setAction: @selector(saveClicked:)];
  [box addSubview: save];
  RELEASE(save);
  
  RELEASE(box);

  tabViewItem1 = [[NSTabViewItem alloc] initWithIdentifier: @"Tasks"];
  [tabViewItem1 setLabel: _(@"Tasks")];
  [tabViewItem1 setView: view];
  [tabView addTabViewItem: tabViewItem1];
  RELEASE(view);
  RELEASE(tabViewItem1);


  //
  // Our second tabview
  //
  messageColumn = [[NSTableColumn alloc] initWithIdentifier: @"Message"];
  [messageColumn setEditable: NO];
  [messageColumn setResizable: YES];
  [[messageColumn headerCell] setStringValue: _(@"Message")];
  [messageColumn setMinWidth: 115];
  [[messageColumn headerCell] setAlignment: NSLeftTextAlignment];
  
  messageDateColumn = [[NSTableColumn alloc] initWithIdentifier: @"Message Date"];
  [messageDateColumn setEditable: NO];
  [messageDateColumn setResizable: YES];
  [[messageDateColumn headerCell] setStringValue: _(@"Date")];
  [messageDateColumn setMinWidth: 140];
  [messageDateColumn setMaxWidth: 140];
  [[messageDateColumn headerCell] setAlignment: NSLeftTextAlignment];

  messagesScrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,35,470,100)];

  messagesTableView = [[NSTableView alloc] initWithFrame: [[messagesScrollView contentView] frame]];
  [messagesTableView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];
  [messagesTableView setDrawsGrid: NO];
  [messagesTableView setAllowsColumnSelection: NO];
  [messagesTableView setAllowsColumnReordering: NO];
  [messagesTableView setAllowsColumnResizing: YES];
  [messagesTableView setAllowsEmptySelection: YES];
  [messagesTableView setAllowsMultipleSelection: NO];
  [messagesTableView addTableColumn: messageColumn];
  [messagesTableView addTableColumn: messageDateColumn];
  [messagesTableView setAutoresizesAllColumnsToFit: YES];
  [messagesTableView sizeLastColumnToFit];
  [messagesTableView setDataSource: [self windowController]];
  [messagesTableView setDelegate: [self windowController]];
  RELEASE(messageColumn);
  RELEASE(messageDateColumn);

  [messagesScrollView setDocumentView: messagesTableView];
  [messagesScrollView setHasHorizontalScroller: YES];
  [messagesScrollView setHasVerticalScroller: YES];
  [messagesScrollView setBorderType: NSBezelBorder];
  [messagesScrollView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];

  tabViewItem2 = [[NSTabViewItem alloc] initWithIdentifier: @"Messages"];
  [tabViewItem2 setLabel: _(@"Messages")];
  [tabViewItem2 setView: messagesScrollView];
  [tabView addTabViewItem: tabViewItem2];
  RELEASE(tabViewItem2);
  
  //
  // We add our tabView
  //
  [[self contentView] addSubview: tabView];
  RELEASE(tabView);

  //
  // We set the window's minimum size
  //
  [self setMinSize: NSMakeSize(400,320)];
}

@end
