/*
**  MailWindow.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "MailWindow.h"

#include "ExtendedTextView.h"
#include "Constants.h"
#include "LabelWidget.h"


//
//
//
@implementation MailWindow

- (void) dealloc
{
  NSDebugLog(@"MailWindow: -dealloc");

  RELEASE(delete);
  RELEASE(mailboxes);
  RELEASE(compose);
  RELEASE(reply);
  RELEASE(forward);
  RELEASE(addresses);
  RELEASE(find);
  
  RELEASE(label);

  RELEASE(splitView);
  RELEASE(tableScrollView);
  RELEASE(textView);
  RELEASE(textScrollView);

  RELEASE(icon);
  RELEASE(get);
  
  [super dealloc];
}


//
//
//
- (void) layoutWindow
{
  NSRect mRect;

  mRect = NSMakeRect(0,0,562,150);
  
  // We first add our 'icon' image
  icon = [[NSButton alloc] initWithFrame: NSMakeRect(4,500,16,16)];
  [icon setImagePosition: NSImageOnly];
  [icon setImage: nil];
  [icon setBordered: NO];
  [icon setTarget: [NSApp delegate]];
  [icon setAction: @selector(showConsoleWindow:)];
  [icon setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: icon];
  
  delete = [[NSButton alloc] initWithFrame:NSMakeRect(24,520,64,64)];
  [delete setTitle: _(@"Delete")];
  [delete setFont: [NSFont systemFontOfSize: 8]];
  [delete setImagePosition: NSImageAbove];
  [delete setImage: [NSImage imageNamed: @"delete_48.tiff"]];
  [delete setTarget: [self windowController]];
  [delete setAction: @selector(deleteMessage:)];
  [delete setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: delete];
  
   // We then add the get button
  get = [[NSButton alloc] initWithFrame: NSMakeRect(96,520,64,64)];
  [get setTitle: _(@"Get")];
  [get setFont: [NSFont systemFontOfSize: 8]];
  [get setImagePosition: NSImageAbove];
  [get setImage: [NSImage imageNamed: @"retrieve_48.tiff"]];
  [get setTarget: [self windowController]];
  [get setAction: @selector(getNewMessages:)];
  [get setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: get];

  mailboxes = [[NSButton alloc] initWithFrame:NSMakeRect(168,520,64,64)];
  [mailboxes setTitle: _(@"Mailboxes")];
  [mailboxes setFont: [NSFont systemFontOfSize: 8]];
  [mailboxes setImagePosition: NSImageAbove];
  [mailboxes setImage: [NSImage imageNamed: @"mailboxes_48.tiff"]];
  [mailboxes setTarget: [NSApp delegate]];
  [mailboxes setAction: @selector(showMailboxManager:)];
  [mailboxes setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: mailboxes];
  
  compose = [[NSButton alloc] initWithFrame:NSMakeRect(240,520,64,64)];
  [compose setTitle: _(@"Compose")];
  [compose setFont: [NSFont systemFontOfSize: 8]];
  [compose setImagePosition: NSImageAbove];
  [compose setImage: [NSImage imageNamed: @"create_48.tiff"]];
  [compose setTarget: [NSApp delegate]];
  [compose setAction: @selector(composeMessage:)];
  [compose setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: compose];
  
  reply = [[NSButton alloc] initWithFrame:NSMakeRect(312,520,64,64)];
  [reply setTitle: _(@"Reply")];
  [reply setFont: [NSFont systemFontOfSize: 8]];
  [reply setImagePosition: NSImageAbove];
  [reply setImage: [NSImage imageNamed: @"reply_48.tiff"]];
  [reply setTarget: [self windowController]];
  [reply setAction: @selector(replyMessage:)];
  [reply setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: reply];
  
  forward = [[NSButton alloc] initWithFrame:NSMakeRect(384,520,64,64)];
  [forward setTitle: _(@"Forward")];
  [forward setFont: [NSFont systemFontOfSize: 8]];
  [forward setImagePosition: NSImageAbove];
  [forward setImage: [NSImage imageNamed: @"forward_48.tiff"]];
  [forward setTarget: [self windowController]];
  [forward setAction: @selector(forwardMessage:)];
  [forward setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: forward];
  
  addresses = [[NSButton alloc] initWithFrame:NSMakeRect(452,520,64,64)];
  [addresses setTitle: _(@"Addresses")];
  [addresses setFont: [NSFont systemFontOfSize: 8]];
  [addresses setImagePosition: NSImageAbove];
  [addresses setImage: [NSImage imageNamed: @"addresses_48.tiff"]];
  [addresses setTarget: [NSApp delegate]];
  [addresses setAction: @selector(showAddressBook:)];
  [addresses setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: addresses];
  
  find = [[NSButton alloc] initWithFrame:NSMakeRect(524,520,64,64)];
  [find setTitle: _(@"Find")];
  [find setFont: [NSFont systemFontOfSize: 8]];
  [find setImagePosition: NSImageAbove];
  [find setImage: [NSImage imageNamed: @"find_48.tiff"]];
  [find setTarget: [NSApp delegate]];
  [find setAction: @selector(showFindWindow:)];
  [find setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: find];
  
  label = [LabelWidget labelWidgetWithFrame:NSMakeRect(24,498,500,20)
		       label: @""];
  RETAIN(label);
  [label setFont: [NSFont systemFontOfSize: 10]];
  [label setTextColor: [NSColor darkGrayColor]];
  [label setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: label];
  
  // We create our split view
  splitView = [[NSSplitView alloc] initWithFrame: NSMakeRect(5,5,602,490)];
  [splitView setVertical: NO];
  [splitView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];
  
  //
  // We create our table scroll view and our textview object.
  //
  tableScrollView = [[NSScrollView alloc] initWithFrame: mRect];
  [tableScrollView setBorderType: NSBezelBorder];
  [tableScrollView setHasHorizontalScroller: NO];
  [tableScrollView setHasVerticalScroller: YES];
  [tableScrollView setAutoresizingMask: NSViewWidthSizable|NSViewHeightSizable];
  
  textScrollView = [[NSScrollView alloc] initWithFrame: mRect];
  [textScrollView setBorderType: NSBezelBorder];
  [textScrollView setHasHorizontalScroller: NO];
  [textScrollView setHasVerticalScroller: YES];
 
  mRect = [[textScrollView contentView] frame];
  textView = [[ExtendedTextView alloc] init];
  [textView setFrame: mRect];
  [textView setTextContainerInset: NSMakeSize(5,5)];
  [textView setBackgroundColor: [NSColor textBackgroundColor]];
  [textView setRichText: YES];
  [textView setUsesFontPanel: YES];
  [textView setDelegate: [self windowController]];
  [textView setHorizontallyResizable: NO];
  [textView setVerticallyResizable: YES];
  [textView setMinSize: NSMakeSize (0, 0)];
  [textView setMaxSize: NSMakeSize (1E7, 1E7)];
  [textView setAutoresizingMask: NSViewHeightSizable|NSViewWidthSizable];
  [[textView textContainer] setContainerSize: NSMakeSize (mRect.size.width, 1E7)];

  [[textView textContainer] setWidthTracksTextView: YES];
  [textView setEditable: NO];
  [textView setString: @""];
  
  [textScrollView setDocumentView: textView];
  
  [splitView addSubview: tableScrollView];
  [splitView addSubview: textScrollView];
  [splitView adjustSubviews];
  
  [[self contentView] addSubview: splitView];

  [self setMinSize: NSMakeSize(612,595)];
}

@end
