#!/usr/bin/env python
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2004 Free Software Foundation
#
# FILE:
# create-label-list.py
#
# DESCRIPTION:
#
# NOTES:

import sys
from gnue.reports.adapters.filters.Labels.labels import *

class CreateLabelList:

  def run(self):

    LabelDef = {}

    ## Assign Label Data File to parse
    try:
      LabelDataFile = sys.argv[1]
    except:
      print "You must define a Labels Data File."
      sys.exit()

    ## Determine if output file is to file or stdout
    try:
      LabelListFile = sys.argv[2]
      try:
        LabelListOutput = open(LabelListFile, "w")
      except:
        print "Cannot open %s for writing." % (LabelListFile)
    except:
      print "You must define and output file."


    ## Load Data Def File w/o Mapping Alias Names Into Memory
    LabelDef = LabelSpecs.initLabelDefs(LabelDataFile, 0)


    self.WriteHeader(LabelListOutput, LabelDef)
    self.WriteContent(LabelDef, LabelDataFile, LabelListOutput)
    self.WriteFooter(LabelListOutput)

    ## Close output file
    LabelListOutput.close




  def WriteContent(self, LabelInfo, InputFile, OutputFile):


    ## Roll through each Alias and gather details
    for key in LabelInfo.keys():
      OutputFile.write("<row>\n")
      AliasInfo = LabelSpecs.getByName(key)
      for data in AliasInfo.keys():
        OutputFile.write(("<entry>%s</entry>\n") % (AliasInfo[data].encode('ascii','replace')))
#        OutputFile.write(("  %s : %s\n") % (data.encode('ascii','replace'), AliasInfo[data].encode('ascii','replace')))
      OutputFile.write("</row>\n")






  def WriteHeader(self, OutputFile, LabelInfo):
    OutputFile.write("""<!doctype article public "-//OASIS//DTD DocBook V4.0//EN">

<article>
 <articleinfo>
  <title>
  Supported Label Filters
 </title>
 <subtitle>GNU Enterprise Reports</subtitle>
 </articleinfo>
<para>
<table frame='all'><title>Supported Labels</title>
<tgroup cols='4' align='left' colsep='1' rowsep='1'>
<thead>
<row>
  <entry>Category</entry>
  <entry>Brand</entry>
  <entry>Part #</entry>
  <entry>Description</entry>
</row>
</thead>
<tfoot>
<row>
  <entry></entry>
  <entry></entry>
  <entry>Total Labels Supported:</entry>
""")
    OutputFile.write(("<entry>%s</entry>") % (len(LabelInfo)))
    OutputFile.write("""</row>
</tfoot>
<tbody>
""")



  def WriteFooter(self, OutputFile):
    OutputFile.write("""</tbody>
</tgroup>
</table>
</para>
</article>
""")


if __name__ == '__main__':
  CreateLabelList().run()