#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# GRSources.py
#
# DESCRIPTION:
# Class
#
# NOTES:
#


from gnue.common.definitions.GObjects import *
from gnue.common.datasources import GDataSource
from gnue.common.datasources.GConditions import GCondition
from gnue.common.apps import GDebug
import GRExceptions

class GRSources (GObj):
  def __init__(self, parent):
    GObj.__init__(self, parent, type='GRSources')


  #
  # Prepare for running
  #
  # TODO: please go bye-bye
  def prepare(self, parameters, sortoptions):

    self._parameters = parameters
    self._sortoptions = sortoptions

    # Connect to databases
    self._datasourceDictionary = {}
    self.walk(self.__initConnections)


  # Used internally by self.prepare()
  # Connects to databases
  #
  # TODO: please go bye-bye
  def __initConnections(self, object):
    if object._type == "GRDataSource":
      object.connect()


  def getDataSource(self, source):
    return self._parent._datasourceDictionary[string.lower(source)]


class GRDataSource (GDataSource.GDataSource):
  def __init__(self, parent):
    GDataSource.GDataSource.__init__(self, parent, 'GRDataSource')
    self._toplevelParent = 'GRReport'
    self.master = None

  #  Used in GRSources.__connectMasterDetail to link detail datasource to
  #  master source.  Called by GDataObjects.ResultSet when master changed
  #  This will actually be over-written by GRDataMapper but at the time
  #  the master-detail must be linked, the GRDataMapper will not have been
  #  created yet. [Yes, it's fugly]
  def masterResultSetChanged(self, masterResultSet, detailResultSet):
    # [This is overwritten by GRDataMapper._masterChanged]
    pass




class GRConditions(GCondition):
  def __init__(self, parent):
    GCondition.__init__(self, parent, 'GRConditions')

