#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2004 Free Software Foundation
#
# FILE:
# MinimalistDriver.py
#
# DESCRIPTION:
# Printer definition for "MinimalistDriver"
#
# NOTES:
# This file was automatically generated by
#   reports/utils/create-ppd-classes.py

__all__ = ['MinimalistDriver']

from gnue.reports.adapters.filters.Universal.Base.psutils.PrinterDefinition import *
from gnue.reports.adapters.filters.Universal.Base.psutils.PrinterDefinition    import _Property

class MinimalistDriver (PrinterDefinition):
  def __init__(self):
    self.__dict__.update( {
      "__uioptions__": {
          },
      "__values__": {
          },
      "__symbols__": {
          },
      "__properties__": {
          "PaperDimension": [
_Property({
                      "data": '612 792"',
                      "option": 'Letter',
                      "keyword": 'PaperDimension',
                      "option_translation": 'US Letter',
                      }),
_Property({
                      "data": '612 1008"',
                      "option": 'Legal',
                      "keyword": 'PaperDimension',
                      "option_translation": 'US Legal',
                      }),
_Property({
                      "data": '595 842"',
                      "option": 'A4',
                      "keyword": 'PaperDimension',
                      "option_translation": None,
                      }),
_Property({
                      "data": '516 729"',
                      "option": 'B5',
                      "keyword": 'PaperDimension',
                      "option_translation": None,
                      }),
_Property({
                      "data": '420 595"',
                      "option": 'A5',
                      "keyword": 'PaperDimension',
                      "option_translation": None,
                      }),
_Property({
                      "data": '612 792"',
                      "option": 'LetterSmall',
                      "keyword": 'PaperDimension',
                      "option_translation": 'US Letter Small',
                      }),
_Property({
                      "data": '595 842"',
                      "option": 'A4Small',
                      "keyword": 'PaperDimension',
                      "option_translation": 'A4 Small',
                      }),
_Property({
                      "data": '612 1008"',
                      "option": 'LegalSmall',
                      "keyword": 'PaperDimension',
                      "option_translation": 'US Legal Small',
                      }),
_Property({
                      "data": '297 684"',
                      "option": 'Com10',
                      "keyword": 'PaperDimension',
                      "option_translation": 'Comm10 Envelope',
                      }),
_Property({
                      "data": '279 540"',
                      "option": 'Monarch',
                      "keyword": 'PaperDimension',
                      "option_translation": 'Monarch Envelope',
                      }),
_Property({
                      "data": '459 649"',
                      "option": 'C5',
                      "keyword": 'PaperDimension',
                      "option_translation": 'C5 Envelope',
                      }),
_Property({
                      "data": '312 624"',
                      "option": 'DL',
                      "keyword": 'PaperDimension',
                      "option_translation": 'DL Envelope',
                      }),
                  ],
          "PPD-Adobe": [
_Property({
                      "data": '4.2"',
                      "option": '',
                      "keyword": 'PPD-Adobe',
                      "option_translation": None,
                      }),
                  ],
          "ManualFeed": [
_Property({
                      "data": '1 dict dup /ManualFeed true put setpagedevice"',
                      "option": 'True',
                      "keyword": 'ManualFeed',
                      "option_translation": None,
                      }),
_Property({
                      "data": '1 dict dup /ManualFeed false put setpagedevice"',
                      "option": 'False',
                      "keyword": 'ManualFeed',
                      "option_translation": None,
                      }),
                  ],
          "Transfer": [
_Property({
                      "data": '{ }"',
                      "option": 'Null',
                      "keyword": 'Transfer',
                      "option_translation": None,
                      }),
_Property({
                      "data": '{ 1 exch sub }"',
                      "option": 'Null.Inverse',
                      "keyword": 'Transfer',
                      "option_translation": None,
                      }),
                  ],
          "BitsPerPixel": [
_Property({
                      "data": '2 dict dup /PreRenderingEnhance true put setpagedevice\r\n',
                      "option": '4',
                      "keyword": 'BitsPerPixel',
                      "option_translation": 'On',
                      }),
_Property({
                      "data": '2 dict dup /PreRenderingEnhance false put setpagedevice\r\n',
                      "option": 'None',
                      "keyword": 'BitsPerPixel',
                      "option_translation": 'Off',
                      }),
                  ],
          "Smoothing": [
_Property({
                      "data": '2 dict dup /PostRenderingEnhance true put setpagedevice\r\n',
                      "option": 'True',
                      "keyword": 'Smoothing',
                      "option_translation": 'On',
                      }),
_Property({
                      "data": '2 dict dup /PostRenderingEnhance false put setpagedevice\r\n',
                      "option": 'False',
                      "keyword": 'Smoothing',
                      "option_translation": 'Off',
                      }),
                  ],
          "Source": [
_Property({
                      "data": 'EtherTalk"',
                      "option": '',
                      "keyword": 'Source',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'RemotePrinter"',
                      "option": '',
                      "keyword": 'Source',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrintServer"',
                      "option": '',
                      "keyword": 'Source',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'LPR"',
                      "option": '',
                      "keyword": 'Source',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'LocalTalk"',
                      "option": '',
                      "keyword": 'Source',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Parallel"',
                      "option": '',
                      "keyword": 'Source',
                      "option_translation": None,
                      }),
                  ],
          "ExitServer": [
_Property({
                      "data": 'count 0 eq\r\n{ false } { true exch startjob } ifelse\r\nnot { \r\n\t(WARNING: Cannot modify initial VM.) =\r\n\t(Missing or invalid password.) =\r\n\t(Please contact the author of this software.) = flush quit\r\n\t} if\r\n',
                      "option": '',
                      "keyword": 'ExitServer',
                      "option_translation": None,
                      }),
                  ],
          "LanguageLevel": [
_Property({
                      "data": '2"',
                      "option": '',
                      "keyword": 'LanguageLevel',
                      "option_translation": None,
                      }),
                  ],
          "PSVersion": [
_Property({
                      "data": '(2014.106) 1"',
                      "option": '',
                      "keyword": 'PSVersion',
                      "option_translation": None,
                      }),
                  ],
          "InkName": [
_Property({
                      "data": 'ProcessBlack/Process Black',
                      "option": '',
                      "keyword": 'InkName',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'CustomColor/Custom Color',
                      "option": '',
                      "keyword": 'InkName',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'ProcessCyan/Process Cyan',
                      "option": '',
                      "keyword": 'InkName',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'ProcessMagenta/Process Magenta',
                      "option": '',
                      "keyword": 'InkName',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'ProcessYellow/Process Yellow',
                      "option": '',
                      "keyword": 'InkName',
                      "option_translation": None,
                      }),
                  ],
          "ShortNickName": [
_Property({
                      "data": 'Apple LaserWriter 16/600 PS"',
                      "option": '',
                      "keyword": 'ShortNickName',
                      "option_translation": None,
                      }),
                  ],
          "ColorSepScreenFreq": [
_Property({
                      "data": '84.8528"',
                      "option": 'ProcessBlack.85lpi.600dpi',
                      "keyword": 'ColorSepScreenFreq',
                      "option_translation": '85 lpi / 600 dpi',
                      }),
_Property({
                      "data": '84.8528"',
                      "option": 'CustomColor.85lpi.600dpi',
                      "keyword": 'ColorSepScreenFreq',
                      "option_translation": '85 lpi / 600 dpi',
                      }),
_Property({
                      "data": '94.8683"',
                      "option": 'ProcessCyan.85lpi.600dpi',
                      "keyword": 'ColorSepScreenFreq',
                      "option_translation": '85 lpi / 600 dpi',
                      }),
_Property({
                      "data": '94.8683"',
                      "option": 'ProcessMagenta.85lpi.600dpi',
                      "keyword": 'ColorSepScreenFreq',
                      "option_translation": '85 lpi / 600 dpi',
                      }),
_Property({
                      "data": '30.0"',
                      "option": 'ProcessYellow.85lpi.600dpi',
                      "keyword": 'ColorSepScreenFreq',
                      "option_translation": '85 lpi / 600 dpi',
                      }),
_Property({
                      "data": '70.7107"',
                      "option": 'ProcessBlack.71lpi.600dpi',
                      "keyword": 'ColorSepScreenFreq',
                      "option_translation": '71 lpi / 600 dpi',
                      }),
_Property({
                      "data": '70.7107"',
                      "option": 'CustomColor.71lpi.600dpi',
                      "keyword": 'ColorSepScreenFreq',
                      "option_translation": '71 lpi / 600 dpi',
                      }),
_Property({
                      "data": '63.2456"',
                      "option": 'ProcessCyan.71lpi.600dpi',
                      "keyword": 'ColorSepScreenFreq',
                      "option_translation": '71 lpi / 600 dpi',
                      }),
_Property({
                      "data": '63.2456"',
                      "option": 'ProcessMagenta.71lpi.600dpi',
                      "keyword": 'ColorSepScreenFreq',
                      "option_translation": '71 lpi / 600 dpi',
                      }),
_Property({
                      "data": '66.6667"',
                      "option": 'ProcessYellow.71lpi.600dpi',
                      "keyword": 'ColorSepScreenFreq',
                      "option_translation": '71 lpi / 600 dpi',
                      }),
                  ],
          "InstalledMemory": [
_Property({
                      "data": '"',
                      "option": '8Meg',
                      "keyword": 'InstalledMemory',
                      "option_translation": 'Universal 8 MB RAM',
                      }),
_Property({
                      "data": '"',
                      "option": '12Meg',
                      "keyword": 'InstalledMemory',
                      "option_translation": '12 MB Upgrade',
                      }),
_Property({
                      "data": '"',
                      "option": '16Meg',
                      "keyword": 'InstalledMemory',
                      "option_translation": '16 MB Upgrade',
                      }),
_Property({
                      "data": '"',
                      "option": '24Meg',
                      "keyword": 'InstalledMemory',
                      "option_translation": '24 MB Upgrade',
                      }),
_Property({
                      "data": '"',
                      "option": '32Meg',
                      "keyword": 'InstalledMemory',
                      "option_translation": '32 MB Upgrade',
                      }),
                  ],
          "Product": [
_Property({
                      "data": '(LaserWriter 16/600 PS)"',
                      "option": '',
                      "keyword": 'Product',
                      "option_translation": None,
                      }),
                  ],
          "PageSize": [
_Property({
                      "data": '2 dict dup /PageSize [612 792] put dup /ImagingBBox null put setpagedevice',
                      "option": 'Letter',
                      "keyword": 'PageSize',
                      "option_translation": 'US Letter',
                      }),
_Property({
                      "data": '2 dict dup /PageSize [612 1008] put dup /ImagingBBox null put setpagedevice',
                      "option": 'Legal',
                      "keyword": 'PageSize',
                      "option_translation": 'US Legal',
                      }),
_Property({
                      "data": '2 dict dup /PageSize [595 842] put dup /ImagingBBox null put setpagedevice',
                      "option": 'A4',
                      "keyword": 'PageSize',
                      "option_translation": None,
                      }),
_Property({
                      "data": '2 dict dup /PageSize [516 729] put dup /ImagingBBox null put setpagedevice',
                      "option": 'B5',
                      "keyword": 'PageSize',
                      "option_translation": None,
                      }),
_Property({
                      "data": '3 dict dup /PageSize [420 595] put dup  /ImagingBBox null put\r\n\tdup /InputAttributes 1 dict dup 1 1 dict dup /PageSize [420 595] put put put setpagedevice ',
                      "option": 'A5',
                      "keyword": 'PageSize',
                      "option_translation": None,
                      }),
_Property({
                      "data": '2 dict dup /PageSize [612 792] put dup /ImagingBBox [25 25 587 767] put setpagedevice',
                      "option": 'LetterSmall',
                      "keyword": 'PageSize',
                      "option_translation": 'US Letter Small',
                      }),
_Property({
                      "data": '2 dict dup /PageSize [595 842] put dup /ImagingBBox [25 25 570 817] put setpagedevice',
                      "option": 'A4Small',
                      "keyword": 'PageSize',
                      "option_translation": 'A4 Small',
                      }),
_Property({
                      "data": '2 dict dup /PageSize [612 1008] put dup /ImagingBBox [25 25 587 983] put setpagedevice',
                      "option": 'LegalSmall',
                      "keyword": 'PageSize',
                      "option_translation": 'US Legal Small',
                      }),
_Property({
                      "data": 'currentpagedevice /InputAttributes get 3 known {3} {1} ifelse\r\n\t3 dict dup /InputAttributes 1 dict dup 6 -1 roll 1 dict dup /PageSize [297 684] put put put\r\n\tdup /PageSize [297 684] put dup /ImagingBBox null put setpagedevice ',
                      "option": 'Com10',
                      "keyword": 'PageSize',
                      "option_translation": 'Comm10 Envelope',
                      }),
_Property({
                      "data": 'currentpagedevice /InputAttributes get 3 known {3} {1} ifelse\r\n\t3 dict dup /InputAttributes 1 dict dup 6 -1 roll 1 dict dup /PageSize [279 540] put put put\r\n\tdup /PageSize [279 540] put dup /ImagingBBox null put setpagedevice ',
                      "option": 'Monarch',
                      "keyword": 'PageSize',
                      "option_translation": 'Monarch Envelope',
                      }),
_Property({
                      "data": 'currentpagedevice /InputAttributes get 3 known {3} {1} ifelse\r\n\t3 dict dup /InputAttributes 1 dict dup 6 -1 roll 1 dict dup /PageSize [459 649] put put put\r\n\tdup /PageSize [459 649] put dup /ImagingBBox null put setpagedevice ',
                      "option": 'C5',
                      "keyword": 'PageSize',
                      "option_translation": 'C5 Envelope',
                      }),
_Property({
                      "data": 'currentpagedevice /InputAttributes get 3 known {3} {1} ifelse\r\n\t3 dict dup /InputAttributes 1 dict dup 6 -1 roll 1 dict dup /PageSize [312 624] put put put\r\n\tdup /PageSize [312 624] put dup /ImagingBBox null put setpagedevice ',
                      "option": 'DL',
                      "keyword": 'PageSize',
                      "option_translation": 'DL Envelope',
                      }),
                  ],
          "LanguageEncoding": [
_Property({
                      "data": 'ISOLatin1',
                      "option": '',
                      "keyword": 'LanguageEncoding',
                      "option_translation": None,
                      }),
                  ],
          "RequiresPageRegion": [
_Property({
                      "data": 'True',
                      "option": 'Multipurpose',
                      "keyword": 'RequiresPageRegion',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'True',
                      "option": 'Envelope',
                      "keyword": 'RequiresPageRegion',
                      "option_translation": None,
                      }),
                  ],
          "OrderDependency": [
_Property({
                      "data": '20 AnySetup *Smoothing',
                      "option": '',
                      "keyword": 'OrderDependency',
                      "option_translation": None,
                      }),
_Property({
                      "data": '20 AnySetup *BitsPerPixel',
                      "option": '',
                      "keyword": 'OrderDependency',
                      "option_translation": None,
                      }),
_Property({
                      "data": '20 AnySetup *PageSize',
                      "option": '',
                      "keyword": 'OrderDependency',
                      "option_translation": None,
                      }),
_Property({
                      "data": '20 AnySetup *PageRegion',
                      "option": '',
                      "keyword": 'OrderDependency',
                      "option_translation": None,
                      }),
_Property({
                      "data": '20 AnySetup *InputSlot',
                      "option": '',
                      "keyword": 'OrderDependency',
                      "option_translation": None,
                      }),
_Property({
                      "data": '20 AnySetup *ManualFeed',
                      "option": '',
                      "keyword": 'OrderDependency',
                      "option_translation": None,
                      }),
_Property({
                      "data": '20 AnySetup *TraySwitch',
                      "option": '',
                      "keyword": 'OrderDependency',
                      "option_translation": None,
                      }),
                  ],
          "Emulators": [
_Property({
                      "data": 'LaserJetIII',
                      "option": '',
                      "keyword": 'Emulators',
                      "option_translation": None,
                      }),
                  ],
          "StopEmulator_LaserJetIII": [
_Property({
                      "data": '<1B>E"',
                      "option": '',
                      "keyword": 'StopEmulator_LaserJetIII',
                      "option_translation": None,
                      }),
                  ],
          "FreeVM": [
_Property({
                      "data": '1539456"',
                      "option": '',
                      "keyword": 'FreeVM',
                      "option_translation": None,
                      }),
                  ],
          "FileSystem": [
_Property({
                      "data": 'True',
                      "option": '',
                      "keyword": 'FileSystem',
                      "option_translation": None,
                      }),
                  ],
          "OpenUI": [
_Property({
                      "data": 'PickOne',
                      "option": '*InstalledMemory',
                      "keyword": 'OpenUI',
                      "option_translation": 'Memory Configuration',
                      }),
_Property({
                      "data": 'PickOne',
                      "option": '*OptionalCassette1',
                      "keyword": 'OpenUI',
                      "option_translation": 'Cassette (500 Sheets)',
                      }),
_Property({
                      "data": 'Boolean',
                      "option": '*OptionalEnvelopeFeeder',
                      "keyword": 'OpenUI',
                      "option_translation": 'Envelope Feeder',
                      }),
_Property({
                      "data": 'Boolean',
                      "option": '*Smoothing',
                      "keyword": 'OpenUI',
                      "option_translation": 'FinePrint(TM)',
                      }),
_Property({
                      "data": 'PickOne',
                      "option": '*BitsPerPixel',
                      "keyword": 'OpenUI',
                      "option_translation": 'PhotoGrade(TM)',
                      }),
_Property({
                      "data": 'PickOne',
                      "option": '*PageSize',
                      "keyword": 'OpenUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PickOne',
                      "option": '*PageRegion',
                      "keyword": 'OpenUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PickOne',
                      "option": '*InputSlot',
                      "keyword": 'OpenUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Boolean',
                      "option": '*ManualFeed',
                      "keyword": 'OpenUI',
                      "option_translation": 'Manual Feed',
                      }),
_Property({
                      "data": 'Boolean',
                      "option": '*TraySwitch',
                      "keyword": 'OpenUI',
                      "option_translation": 'Tray Switch',
                      }),
                  ],
          "ColorDevice": [
_Property({
                      "data": 'False',
                      "option": '',
                      "keyword": 'ColorDevice',
                      "option_translation": None,
                      }),
                  ],
          "Password": [
_Property({
                      "data": '()"',
                      "option": '',
                      "keyword": 'Password',
                      "option_translation": None,
                      }),
                  ],
          "Protocols": [
_Property({
                      "data": 'BCP',
                      "option": '',
                      "keyword": 'Protocols',
                      "option_translation": None,
                      }),
                  ],
          "Reset": [
_Property({
                      "data": 'count 0 eq\r\n{ false } { true exch startjob } ifelse\r\nnot { \r\n\t(WARNING: Cannot reset printer.) =\r\n\t(Missing or invalid password.) =\r\n\t(Please contact the author of this software.) = flush quit\r\n\t} if\r\nsystemdict /quit get exec\r\n(WARNING : Printer Reset Failed.) = flush\r\n',
                      "option": '',
                      "keyword": 'Reset',
                      "option_translation": None,
                      }),
                  ],
          "Status": [
_Property({
                      "data": 'initializing"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'idle"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'busy"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'waiting"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: cover open"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: warming up"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: toner cartridge missing or incorrect"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: paper jam"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: Cassette (250 Sheets): no paper tray"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: Cassette (250 Sheets): out of paper"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: Cassette (500 Sheets): no paper tray"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: Cassette (500 Sheets): out of paper"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: Multipurpose Tray: out of paper"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: Envelope Feeder: out of paper"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: waiting for manual feed"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: fixing temperature malfunction"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: scanner motor malfunction"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: incorrect paper size setting"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'PrinterError: Page image timeout"',
                      "option": '',
                      "keyword": 'Status',
                      "option_translation": None,
                      }),
                  ],
          "PrinterError": [
_Property({
                      "data": 'cover open"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'warming up"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'toner cartridge missing or incorrect"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'paper jam"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Cassette (250 Sheets): no paper tray"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Cassette (250 Sheets): out of paper"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Cassette (500 Sheets): no paper tray"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Cassette (500 Sheets): out of paper"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Multipurpose Tray: out of paper"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Envelope Feeder: out of paper"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'waiting for manual feed"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'fixing temperature malfunction"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'scanner motor malfunction"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'incorrect paper size setting"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Page image timeout"',
                      "option": '',
                      "keyword": 'PrinterError',
                      "option_translation": None,
                      }),
                  ],
          "ModelName": [
_Property({
                      "data": 'Apple LaserWriter 16/600 PS"',
                      "option": '',
                      "keyword": 'ModelName',
                      "option_translation": None,
                      }),
                  ],
          "FileVersion": [
_Property({
                      "data": '4.1"',
                      "option": '',
                      "keyword": 'FileVersion',
                      "option_translation": None,
                      }),
                  ],
          "TraySwitch": [
_Property({
                      "data": '1 dict dup /TraySwitch true put setpagedevice"',
                      "option": 'True',
                      "keyword": 'TraySwitch',
                      "option_translation": 'On',
                      }),
_Property({
                      "data": '1 dict dup /TraySwitch false put setpagedevice"',
                      "option": 'False',
                      "keyword": 'TraySwitch',
                      "option_translation": 'Off',
                      }),
                  ],
          "CloseGroup": [
_Property({
                      "data": 'InstallableOptions',
                      "option": '',
                      "keyword": 'CloseGroup',
                      "option_translation": None,
                      }),
                  ],
          "TTRasterizer": [
_Property({
                      "data": 'Type42',
                      "option": '',
                      "keyword": 'TTRasterizer',
                      "option_translation": None,
                      }),
                  ],
          "VMOption": [
_Property({
                      "data": '1539456"',
                      "option": '8Meg',
                      "keyword": 'VMOption',
                      "option_translation": None,
                      }),
_Property({
                      "data": '1662336"',
                      "option": '12Meg',
                      "keyword": 'VMOption',
                      "option_translation": None,
                      }),
_Property({
                      "data": '5815680"',
                      "option": '16Meg',
                      "keyword": 'VMOption',
                      "option_translation": None,
                      }),
_Property({
                      "data": '14114176"',
                      "option": '24Meg',
                      "keyword": 'VMOption',
                      "option_translation": None,
                      }),
_Property({
                      "data": '22396288"',
                      "option": '32Meg',
                      "keyword": 'VMOption',
                      "option_translation": None,
                      }),
                  ],
          "OptionalEnvelopeFeeder": [
_Property({
                      "data": '"',
                      "option": 'True',
                      "keyword": 'OptionalEnvelopeFeeder',
                      "option_translation": 'Installed',
                      }),
_Property({
                      "data": '"',
                      "option": 'False',
                      "keyword": 'OptionalEnvelopeFeeder',
                      "option_translation": 'Not Installed',
                      }),
                  ],
          "OptionalCassette1": [
_Property({
                      "data": '"',
                      "option": 'True',
                      "keyword": 'OptionalCassette1',
                      "option_translation": 'Installed',
                      }),
_Property({
                      "data": '"',
                      "option": 'False',
                      "keyword": 'OptionalCassette1',
                      "option_translation": 'Not Installed',
                      }),
_Property({
                      "data": '1 dict dup /InputAttributes 1 dict dup /Priority [2 0 1 3] put put setpagedevice',
                      "option": 'Preferred',
                      "keyword": 'OptionalCassette1',
                      "option_translation": 'Installed and Preferred',
                      }),
                  ],
          "FormatVersion": [
_Property({
                      "data": '4.2"',
                      "option": '',
                      "keyword": 'FormatVersion',
                      "option_translation": None,
                      }),
                  ],
          "StartEmulator_LaserJetIII": [
_Property({
                      "data": 'currentfile /LaserJetIII statusdict /emulate get exec "',
                      "option": '',
                      "keyword": 'StartEmulator_LaserJetIII',
                      "option_translation": None,
                      }),
                  ],
          "VariablePaperSize": [
_Property({
                      "data": 'False',
                      "option": '',
                      "keyword": 'VariablePaperSize',
                      "option_translation": None,
                      }),
                  ],
          "PrintPSErrors": [
_Property({
                      "data": 'False',
                      "option": '',
                      "keyword": 'PrintPSErrors',
                      "option_translation": None,
                      }),
                  ],
          "LandscapeOrientation": [
_Property({
                      "data": 'Minus90',
                      "option": '',
                      "keyword": 'LandscapeOrientation',
                      "option_translation": None,
                      }),
                  ],
          "NickName": [
_Property({
                      "data": 'Apple LaserWriter 16/600 PS v2014.106"',
                      "option": '',
                      "keyword": 'NickName',
                      "option_translation": None,
                      }),
                  ],
          "ColorSepScreenAngle": [
_Property({
                      "data": '45.0"',
                      "option": 'ProcessBlack.85lpi.600dpi',
                      "keyword": 'ColorSepScreenAngle',
                      "option_translation": '85 lpi / 600 dpi',
                      }),
_Property({
                      "data": '45.0"',
                      "option": 'CustomColor.85lpi.600dpi',
                      "keyword": 'ColorSepScreenAngle',
                      "option_translation": '85 lpi / 600 dpi',
                      }),
_Property({
                      "data": '71.5651"',
                      "option": 'ProcessCyan.85lpi.600dpi',
                      "keyword": 'ColorSepScreenAngle',
                      "option_translation": '85 lpi / 600 dpi',
                      }),
_Property({
                      "data": '18.4349"',
                      "option": 'ProcessMagenta.85lpi.600dpi',
                      "keyword": 'ColorSepScreenAngle',
                      "option_translation": '85 lpi / 600 dpi',
                      }),
_Property({
                      "data": '0.0"',
                      "option": 'ProcessYellow.85lpi.600dpi',
                      "keyword": 'ColorSepScreenAngle',
                      "option_translation": '85 lpi / 600 dpi',
                      }),
_Property({
                      "data": '45.0"',
                      "option": 'ProcessBlack.71lpi.600dpi',
                      "keyword": 'ColorSepScreenAngle',
                      "option_translation": '71 lpi / 600 dpi',
                      }),
_Property({
                      "data": '45.0"',
                      "option": 'CustomColor.71lpi.600dpi',
                      "keyword": 'ColorSepScreenAngle',
                      "option_translation": '71 lpi / 600 dpi',
                      }),
_Property({
                      "data": '71.5651"',
                      "option": 'ProcessCyan.71lpi.600dpi',
                      "keyword": 'ColorSepScreenAngle',
                      "option_translation": '71 lpi / 600 dpi',
                      }),
_Property({
                      "data": '18.4349"',
                      "option": 'ProcessMagenta.71lpi.600dpi',
                      "keyword": 'ColorSepScreenAngle',
                      "option_translation": '71 lpi / 600 dpi',
                      }),
_Property({
                      "data": '0.0"',
                      "option": 'ProcessYellow.71lpi.600dpi',
                      "keyword": 'ColorSepScreenAngle',
                      "option_translation": '71 lpi / 600 dpi',
                      }),
                  ],
          "PageRegion": [
_Property({
                      "data": '3 dict dup /PageSize [612 792] put dup /ImagingBBox null put\r\n\tdup /InputAttributes 2 dict dup 1 1 dict dup /PageSize [612 792] put put\r\n\tcurrentpagedevice /InputAttributes get 3 known {dup 3 1 dict dup /PageSize [612 792] put put}if \r\n\tput setpagedevice\r\n',
                      "option": 'Letter',
                      "keyword": 'PageRegion',
                      "option_translation": 'US Letter',
                      }),
_Property({
                      "data": '3 dict dup /PageSize [612 1008] put dup /ImagingBBox null put\r\n\tdup /InputAttributes 2 dict dup 1 1 dict dup /PageSize [612 1008] put put\r\n\tcurrentpagedevice /InputAttributes get 3 known {dup 3 1 dict dup /PageSize [612 1008] put put}if \r\n\tput setpagedevice\r\n',
                      "option": 'Legal',
                      "keyword": 'PageRegion',
                      "option_translation": 'US Legal',
                      }),
_Property({
                      "data": '3 dict dup /PageSize [595 842] put dup /ImagingBBox null put\r\n\tdup /InputAttributes 2 dict dup 1 1 dict dup /PageSize [595 842] put put\r\n\tcurrentpagedevice /InputAttributes get 3 known {dup 3 1 dict dup /PageSize [595 842] put put}if \r\n\tput setpagedevice\r\n',
                      "option": 'A4',
                      "keyword": 'PageRegion',
                      "option_translation": None,
                      }),
_Property({
                      "data": '3 dict dup /PageSize [516 729] put dup /ImagingBBox null put\r\n\tdup /InputAttributes 2 dict dup 1 1 dict dup /PageSize [516 729] put put\r\n\tcurrentpagedevice /InputAttributes get 3 known {dup 3 1 dict dup /PageSize [516 729] put put}if \r\n\tput setpagedevice\r\n',
                      "option": 'B5',
                      "keyword": 'PageRegion',
                      "option_translation": None,
                      }),
_Property({
                      "data": '3 dict dup /PageSize [420 595] put dup /ImagingBBox null put\r\n\tdup /InputAttributes 2 dict dup 1 1 dict dup /PageSize [420 595] put put\r\n\tcurrentpagedevice /InputAttributes get 3 known {dup 3 1 dict dup /PageSize [420 595] put put}if \r\n\tput setpagedevice\r\n',
                      "option": 'A5',
                      "keyword": 'PageRegion',
                      "option_translation": None,
                      }),
_Property({
                      "data": '3 dict dup /PageSize [612 792] put dup /ImagingBBox [25 25 587 767] put\r\n\tdup /InputAttributes 2 dict dup 1 1 dict dup /PageSize [612 792] put put\r\n\tcurrentpagedevice /InputAttributes get 3 known {dup 3 1 dict dup /PageSize [612 792] put put}if \r\n\tput setpagedevice\r\n',
                      "option": 'LetterSmall',
                      "keyword": 'PageRegion',
                      "option_translation": 'US Letter Small',
                      }),
_Property({
                      "data": '3 dict dup /PageSize [595 842] put dup /ImagingBBox [25 25 570 817] put\r\n\tdup /InputAttributes 2 dict dup 1 1 dict dup /PageSize [595 842] put put\r\n\tcurrentpagedevice /InputAttributes get 3 known {dup 3 1 dict dup /PageSize [595 842] put put}if \r\n\tput setpagedevice\r\n',
                      "option": 'A4Small',
                      "keyword": 'PageRegion',
                      "option_translation": 'A4 Small',
                      }),
_Property({
                      "data": '3 dict dup /PageSize [612 1008] put dup /ImagingBBox [25 25 587 983] put\r\n\tdup /InputAttributes 2 dict dup 1 1 dict dup /PageSize [612 1008] put put\r\n\tcurrentpagedevice /InputAttributes get 3 known {dup 3 1 dict dup /PageSize [612 1008] put put}if \r\n\tput setpagedevice\r\n',
                      "option": 'LegalSmall',
                      "keyword": 'PageRegion',
                      "option_translation": 'US Legal Small',
                      }),
_Property({
                      "data": 'currentpagedevice /InputAttributes get 3 known {3} {1} ifelse\r\n\t3 dict dup /InputAttributes 1 dict dup 6 -1 roll 1 dict dup /PageSize [297 684] put put put\r\n\tdup /PageSize [297 684] put dup /ImagingBBox null put setpagedevice ',
                      "option": 'Com10',
                      "keyword": 'PageRegion',
                      "option_translation": 'Comm10 Envelope',
                      }),
_Property({
                      "data": 'currentpagedevice /InputAttributes get 3 known {3} {1} ifelse\r\n\t3 dict dup /InputAttributes 1 dict dup 6 -1 roll 1 dict dup /PageSize [279 540] put put put\r\n\tdup /PageSize [279 540] put dup /ImagingBBox null put setpagedevice ',
                      "option": 'Monarch',
                      "keyword": 'PageRegion',
                      "option_translation": 'Monarch Envelope',
                      }),
_Property({
                      "data": 'currentpagedevice /InputAttributes get 3 known {3} {1} ifelse\r\n\t3 dict dup /InputAttributes 1 dict dup 6 -1 roll 1 dict dup /PageSize [459 649] put put put\r\n\tdup /PageSize [459 649] put dup /ImagingBBox null put setpagedevice ',
                      "option": 'C5',
                      "keyword": 'PageRegion',
                      "option_translation": 'C5 Envelope',
                      }),
_Property({
                      "data": 'currentpagedevice /InputAttributes get 3 known {3} {1} ifelse\r\n\t3 dict dup /InputAttributes 1 dict dup 6 -1 roll 1 dict dup /PageSize [312 624] put put put\r\n\tdup /PageSize [312 624] put dup /ImagingBBox null put setpagedevice ',
                      "option": 'DL',
                      "keyword": 'PageRegion',
                      "option_translation": 'DL Envelope',
                      }),
                  ],
          "LanguageVersion": [
_Property({
                      "data": 'English',
                      "option": '',
                      "keyword": 'LanguageVersion',
                      "option_translation": None,
                      }),
                  ],
          "SuggestedWaitTimeout": [
_Property({
                      "data": '300"',
                      "option": '',
                      "keyword": 'SuggestedWaitTimeout',
                      "option_translation": None,
                      }),
                  ],
          "ScreenProc": [
_Property({
                      "data": '{abs\texch   abs   2 copy   add   1 gt   {1 sub   dup   mul   exch  \r\n1 sub\tdup   mul   add   1 sub  } {dup   mul   exch   dup   mul  \r\nadd\t1 exch   sub  } ifelse  }\r\n',
                      "option": 'Dot',
                      "keyword": 'ScreenProc',
                      "option_translation": None,
                      }),
_Property({
                      "data": '{ pop }"',
                      "option": 'Line',
                      "keyword": 'ScreenProc',
                      "option_translation": None,
                      }),
_Property({
                      "data": '{ dup 5 mul 8 div mul exch dup mul exch add sqrt 1 exch sub }"',
                      "option": 'Ellipse',
                      "keyword": 'ScreenProc',
                      "option_translation": None,
                      }),
                  ],
          "ImageableArea": [
_Property({
                      "data": '11.52 14.1601 599.04 782.04 "',
                      "option": 'Letter',
                      "keyword": 'ImageableArea',
                      "option_translation": 'US Letter',
                      }),
_Property({
                      "data": '11.52 14.1601 599.04 998.04 "',
                      "option": 'Legal',
                      "keyword": 'ImageableArea',
                      "option_translation": 'US Legal',
                      }),
_Property({
                      "data": '10.68 14.1601 582.84 831.96 "',
                      "option": 'A4',
                      "keyword": 'ImageableArea',
                      "option_translation": None,
                      }),
_Property({
                      "data": '11.52 14.2201 503.04 719.1 "',
                      "option": 'B5',
                      "keyword": 'ImageableArea',
                      "option_translation": None,
                      }),
_Property({
                      "data": '10.56 14.1601 409.92 585.0 "',
                      "option": 'A5',
                      "keyword": 'ImageableArea',
                      "option_translation": None,
                      }),
_Property({
                      "data": '31 31 583 761 "',
                      "option": 'LetterSmall',
                      "keyword": 'ImageableArea',
                      "option_translation": 'US Letter Small',
                      }),
_Property({
                      "data": '29 31 567 812 "',
                      "option": 'A4Small',
                      "keyword": 'ImageableArea',
                      "option_translation": 'A4 Small',
                      }),
_Property({
                      "data": '64 54 548 954 "',
                      "option": 'LegalSmall',
                      "keyword": 'ImageableArea',
                      "option_translation": 'US Legal Small',
                      }),
_Property({
                      "data": '11.4 14.1601 284.04 674.04 "',
                      "option": 'Com10',
                      "keyword": 'ImageableArea',
                      "option_translation": 'Comm10 Envelope',
                      }),
_Property({
                      "data": '10.0801 14.1601 267.36 530.04 "',
                      "option": 'Monarch',
                      "keyword": 'ImageableArea',
                      "option_translation": 'Monarch Envelope',
                      }),
_Property({
                      "data": '11.7601 14.1601 445.68 639.0 "',
                      "option": 'C5',
                      "keyword": 'ImageableArea',
                      "option_translation": 'C5 Envelope',
                      }),
_Property({
                      "data": '11.28 14.1601 299.28 614.04 "',
                      "option": 'DL',
                      "keyword": 'ImageableArea',
                      "option_translation": 'DL Envelope',
                      }),
                  ],
          "CloseUI": [
_Property({
                      "data": '*InstalledMemory',
                      "option": '',
                      "keyword": 'CloseUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*OptionalCassette1',
                      "option": '',
                      "keyword": 'CloseUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*OptionalEnvelopeFeeder',
                      "option": '',
                      "keyword": 'CloseUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*Smoothing',
                      "option": '',
                      "keyword": 'CloseUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*BitsPerPixel',
                      "option": '',
                      "keyword": 'CloseUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageSize',
                      "option": '',
                      "keyword": 'CloseUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageRegion',
                      "option": '',
                      "keyword": 'CloseUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot',
                      "option": '',
                      "keyword": 'CloseUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*ManualFeed',
                      "option": '',
                      "keyword": 'CloseUI',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*TraySwitch',
                      "option": '',
                      "keyword": 'CloseUI',
                      "option_translation": None,
                      }),
                  ],
          "JobPatchFile": [
_Property({
                      "data": '/filterLineCapBugCTM where {pop false}{true}ifelse\nstatusdict begin version cvi 2014 eq revision 1.1 lt end and and\r\n{userdict begin\r\n/sysdictSc /scale load def\r\n/sysdictSa /setstrokeadjust load def\r\n/sysdictLc /setlinecap load def\r\n/sysdictIm /initmatrix load def\r\n/sysdictCc /concat load def\r\n/sysdictSm /setmatrix load def\r\n/filterLineCapBugCTM matrix def\r\n/filterLCBCTM {\r\n\tcurrentstrokeadjust currentlinecap 2 eq and\r\n\t{filterLineCapBugCTM currentmatrix\r\n\tdup dup 0 get abs exch 3 get abs ne\r\n\texch dup 1 get abs exch 2 get abs ne or\r\n\t{1 sysdictLc}if\r\n\t}if\r\n}bind def\r\n/scale {sysdictSc filterLCBCTM}bind def\r\n/setlinecap {sysdictLc filterLCBCTM}bind def\r\n/setstrokeadjust {sysdictSa filterLCBCTM}bind def\r\n/initmatrix {sysdictIm filterLCBCTM}bind def\r\n/concat {sysdictCc filterLCBCTM}bind def\r\n/setmatrix {sysdictSm filterLCBCTM}bind def\r\nend \r\n/sysdictSc /sysdictSa /sysdictLc\r\n/sysdictIm /sysdictCc /sysdictSm\r\n6 {userdict exch undef}repeat\r\n}if\r\n',
                      "option": '2',
                      "keyword": 'JobPatchFile',
                      "option_translation": None,
                      }),
                  ],
          "OpenGroup": [
_Property({
                      "data": 'InstallableOptions/Options Installed',
                      "option": '',
                      "keyword": 'OpenGroup',
                      "option_translation": None,
                      }),
                  ],
          "InputSlot": [
_Property({
                      "data": 'currentpagedevice /InputAttributes get 0 get \r\n\tdup null eq \r\n\t{ pop } \r\n\t{ dup length 1 add dict copy \r\n\tdup /InputAttributes\r\n\t1 dict dup /Priority [0 1 2 3] put\r\n\tput setpagedevice\r\n\t} ifelse',
                      "option": 'UniversalCassette',
                      "keyword": 'InputSlot',
                      "option_translation": 'Cassette (250 Sheets)',
                      }),
_Property({
                      "data": 'currentpagedevice /InputAttributes get 1 get \r\n\tdup null eq \r\n\t{ pop } \r\n\t{ dup length 1 add dict copy \r\n\tdup /InputAttributes\r\n\t1 dict dup /Priority [1 0 2] put\r\n\tput setpagedevice\r\n\t} ifelse',
                      "option": 'Multipurpose',
                      "keyword": 'InputSlot',
                      "option_translation": 'Multipurpose Tray',
                      }),
_Property({
                      "data": 'currentpagedevice /InputAttributes get 2 get \r\n\tdup null eq \r\n\t{ pop } \r\n\t{ dup length 1 add dict copy \r\n\tdup /InputAttributes\r\n\t1 dict dup /Priority [2 0 1 3] put\r\n\tput setpagedevice\r\n\t} ifelse',
                      "option": 'OptionalCassette',
                      "keyword": 'InputSlot',
                      "option_translation": 'Cassette (500 Sheets)',
                      }),
_Property({
                      "data": 'currentpagedevice /InputAttributes get 3 get \r\n\tdup null eq \r\n\t{ pop } \r\n\t{ dup length 1 add dict copy \r\n\tdup /InputAttributes\r\n\t1 dict dup /Priority [3 0 1 2] put\r\n\tput setpagedevice\r\n\t} ifelse',
                      "option": 'Envelope',
                      "keyword": 'InputSlot',
                      "option_translation": 'Envelope Feeder',
                      }),
                  ],
          "SuggestedJobTimeout": [
_Property({
                      "data": '0"',
                      "option": '',
                      "keyword": 'SuggestedJobTimeout',
                      "option_translation": None,
                      }),
                  ],
          "ColorSepScreenProc": [
_Property({
                      "data": '{1 add 2 div 3 mul dup floor sub 2 mul 1 sub exch \r\n1 add 2 div 3 mul dup floor sub 2 mul 1 sub exch \r\nabs exch abs 2 copy add 1 gt {1 sub dup mul exch 1 sub dup mul add 1 \r\nsub }{dup mul exch dup mul add 1 exch sub }ifelse }',
                      "option": 'ProcessYellow.85lpi.600dpi',
                      "keyword": 'ColorSepScreenProc',
                      "option_translation": '85 lpi / 600 dpi',
                      }),
                  ],
          "Throughput": [
_Property({
                      "data": '16"',
                      "option": '',
                      "keyword": 'Throughput',
                      "option_translation": None,
                      }),
                  ],
          "Message": [
_Property({
                      "data": '%%[ exitserver: permanent state may be changed ]%%"',
                      "option": '',
                      "keyword": 'Message',
                      "option_translation": None,
                      }),
_Property({
                      "data": '%%[ Flushing: rest of job (to end-of-file) will be ignored ]%%"',
                      "option": '',
                      "keyword": 'Message',
                      "option_translation": None,
                      }),
_Property({
                      "data": '\\FontName\\ not found, using Courier"',
                      "option": '',
                      "keyword": 'Message',
                      "option_translation": None,
                      }),
                  ],
          "Font": [
_Property({
                      "data": 'Universal "(001.006S)" Universal ROM',
                      "option": 'AvantGarde-Book',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.006S)" Universal ROM',
                      "option": 'AvantGarde-BookOblique',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'AvantGarde-Demi',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'AvantGarde-DemiOblique',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.004S)" Universal ROM',
                      "option": 'Bookman-Demi',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.004S)" Universal ROM',
                      "option": 'Bookman-DemiItalic',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.004S)" Universal ROM',
                      "option": 'Bookman-LightItalic',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.004S)" Universal ROM',
                      "option": 'Bookman-Light',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(002.004S)" Universal ROM',
                      "option": 'Courier',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(002.004S)" Universal ROM',
                      "option": 'Courier-Bold',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(002.004S)" Universal ROM',
                      "option": 'Courier-BoldOblique',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(002.004S)" Universal ROM',
                      "option": 'Courier-Oblique',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.006S)" Universal ROM',
                      "option": 'Helvetica',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'Helvetica-Bold',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'Helvetica-BoldOblique',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.006S)" Universal ROM',
                      "option": 'Helvetica-Narrow',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'Helvetica-Narrow-Bold',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'Helvetica-Narrow-BoldOblique',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.006S)" Universal ROM',
                      "option": 'Helvetica-Narrow-Oblique',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.006S)" Universal ROM',
                      "option": 'Helvetica-Oblique',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.009S)" Universal ROM',
                      "option": 'NewCenturySchlbk-Bold',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'NewCenturySchlbk-BoldItalic',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.006S)" Universal ROM',
                      "option": 'NewCenturySchlbk-Italic',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'NewCenturySchlbk-Roman',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.005S)" Universal ROM',
                      "option": 'Palatino-Bold',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.005S)" Universal ROM',
                      "option": 'Palatino-BoldItalic',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.005S)" Universal ROM',
                      "option": 'Palatino-Italic',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.005S)" Universal ROM',
                      "option": 'Palatino-Roman',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'Symbol',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'Times-Bold',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.009S)" Universal ROM',
                      "option": 'Times-BoldItalic',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'Times-Italic',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'Times-Roman',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.007S)" Universal ROM',
                      "option": 'ZapfChancery-MediumItalic',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
_Property({
                      "data": 'Universal "(001.004S)" Universal ROM',
                      "option": 'ZapfDingbats',
                      "keyword": 'Font',
                      "option_translation": None,
                      }),
                  ],
          "PCFileName": [
_Property({
                      "data": 'APLWGRI2.PPD"',
                      "option": '',
                      "keyword": 'PCFileName',
                      "option_translation": None,
                      }),
                  ],
          "UIConstraints": [
_Property({
                      "data": '*InstalledMemory 8Meg *BitsPerPixel 4',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*OptionalCassette1 False *InputSlot OptionalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*OptionalEnvelopeFeeder False *InputSlot Envelope',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageSize A5 *InputSlot UniversalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageSize A5 *InputSlot OptionalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageSize Com10 *InputSlot UniversalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageSize Com10 *InputSlot OptionalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageSize Monarch *InputSlot UniversalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageSize Monarch *InputSlot OptionalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageSize C5 *InputSlot UniversalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageSize C5 *InputSlot OptionalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageSize DL *InputSlot UniversalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageSize DL *InputSlot OptionalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageRegion A5 *InputSlot UniversalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageRegion A5 *InputSlot OptionalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageRegion Com10 *InputSlot UniversalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageRegion Com10 *InputSlot OptionalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageRegion Monarch *InputSlot UniversalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageRegion Monarch *InputSlot OptionalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageRegion C5 *InputSlot UniversalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageRegion C5 *InputSlot OptionalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageRegion DL *InputSlot UniversalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*PageRegion DL *InputSlot OptionalCassette',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot UniversalCassette *PageSize A5',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot OptionalCassette *PageSize A5',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot UniversalCassette *PageSize Com10',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot OptionalCassette *PageSize Com10',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot UniversalCassette *PageSize Monarch',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot OptionalCassette *PageSize Monarch',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot UniversalCassette *PageSize C5',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot OptionalCassette *PageSize C5',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot UniversalCassette *PageSize DL',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot OptionalCassette *PageSize DL',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot UniversalCassette *PageRegion A5',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot OptionalCassette *PageRegion A5',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot UniversalCassette *PageRegion Com10',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot OptionalCassette *PageRegion Com10',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot UniversalCassette *PageRegion Monarch',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot OptionalCassette *PageRegion Monarch',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot UniversalCassette *PageRegion C5',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot OptionalCassette *PageRegion C5',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot UniversalCassette *PageRegion DL',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
_Property({
                      "data": '*InputSlot OptionalCassette *PageRegion DL',
                      "option": '',
                      "keyword": 'UIConstraints',
                      "option_translation": None,
                      }),
                  ],
          },
      "__defaults__": {
          "InstalledMemory":               '8Meg',
          "PaperDimension":               'Letter',
          "ColorSpace":               'Gray',
          "ScreenProc":               'Dot',
          "PageSize":               'Letter',
          "ManualFeed":               'False',
          "Transfer":               'Null',
          "BitsPerPixel":               'None',
          "Font":               'Courier',
          "OutputOrder":               'Normal',
          "Smoothing":               'False',
          "OptionalCassette1":               'False',
          "InputSlot":               'UniversalCassette',
          "OutputBin":               'OnlyOne',
          "ColorSep":               'ProcessBlack.85lpi.600dpi/85 lpi / 600 dpi',
          "ImageableArea":               'Letter',
          "PageRegion":               'Letter',
          "TraySwitch":               'False',
          "OptionalEnvelopeFeeder":               'False',
          "Resolution":               '600dpi',
          },

    } )

