<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:gnue="GNUe:Reports:Base"
  xmlns:t="GNUe:Reports:SimpleTabulation"
  exclude-result-prefixes="gnue t"
  version="1.0">

<xsl:output method="xml"
            indent="yes"
            doctype-public="spreadsheet" />
<xsl:template match="/">

<spreadsheet mime="application/x-kspread" editor="KSpread" >
 <paper format="A4" orientation="Portrait" >
  <borders right="20" left="20" bottom="20" top="20" />
  <head/>
  <foot/>
 </paper>
 <locale positivePrefixCurrencySymbol="True" negativeMonetarySignPosition="1" negativePrefixCurrencySymbol="True" fracDigits="2" thousandsSeparator="," dateFormat="%A %d %B %Y" timeFormat="%I:%M:%S %p" monetaryDecimalSymbol="." weekStartsMonday="False" currencySymbol="$" negativeSign="-" positiveSign="" positiveMonetarySignPosition="1" decimalSymbol="." monetaryThousandsSeparator="," dateFormatShort="%m/%d/%y" />
 <map markerColumn="1" activeTable="Table1" markerRow="1" >
  <table columnnumber="0" borders="0" hide="0" hidezero="0" firstletterupper="0" grid="1" formular="0" lcmode="0" name="Table1" >

   <!--   Report Title   -->
   <cell row="1" column="1" >
    <format brushstyle="0" brushcolor="#ff0000" float="3" floatcolor="2" >
     <font size="12" family="helvetica" bold="yes" weight="75" />
     <left-border>
      <pen width="0" style="0" color="#000000" />
     </left-border>
     <top-border>
      <pen width="0" style="0" color="#000000" />
     </top-border>
     <right-border>
      <pen width="0" style="0" color="#000000" />
     </right-border>
     <bottom-border>
      <pen width="0" style="0" color="#000000" />
     </bottom-border>
     <fall-diagonal>
      <pen width="1" style="0" color="#000000" />
     </fall-diagonal>
     <up-diagonal>
      <pen width="1" style="0" color="#000000" />
     </up-diagonal>
    </format>
    <text><xsl:value-of select="gnue:report-output/t:report/t:reportTitle" /></text>
   </cell>

  <xsl:variable name="nextRow" select="2"/>


   <!--   Sections   -->

   <xsl:for-each select="gnue:report-output/t:report/t:section">

     <cell column="1" >

      <xsl:attribute name="row"><xsl:value-of select="nextRow"/></xsl:attribute>
      <xsl:variable name="nextRow2" select="nextRow+2"/>

      <format brushstyle="0" brushcolor="#ff0000" float="3" floatcolor="2" >
       <font size="12" family="helvetica" weight="50" />
       <left-border>
        <pen width="0" style="0" color="#000000" />
       </left-border>
       <top-border>
        <pen width="0" style="0" color="#000000" />
       </top-border>
       <right-border>
        <pen width="0" style="0" color="#000000" />
       </right-border>
       <bottom-border>
        <pen width="0" style="0" color="#000000" />
       </bottom-border>
       <fall-diagonal>
        <pen width="1" style="0" color="#000000" />
       </fall-diagonal>
       <up-diagonal>
        <pen width="1" style="0" color="#000000" />
       </up-diagonal>
      </format>
      <text><xsl:value-of select="t:sectionTitle"/></text>
     </cell>

     <xsl:for-each select="t:table">
          <xsl:for-each select="t:tablehead">
                <xsl:for-each select="t:colhead">

   <cell column="1" >
    <xsl:attribute name="row"><xsl:value-of select="nextRow"/></xsl:attribute>
    <format brushstyle="0" brushcolor="#ff0000" float="3" floatcolor="2" >
     <xsl:attribute name="align">
                    <xsl:choose>
                      <xsl:when test="@align='left'">1</xsl:when>
                      <xsl:when test="@align='center'">2</xsl:when>
                      <xsl:when test="@align='right'">3</xsl:when>
                      <xsl:otherwise>1</xsl:otherwise>
                    </xsl:choose>
     </xsl:attribute>
     <font size="12" family="helvetica" bold="yes" weight="75" underline="yes" />
     <left-border>
      <pen width="0" style="0" color="#000000" />
     </left-border>
     <top-border>
      <pen width="0" style="0" color="#000000" />
     </top-border>
     <right-border>
      <pen width="0" style="0" color="#000000" />
     </right-border>
     <bottom-border>
      <pen width="0" style="0" color="#000000" />
     </bottom-border>
     <fall-diagonal>
      <pen width="1" style="0" color="#000000" />
     </fall-diagonal>
     <up-diagonal>
      <pen width="1" style="0" color="#000000" />
     </up-diagonal>
    </format>
    <text><xsl:value-of select="."/></text>
   </cell>

                </xsl:for-each>
            </xsl:for-each>
            <xsl:for-each select="t:row">
              <xsl:variable name="trclass">
                <xsl:choose>
                  <xsl:when test="@type = 'subtotal'">subtotal</xsl:when>
                  <xsl:otherwise>item</xsl:otherwise>
                </xsl:choose>
              </xsl:variable>

              <xsl:for-each select="t:col">

                      <xsl:choose>
                      <xsl:when test="@align">
                        <td class="{$trclass}"><div align="{@align}"><xsl:value-of select="."/></div></td>
                      </xsl:when>
                      <xsl:otherwise>
                        <td class="{$trclass}"><xsl:value-of select="."/></td>
                      </xsl:otherwise>
                    </xsl:choose>


                </xsl:for-each>
            </xsl:for-each>

        </xsl:for-each>
      </xsl:for-each>


  </table>
 </map>
</spreadsheet>

</xsl:template>
</xsl:stylesheet>
