<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:gnue="GNUe:Reports:Base"
  xmlns:t="GNUe:Reports:SimpleTabulation"
  exclude-result-prefixes="gnue t"
  version="1.0">
  
<xsl:output method="html"/>
<xsl:template match="/">
  <html>
    <head>
      <title>
        <xsl:value-of select="gnue:report-output/t:report/t:reportTitle" />
      </title>
      <style>
        body {
          font-face: sans-serif;
        }
	table {
	  width: 80%;
	  margin-left: 10%;
	  margin-right: 10%;
	  border-spacing: 0;
	  border-collapse: collapse;
	}
        tr.subtotal {
          font-weight : bold;
        }
	td {
	  padding: 0.5em;
	}
	td.item {
	  padding: 0.5em;
	}
	td.subtotal {
	  padding: 0.5em;
	  border-style: solid;
	  border-width: medium;
	  border-color: black;
	  border-left: 0;
	  border-right: 0;
	}
	th {
	  padding: 0.5em;
	  border-style: solid;
	  border-width: thin;
	  border-color: black;
          background : black;
          color : white;
	}
	h1 {
	  text-align: center;
	}
	h2 {
	  margin-left: 5%;
	  margin-right: 5%;
	  text-align: left;
	}
	hr {
	  margin-left: 5%;
	  margin-right: 5%;
	}
    </style>

    </head>
    <body>
      <h1>
        <xsl:value-of select="gnue:report-output/t:report/t:reportTitle" />
      </h1>
      <xsl:for-each select="gnue:report-output/t:report/t:section">
        <hr/>
        <h2>
          <xsl:value-of select="t:sectionTitle"/>
        </h2>
        <xsl:for-each select="t:table">
          <table>
            <xsl:for-each select="t:tablehead">
              <tr>
                <xsl:for-each select="t:colhead">
                  <th align="{@align}"><xsl:value-of select="."/></th>
                </xsl:for-each>
              </tr>
            </xsl:for-each>
            <xsl:for-each select="t:row">
              <xsl:variable name="trclass">
                <xsl:choose>
                  <xsl:when test="@type = 'subtotal'">subtotal</xsl:when>
                  <xsl:otherwise>item</xsl:otherwise>
                </xsl:choose>
              </xsl:variable>
              <tr class="{$trclass}">
                <xsl:for-each select="t:col">

                    <xsl:choose>
                      <xsl:when test="@align">
                        <td class="{$trclass}"><div align="{@align}"><xsl:value-of select="."/></div></td>
                      </xsl:when>
                      <xsl:otherwise>
                        <td class="{$trclass}"><xsl:value-of select="."/></td>
                      </xsl:otherwise>
                    </xsl:choose>


                </xsl:for-each>
              </tr>
            </xsl:for-each>

          </table>
        </xsl:for-each>
      </xsl:for-each>
    </body>
  </html>
</xsl:template>
</xsl:stylesheet>
