#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# GRTransformAdapter.py
#
# DESCRIPTION:
# Base for transforms adapters
#
# NOTES:
#

from gnue.common.apps import GDebug
import types
import tempfile
import os


#
# Used by the various
#
class _BaseAdapter:

  def __init__(self, destination):
    tmpdir = gConfig('TempDir')
    if tmpdir:
      tempfile.tmpdir = tmpdir

  def createTempFile(self, extension='tmp'):
    tmpname = tempfile.mktemp('-gr.%s' % extension)
    GDebug.printMesg(2,'Using temporary file %s for output' % tmpname)
    outputHandle = open(tmpname, 'w')
    return (outputHandle, tmpname)

  def deleteTempFile(self, name):
    os.remove(name)



#
# Base for "transformation" adapters
#
class TransformAdapter(_BaseAdapter):

  #
  # destination is an instance of a DestinationAdapter.
  # filter_parameters is a string that can be in any
  # format the TransformAdapter defines
  #
  def __init__(self, destination, parameters = {}, filter_options=""):
    self.destination = destination
    self.filter_options= filter_options
    self.parameters = parameters


#
# Base for "destination" adapters
#
class DestinationAdapter(_BaseAdapter):

  # destination is an instance of a DestinationAdapter
  def __init__(self, destination, destination_options=None):
    self.destination = destination
    self.options= destination_options


  #
  # Typically, a transform adapter will call EITHER
  # getOutputHandle or getOutputFile, not both.
  #
  # return a stream handle for outut by
  # the transform adapter
  #
  def getOutputHandle(self):
    pass   # OVER-RIDE!


  #
  # return a file name for outut by the
  # transform adapter
  #
  def getOutputFile(self):
    pass   # OVER-RIDE!


  def close(self):
    pass   # OVER-RIDE!

