#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2004 Free Software Foundation
#
# FILE:
# Parser.py
#
# DESCRIPTION:
# Class that contains a SAX-based xml processor for GNUe Reports'
# "Universal" markup.
#
# NOTES:
#

__all__ = ['loadFile', 'xmlReportHandler', 'getXMLelements']

from gnue.common.datasources import GDataSource
from gnue.common.formatting import GTypecast
from gnue.common.definitions import GParser
from gnue.common.logic import GTrigger
from ParserTypes import measurement, color
import copy, types






########
########  Please keep this file neat !!!
########







#######################################################
# This method loads a report from an XML file and returns
# a GRReport object.  If initialize is 1 (default), then
# the report is initialized and ready to go.
#######################################################

def loadFile(buffer, connections=None, initialize=0):
  return GParser.loadXMLObject (buffer, xmlReportHandler, 'STReport', 'report',
           initialize, attributes={})



xmlElements = None


def getXMLelements():

  global xmlElements

  # Here due to some nasty recursive imports
  from Objects import Report,Section

  if xmlElements == None:

    #
    #
    xmlElements = {
      'report':       {
         'BaseClass': Report,
         'Required': 1,
         'SingleInstance': 1,
         'Attributes':  {
            'title':       {
               'Typecast': GTypecast.text },
            'author':       {
               'Typecast': GTypecast.text },
            'version':       {
               'Typecast': GTypecast.name },
            'description':       {
               'Typecast': GTypecast.text } } ,
         'ParentTags':  None },
  
      'section':    {
         'BaseClass': Section, # TODO: should be replaced by Multiplexed Section
         'Attributes': {
            'positioning':    {
               'ValueSet': { 
                    'below': {}, 
                    'right': {}, 
                    'marginleft': {}, 
                    'margintop': {}, 
                    'absolute': {}, 
                    'named': {} },                    
               'Typecast': GTypecast.name, 
               'Default': 'below' },
            'relation':    {
               'Typecast': GTypecast.name },
            'mode':     {
               'ValueSet': { 
                    'freeflow': {}, 
                    'tabular': {}, 
                    'crosstab': {}, 
                    'margintop': {}, 
                    'barchart': {}, 
                    'horizbarchart': {}, 
                    'stackedbarchart': {}, 
                    'stackedhorizbarchart': {}, 
                    'piechart': {}, 
                    'linechart': {} },
               'Typecast': GTypecast.name, 
               'Default': 'freeflow' },
            'columns': {
               'Typecast': GTypecast.whole, 
               'Default': 1 },
            'break':    {
               'ValueSet': { 
                    'never': {}, 
                    'always': {}, 
                    'conditional': {} },
               'Typecast': GTypecast.name, 
               'Default': 'never' },
            'breaklevel':    {
               'ValueSet': { 
                    'page': {}, 
                    'column': {} },
               'Typecast': GTypecast.name, 
               'Default': 'page' },
            'marginleft':      {
               'Typecast': measurement, 
               'Default': '0' },
            'marginright':      {
               'Typecast': measurement, 
               'Default': '0' },
            'margintop':      {
               'Typecast': measurement, 
               'Default': '0' },
            'marginbottom':      {
               'Typecast': measurement, 
               'Default': '0' },
            'spacingvert':      {
               'Typecast': measurement, 
               'Default': '0' },
            'spacinghoriz':      {
               'Typecast': measurement, 
               'Default': '0'  } } ,
         'ParentTags':  ('report',) },

    }

    borderTypes = { 
       'none': {}, 
       'single': {},
       'double': {},
       'dot': {},
       'dash': {}, 
       'dashdot': {}, 
       'dashdotdot': {}, 
       'thinthick': {}, 
       'thickthin': {}, 
       'thinthickthin': {}, 
    }
    
    borderStyles = {
            'bgcolor': {
               'Typecast': color, 
               'Default': None },
            'bordercolor': {
               'Typecast': color, 
               'Default': '100%' },
            'borderleft': {
               'Typecast': GTypecast.name, 
               'ValueSet': borderTypes, 
               'Default': 'none' },
            'borderright': {
               'Typecast': GTypecast.name, 
               'ValueSet': borderTypes, 
               'Default': 'none' },
            'bordertop': {
               'Typecast': GTypecast.name, 
               'ValueSet': borderTypes, 
               'Default': 'none' },
            'borderbottom': {
               'Typecast': GTypecast.name, 
               'ValueSet': borderTypes, 
               'Default': 'none' },
            'bordervert': {
               'Typecast': GTypecast.name, 
               'ValueSet': borderTypes, 
               'Default': 'none' },
            'borderhoriz': {
               'Typecast': GTypecast.name, 
               'ValueSet': borderTypes, 
               'Default': 'none' },
            'style': {
               'Typecast': GTypecast.name } }
    
    #
    # Add styles to stylable stuff
    #
    for tag in ('section',): 
      xmlElements[tag]['Attributes'].update( borderStyles )


  return GParser.buildImportableTags('report',xmlElements)


#######################################################
#
# xmlReportHandler
#
# This class is called by the XML parser to
# process the xml file.
#
#######################################################

class xmlReportHandler (GParser.xmlHandler):
  def __init__(self):
    GParser.xmlHandler.__init__(self)

    self.xmlElements = getXMLelements()

    #
    # Any namespace-qualified tags will be Pass-Thru tags..
    # The reporting engine actually doesn't care about these.
    #
    # TODO: This is a hack and won't work if we proxy
    # TODO: layout events. 
    #
    from gnue.reports.base.layout import GRPassThru
    self.xmlMasqueradeNamespaceElements = GRPassThru

    #
    self.xmlNamespaceAttributesAsPrefixes = 1


