#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2004 Free Software Foundation
#
# FILE:
# printer/bsd.py
#
# DESCRIPTION:
# Basic destination adapter for writing to BSD lpr
#
# NOTES:
#


from gnue.reports import VERSION
from gnue.reports.base.GROutputAdapter import DestinationAdapter as Base
from gnue.common.apps import GDebug
import sys, os, string


class DestinationAdapter(Base):

  #
  # Typically, a transform adapter will call EITHER
  # getOutputHandle or getOutputFile, not both.
  #
  # return a stream handle for outut by
  # the transform adapter
  #
  def getOutputHandle(self):
    self.usingHandle = 1
    self.input, self.tempfile = self.createTempFile()
    return self.input

  #
  # return a file name for outut by the
  # transform adapter
  #
  def getOutputFile(self):
    self.usingHandle = 0
    self.input, self.tempfile = self.createTempFile()
    self.input.close()
    return self.tempfile

  #
  # Wrap up
  #
  def close(self, mimetype='plain/text'):

    if self.usingHandle:
      self.input.close()

    file = self.tempfile

    print_to = string.replace(string.replace(self.destination, "`",""),';','')

    command = (gConfig('LprCommand') + " %s") % (print_to, file)
    GDebug.printMesg(3,'Printing using command: %s' % command)
    os.system(command)
    self.deleteTempFile(self.tempfile)

