#!/usr/bin/env python
#
# GNU Enterprise Reports - Installation Procedure
#
# Copyright 2001-2004 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: setup.py,v 1.37 2003/10/29 11:37:42 btami Exp $

import sys
import os

from src import PACKAGE, VERSION

try:
  from gnue.common.setup import GSetup
except ImportError:
  print "You need GNUe-Common 0.5.2 or newer installed to install %s" % PACKAGE
  sys.exit (1)

# =============================================================================

class setup (GSetup.GSetup):

  package = PACKAGE.lower()

  # ---------------------------------------------------------------------------
  # Definition of basic parameters for distribution and installation.
  # Please add new files/directories that should be installed here.
  # Note that you also have to add them to MANIFEST.in.
  # ---------------------------------------------------------------------------

  def set_params (self, params):
  
    # The Work
    params ["name"]             = self.package
    params ["version"]          = VERSION
    params ["description"]      = "GNU Enterprise Reports"
    params ["long_description"] = ""
    params ["license"]          = "GPL"

    # The Author
    params ["author"]       = "GNU Enterprise Team"
    params ["author_email"] = "gnue-dev@gnu.org"
    params ["url"]          = "http://www.gnue.org"

    # The Programs
    params ["package_dir"] = {"gnue.reports": "src"}
    params ["scripts"]     = ["scripts/gnue-reports",
                              "scripts/gnue-reports-server"]

    # The Data
    filterLabels = self.allfiles ("src/adapters/filters/Labels/etc/")
    filterSimple = self.allfiles ("src/adapters/filters/SimpleTabulation/etc/")
    grpcfiles   = ["grpc/GRServer.grpc"]
    man1files    = self.allfiles ("doc/man")
    docfiles     = self.allfiles ("doc") + ["etc/sample.report-filters.conf"]
    samp01files  = self.allfiles ("samples/cross-tabulation")
    samp02files  = self.allfiles ("samples/dcl")
    samp03files  = self.allfiles ("samples/docbook")
    samp04files  = self.allfiles ("samples/foobulations")
    samp05files  = self.allfiles ("samples/labels")
    samp06files  = self.allfiles ("samples/location")
    samp07files  = self.allfiles ("samples/mailmerge")

    params ["data_files"] = \
      [("share/gnue/filters/Labels",                        filterLabels),
       ("share/gnue/filters/SimpleTabulation",              filterSimple),
       ("share/gnue/grpc",                                  grpcfiles),
       ("share/man/man1",                                   man1files),
       ("share/doc/gnue-reports",                           docfiles),
       ("share/doc/gnue-reports/examples/cross-tabulation", samp01files),
       ("share/doc/gnue-reports/examples/dcl",              samp02files),
       ("share/doc/gnue-reports/examples/docbook",          samp03files),
       ("share/doc/gnue-reports/examples/foobulations",     samp04files),
       ("share/doc/gnue-reports/examples/labels",           samp05files),
       ("share/doc/gnue-reports/examples/location",         samp06files),
       ("share/doc/gnue-reports/examples/mailmerge",        samp07files)]

  # ---------------------------------------------------------------------------
  # Build files to be distributed and installed:
  # Should generate the files that go in a distribution but aren't in SVN.
  # Gets called on sdist (always) and on build/install (only when run from SVN).
  # ---------------------------------------------------------------------------

  def build_files (self, action):
    # nothing to do here
    pass

  # ---------------------------------------------------------------------------
  # Check dependencies for installation:
  # Should sys.exit(1) in case any requirement isn't met.
  # Gets called on install.
  # ---------------------------------------------------------------------------

  def check_dependencies (self):
    # TODO
    pass

# =============================================================================

if __name__ == "__main__":
  setup().run()
