#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# GDateTime.py
#
# DESCRIPTION:
#
# NOTES:
#


def isLeapYear(year):
  return divmod(year,400)[1] == 0 or \
      (divmod(year,4)[1] == 0 and divmod(year,100)[1] != 0)

class InvalidDate(StandardError):
  pass

class GDateTime:
  def __init__(self):
    self.month = 0
    self.day = 0
    self.year = 0
    self.hour = 0
    self.minute = 0
    self.second = 0

  def __repr__(self):
    return "%04d/%02d/%02d %02d:%02d:%02d" % \
      (self.year, self.month, self.day, self.hour, self.minute, self.second)

  def getDayOfWeek(self):
    # from the Calendar FAQ (http://www.pauahtun.org/CalendarFAQ/)
    # 0 = Sunday
    a = int((14 - self.month) / 12)
    y = self.year - a
    m = self.month + 12*a - 2
    return divmod(self.day + y + int(y/4) - int(y/100) + int(y/400) + (31*m)/12,7)[1]


  def validate(self):
    if not (\
        self.month >= 1 and self.month <= 12 and \
        self.year >= 0 and \
        self.day >= 1 and self.day <= ( \
             (self.month in (1,3,5,7,8,10,12) and 31) or \
             (self.month == 2 and (28 + isLeapYear(self.year))) \
             or 30) and \
        self.hour >= 0 and self.hour <= 23 and \
        self.minute >= 0 and self.minute <= 59 and \
        self.second >= 0 and self.second <= 59 ):
      tmsg =  _("Not a valid date")
      raise InvalidDate, tmsg


