# -*- coding: iso-8859-1 -*-
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# FileUtils.py
#
# DESCRIPTION:
# Common file/url/resource related utilities
#
# NOTES:
#

import os, urllib, urlparse, sys
import cStringIO

############################################################
#
# Dynamically import a python module
#
import string

def dyn_import(name):
  try:
    mod = __import__(name)
    components = string.split(name, '.')
    for comp in components[1:]:
        mod = getattr(mod, comp)
    return mod
  except (AttributeError,ValueError), mesg:
    raise ImportError, mesg


############################################################
#
# Try to turn a resource into a valid URI
# (because C:\ confuses some tools)
#
def urlize (resource):
  if not resource.find(':'):
    return 'file://%s' % resource
  else:
    drive = os.path.splitdrive(resource)
    if len(drive[0]) and drive[0] == resource[:len(drive[0])]:
      return 'file://%s' % resource
    else:
      return resource


############################################################
#
# Open a string buffer as a normal file
#
def openBuffer(buffer):
  return cStringIO.StringIO(buffer)


############################################################
#
# Open a file or URL resource,
# properly handling drive letters.
#
def openResource(resource):
  drive = os.path.splitdrive(resource)
  if len(drive[0]):
    return open(resource,'r')
  else:
    (urltype, host, path, param, query, frag) = urlparse.urlparse(resource)

    # check for .gear files
    if resource[-5:]==".gear":
      host=resource
      path=""
      urltype="gear"

    # normal files are directly passed to the application
    if urltype!="gear":
      return urllib.urlopen(resource)

    else:
      
      from gnue.common.gear.GearSystem import GearFileSystem

      # fix for a bug in URLPARSE
      if host=="":
        # path="//host/path" -> path=path host=host
        pathlist=string.split(path[2:],"/",1)
        host=pathlist[0]
        path=pathlist[1]

      # check if host ends in ".gear"
      if host[-5:]!=".gear":
        host=host+".gear"

      # 1. search for gear in the local directory
      try:
        gear=GearFileSystem(urllib.unquote(host))
        
      except:
        # 2. search in the package directory
        if sys.platform=="win32":
          host=sys.prefix+"/packages/"+host
        else:
          host=os.environ["HOME"]+"/gnue/packages/"+host
      
        gear=GearFileSystem(urllib.unquote(host))

      if len(path):
        return gear.openFile(path)

      # if no path provided, create a navigator file for this archive
      else:

        # check if the zip file contains a default navigator file
        if gear.hasFile("default.gpd"):
          # TODO: change navigator file and add relative paths
          # i.e. in case of gear-resource="sample/test.gear"
          #      gear://test.gear/mypath/my.gfd ->
          #      gear://sample%2Ftest.gear/mypath/my.gfd
          return gear.openFile("default.gpd")
          

        # convert a single filename to a full gear url
        if resource[:5]!="gear:":
          resource="gear://"+urllib.quote(resource,"")+"/"
          
        gear._gearFileRes=resource

        filelist = gear.getArchiveListing()
        
        from gnue.common.gear.NavigationBuilder import buildNavigatorFile
      
        navi=buildNavigatorFile(filelist,host,1)

        return cStringIO.StringIO(navi)

