import __builtin__
__builtin__.__dict__['_']=lambda string:string

from gnue.common.rpc import GComm

#
# Primary testing routine
#
# This method demonstrates that the developer's code
# should not be dependent on the transport agent.
#
def test(interface, params):

  print "Testing %s interface..." % interface

  server = GComm.attach(interface, params)
  donutProvider = server.request("DonutPlace")

  status = donutProvider.Management.Status()
  print "  Donut Plant Operational Status:", status


  address = 'Jason Cater\n123 Main St\nMemphis, TN 38001'
  glazedBakery = donutProvider.Bakery.getBakingUnit('glazed yeast')

  print "  Sending %s donuts to Jason Cater" % glazedBakery.get_flavor()
  print "  Kitchen in use:", glazedBakery.get_unitLocation()
  print "  Success: ", glazedBakery.requestDelivery(address)
  print

  server.close()



#
# Test the proxy interface
#
# This method actually starts a "server" instance in the
# local namespace. The "server" doesn't actually connect
# via any ports or such...
#
def test_proxy():

  import server
  params = { '_proxy': server.create_proxy() }
  test('proxy',params)



#
# Test the xmlrpc interface
#
# Expects server.py to be running via xmlrpc on this
# machine's port 8765.
#
def test_xmlrpc():

  params = { 'host': 'localhost',
             'port': 8765,
             'transport': 'http' }

  test('xmlrpc',params)

#
# Test the xmlrpc interface
#
# Expects server.py to be running via xmlrpc on this
# machine's port 8765.
#
def test_pw_xmlrpc():

  params = { 'host': 'localhost',
             'port': 8765,
             'transport': 'http' }

  test('xmlrpc.pw_xmlrpc',params)


#
# Test the sockets interface
#
# Expects server.py to be running via sockets on this
# machine's port 8766.
#
def test_sockets():

  params = { 'host': 'localhost',
             'port': 8766 }

  test('sockets',params)


#
# Test the pyro interface
#
# Expects server.py to be running via pyro
#
def test_pyro():

  params = { 'host': 'localhost',
             'port': 8766 }

  test('pyro',params)

def run():
  test_xmlrpc()

#
# main
#
if __name__ == '__main__':

  #test_proxy()
  test_pyro()
  #test_xmlrpc()
  #test_pw_xmlrpc()
  #test_sockets()

