#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# _static/ResultSet.py
#
# DESCRIPTION:
# Virtual database driver for a connectionless, static set of data
#
# NOTES:
# Used whenever a fixed set of data is needed
#

__all__ = ["STATIC_ResultSet"]

from gnue.common.datasources.drivers import Base
from RecordSet import STATIC_RecordSet

class STATIC_ResultSet(Base.ResultSet):

  def __init__(self, dataObject, cursor=None, defaultValues={}, masterRecordSet=None):
    Base.ResultSet.__init__(self, dataObject, \
            cursor, defaultValues, masterRecordSet)
    
    self._recordSetClass = STATIC_RecordSet

  # Returns 1=DataObject has uncommitted changes
  def isPending(self):
    return 0    # Static DataObjects cannot have pending changes :)

  # Post changes to the database
  def post(self):
    # Leave this here in case (for some bizarro reason)
    # a bound dataobject uses us as a master
    for record in (self._cachedRecords):
      record.post()

  # Load cacheCount number of new records
  def _loadNextRecord(self):
    if hasattr(self,"_alldataloaded"):
      return 0
    
    # Load static data
    for row in self._dataObject._staticSet._children:
      dict = {}
      for field in row._children:
        dict[field.name] = field.value

      record=self._recordSetClass(parent=self,initialData=dict)
      
      self._cachedRecords.append (record)
      
      self._recordCount=self._recordCount+1

    self._alldataloaded = 1
      
    return 1


  # Create an empty record
  def _createEmptyRecord(self, masterRecordSet=None): 
    return self._recordSetClass(self, None)
