/*  Gnometab -- a guitar tablature editor for GNOME
    Copyright (C) 2001  William L. Guelker

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <libgnomeprint/gnome-print.h>


typedef double real;
typedef real coord;

typedef struct _Point Point;
typedef struct _Rectangle Rectangle;
typedef struct _Color Color;

struct _Point    {
    coord x;
    coord y;
};

struct _Rectangle    {
      coord top;
      coord left;
      coord bottom;
      coord right;
};

struct _Color     {
      float red;
      float green;
      float blue;
};

void 
set_linewidth(GnomePrintContext *ctx, real linewidth);

void 
set_linecaps(GnomePrintContext *ctx, int ps_mode);

void 
set_linejoin(GnomePrintContext *ctx, int ps_mode);

void
draw_line(GnomePrintContext *ctx, Point *start, Point *end, Color *line_color);

void
draw_polyline(GnomePrintContext *ctx, Point *points, 
                int num_points, Color *line_color);
                                    
void
draw_rect(GnomePrintContext *ctx, Point *ul_corner, 
            Point *lr_corner, Color *color);
                                    
void 
draw_string(GnomePrintContext *ctx,    const char *text, Point *pos, 
            int alignment, Color *color);
                                    
void 
draw_arc(GnomePrintContext *ctx, Point *p1, Point *p2, Point *p3, 
                                    Color *color);

void
draw_filled_arc(GnomePrintContext *ctx, Point *p1, Point *p2, Point *p3, 
                                            Color *color);

