/******************************************************************************\
 gnofin/date-preferences-page.c   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

//#define ENABLE_DEBUG_TRACE

#include "common.h"
#include <gtk/gtksignal.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtktable.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkeventbox.h>
#include <gtk/gtktooltips.h>
#include "preferences.h"
#include "preferences-pages.h"
#include "date.h"
#include "dialogs.h"

static const struct
{
  const gchar *code;
  const gchar *description;
}
guide_text[] =
{
  { N_("%a"), N_("abbreviated weekday name") },
  { N_("%A"), N_("full weekday name") },
  { N_("%b"), N_("abbreviated month name") },
  { N_("%B"), N_("full month name") },
  { N_("%d"), N_("day of month (01-31)") },
  { N_("%j"), N_("day of year (001-366)") },
  { N_("%m"), N_("month (01-12)") },
  { N_("%u"), N_("day of week (1-7), starting with Monday") },
  { N_("%w"), N_("day of week (0-6), starting with Sunday") },
  { N_("%U"), N_("week (01-53), starting with first Sunday") },
  { N_("%W"), N_("week (01-53), starting with first Monday") },
  { N_("%y"), N_("year (00-99)") },
  { N_("%Y"), N_("year, including the century") },
  { N_("%x"), N_("preferred date representation") },
};

typedef struct {
  gpointer  key;
  GtkEntry *format;
  GtkEntry *today;
  GtkLabel *bad;
  GtkTooltips *tips;
} PageContext;

static void
refresh_today_string (PageContext *page)
{
  GDate date;
  gchar buf[512];
  const gchar *format;

  trace ("");

  format = gtk_entry_get_text (page->format);

  date_now (&date);
  date_stringize_with_format (buf, sizeof buf, format, &date);
  gtk_entry_set_text (page->today, buf);

  /* Test the date string to see if it can be parsed */
  {
    GDate test;
    if (!date_parse (buf, &test) || (g_date_compare (&test, &date) != 0))
    {
      gtk_label_set_text (page->bad, _("Invalid"));
      gtk_tooltips_enable (page->tips);
    }
    else
    {
      gtk_label_set_text (page->bad, "");
      gtk_tooltips_disable (page->tips);
    }
  }
}

static void
on_format_changed (GtkEntry *entry, PageContext *page)
{
  refresh_today_string (page);
  preferences_page_changed (page->key);
}

static GtkWidget *
make_page (PageContext *page)
{
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *table;
  GtkWidget *label;
  GtkWidget *entry;
  GtkWidget *eventbox;
  gint i;

  trace ("");

  vbox = gtk_vbox_new (FALSE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);

  /* Page description
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  label = gtk_label_new (_("Select the date format Gnofin should use when\ndisplaying dates."));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  /* Packing table
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  table = gtk_table_new (2, 3, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 10);
  gtk_box_pack_start (GTK_BOX (hbox), table, FALSE, FALSE, 0);

  /* Format entry
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), hbox, 0, 1, 0, 1);

  label = gtk_label_new (_("Date format:"));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 20);

  entry = gtk_entry_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1, 2, 0, 1);

  page->format = GTK_ENTRY (entry);
  gtk_signal_connect (GTK_OBJECT (entry), "changed",
  		      GTK_SIGNAL_FUNC (on_format_changed), page);

  page->tips = gtk_tooltips_new ();

  eventbox = gtk_event_box_new ();
  gtk_table_attach_defaults (GTK_TABLE (table), eventbox, 2, 3, 0, 1);

  gtk_tooltips_set_tip (page->tips, eventbox,
  		      _("The date format you have entered does not correspond "
		        "to a complete/unique date (ie. gnofin would be unable "
			"properly infer the date)"), NULL);
  gtk_tooltips_disable (page->tips);

  label = gtk_label_new ("");
  gtk_misc_set_padding (GTK_MISC (label), 2, 0);
  gtk_container_add (GTK_CONTAINER (eventbox), label);

  page->bad = GTK_LABEL (label);

  /* Date previewer
   */
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE (table), hbox, 0, 1, 1, 2);

  label = gtk_label_new (_("Today's date:"));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 20);

  entry = gtk_entry_new ();
  gtk_entry_set_editable (GTK_ENTRY (entry), FALSE);
  gtk_table_attach_defaults (GTK_TABLE (table), entry, 1, 2, 1, 2);

  page->today = GTK_ENTRY (entry);

  /* Guide to format codes
   */
  hbox = gtk_hbox_new (FALSE, 0); 
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 5);

  label = gtk_label_new (_("Guide to format codes:"));
  gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

  hbox = gtk_hbox_new (FALSE, 0); 
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  table = gtk_table_new (2, 2, FALSE);
  gtk_table_set_col_spacings (GTK_TABLE (table), 15);
  gtk_box_pack_start (GTK_BOX (hbox), table, FALSE, FALSE, 20);

  for (i=0; i < sizeof_array (guide_text); ++i)
  {
    hbox = gtk_hbox_new (FALSE, 0); 
    gtk_table_attach_defaults (GTK_TABLE (table), hbox, 0, 1, i, i+1);

    label = gtk_label_new (_(guide_text[i].code));
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

    hbox = gtk_hbox_new (FALSE, 0); 
    gtk_table_attach_defaults (GTK_TABLE (table), hbox, 1, 2, i, i+1);

    label = gtk_label_new (_(guide_text[i].description));
    gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  }

  return vbox;
}

static void
init_page (PageContext *page)
{
  trace ("");

  gtk_entry_set_text (page->format, date_get_format ());
  refresh_today_string (page);
}

static gboolean
apply_page (GtkWindow *parent, PageContext *page)
{
  trace ("");
  date_set_format (gtk_entry_get_text (page->format));
  return TRUE;
}

void
preferences_page_date_format_init (void)
{
  PreferencesPage page = {0};
  PageContext *context;

  trace ("");

  context = g_new0 (PageContext, 1);

  page.category = _("Appearance");
  page.label = _("Date Format");
  page.make = (PreferencesPageMakeFunc) make_page;
  page.init = (PreferencesPageInitFunc) init_page;
  page.apply = (PreferencesPageApplyFunc) apply_page;
  page.user_data = context;
  
  context->key = preferences_page_register (&page);
}
