/******************************************************************************\
 gnofin/plugin.h   $Revision: 1.5 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef PLUGIN_H
#define PLUGIN_H

GNOFIN_API_BEGIN

typedef struct _PluginData PluginData;

#include <gtk/gtkwindow.h>
#include <gmodule.h>

/* These are error codes that may be returned by a Plugin's
 * init_plugin function. */
enum
{
  PLUGIN_OK,
  PLUGIN_ERROR_UNKNOWN,
  PLUGIN_ERROR_INVALID_API,
};

struct _PluginData
{
  GModule   *handle;
  gint     (*init_plugin) (PluginData *);
  void     (*free_plugin) (PluginData *);
  gboolean (*can_unload)  (PluginData *);
  gchar     *description;   /* brief description of plugin */
  gchar     *author;        /* author name (email@address.com) */

  /* optionally filled in by plugin */
  gpointer   private_data;
};

extern GSList *plugin_list;

/* Each plugin must have this one function */
extern gint init_plugin (PluginData *pd);

void        plugins_init  (GtkWindow *parent);
PluginData *plugin_load   (GtkWindow *parent, const gchar *filename);
void        plugin_unload (GtkWindow *parent, PluginData *data);

/* Create the plugin manager window */
GtkWidget  *plugin_manager_new (GtkWindow *parent);

GNOFIN_API_END

#endif
