/******************************************************************************\
 gnofin/gnofin.c   $Revision: 1.5 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#include "common.h"
#include <gtk/gtkmain.h>
#include <libgnomeui/gnome-init.h>
#include "ui.h"
#include "ui-menubar.h" /* For ui_menubar_get_behavior */
#include "file-mru.h"   /* For file_mru_get */
#include "preferences-pages.h"
#include "fin-io.h"
#include "plugin.h"

#ifndef GNOMELOCALEDIR
# define GNOMELOCALEDIR "/usr/share/locale"
#endif

static struct poptOption options[] = {
  { NULL, '\0', 0, NULL, 0 }
};

int
main (int argc, char **argv)
{
  gchar **files;
  poptContext ctx;
  UI *ui;
  gboolean load_lastfile;
  const gchar *filename;

  trace ("");

  bindtextdomain (PACKAGE, GNOMELOCALEDIR);
  textdomain (PACKAGE);

  /* Initialize GNOME */
  gnome_init_with_popt_table (PACKAGE, VERSION, argc, argv, options, 0, &ctx);

  /* Initialize builtin program modules */
  preferences_pages_init ();
  fin_io_init ();

  /* Load all plugins */
  plugins_init (NULL);

  /* Create user interface */
  ui = ui_create ();

  /* Process command line */
  files = (gchar **) poptGetArgs (ctx);
  if (files && *files)
    ui_load_file (ui, *files);

  /* Load the last file open ? */
  ui_menubar_get_behavior(NULL,NULL,&load_lastfile);
  if (load_lastfile)
   {
    GSList *node;
    node = file_mru_get(NULL);
    if (node)
     {
       filename = LIST_DEREF (const gchar, node);
       ui_load_file (ui, filename);
     }
   }
  /* Else init the bankbook if it isn't initialized */
  if (ui->book==NULL)
    ui_load_bankbook (ui, NULL, NULL);
  poptFreeContext (ctx);

  /* Enter main message loop */
  gtk_main ();
  return 0;
}

