/******************************************************************************\
 gnofin/clipboard.h   $Revision: 1.5 $
 Copyright (C) 2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef CLIPBOARD_H
#define CLIPBOARD_H

#include "notification-list.h"
#include "data-types.h"
#include <gtk/gtkwidget.h>

GNOFIN_API_BEGIN

/* The clipboard stores a selection of records.
 */

typedef void (* ClipboardNotifyFunc) (GtkWidget *sink, gboolean can_paste, gpointer user_data);
typedef void (* ClipboardPasteFunc)  (Bankbook *book, gpointer user_data);

typedef struct
{
  ClipboardNotifyFunc notify_func;
  ClipboardPasteFunc  paste_func;

} ClipboardSignals;

void     clipboard_attach_sink (GtkWidget *sink, ClipboardSignals *sigs, gpointer user_data);
void     clipboard_remove_sink (GtkWidget *sink);
gboolean clipboard_can_paste   (void);
void     clipboard_paste       (GtkWidget *sink);
void     clipboard_set_source  (GtkWidget *source, const GSList *records);
void     clipboard_clear       (void);

GNOFIN_API_END

#endif
