/* gnobog_pixmaps.c
 *
 * Copyright (C) 2000 Frdric LESPEZ & Renaud CHAILLAT
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <gnome.h>
#include <gdk/gdkx.h>

#include "gnobog_pixmaps.h"

#include "pixmaps/dir_closed.xpm"
#include "pixmaps/dir_open.xpm"
#include "pixmaps/book.xpm"
#include "pixmaps/title.xpm"
#include "pixmaps/separator.xpm"


GdkPixmap*	pixmap_folder_open = NULL;
GdkPixmap*	pixmap_folder_closed = NULL;
GdkPixmap*	pixmap_bookmark = NULL;
GdkPixmap*	pixmap_title = NULL;
GdkPixmap*	pixmap_separator = NULL;
GdkBitmap*	mask_folder_open = NULL;
GdkBitmap*	mask_folder_closed = NULL;
GdkBitmap*	mask_bookmark = NULL;
GdkBitmap*	mask_title = NULL;
GdkBitmap*	mask_separator = NULL;


/*-----------------------------------------------------------------------------
 * gnobog_pixmaps_create
 *
 * Create pixmaps from xpm files.
 *
 * 
 *-----------------------------------------------------------------------------
 */
void
gnobog_pixmaps_create (void)
{
  pixmap_folder_open = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(),
						     &mask_folder_open,
						     0,
						     dir_open_xpm);

  pixmap_folder_closed = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(),
						       &mask_folder_closed,
						       0,
						       dir_closed_xpm);

  pixmap_bookmark = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(),
						  &mask_bookmark,
						  0,
						  book_xpm);

  pixmap_title = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(),
					       &mask_title,
					       0,
					       title_xpm);

  pixmap_separator = gdk_pixmap_create_from_xpm_d (GDK_ROOT_PARENT(),
						   &mask_separator,
						   0,
						   separator_xpm);
}

void
gnobog_pixmaps_delete (void)
{
  gdk_pixmap_unref (pixmap_folder_open);
  gdk_pixmap_unref (pixmap_folder_closed);
  gdk_pixmap_unref (pixmap_bookmark);
  gdk_pixmap_unref (pixmap_title);
  gdk_pixmap_unref (pixmap_separator);
}
