.TH x_list l "1 Jan 2004"
.SH NAME
\fBx_list\fP \- Extract Cross-Over Information from the Data Base.
.SH SYNOPSIS
\fBx_list\fP [ \fIleg1\fP ] [ \fIleg2\fP ] [ \fB\-\fP\fIdataflags\fP ]
[ \fB\-R\fP\fIwest/east/south/north\fP ]
[ \fB\-X\fP\fIxbase\fP ] [ \fB\-H\fP ] [ \fB\-I\fP ]
[ \fB\-V\fP ] [ \fB\-C\fP\fIcorrfile\fP ] [ \fB\-Z\fP\fIignorefile\fP ]
.SH DESCRIPTION
\fBx_list\fP will allow the user to extract information from the xx_base.b and xx_legs.b files.
Several options can be passed on the command line in order to specify which parameters to
extract. They are:
.TP
\fIleg1 leg2\fP
If two legs are specified, the cross-overs they have in common are returned. If one leg is
specified, all the external cross-overs involving this leg are returned, OR only its internal
cross-overs if \-I is selected. If no legs are given, all the external (or internal with \-I)
cross-overs are returned. This program is useful if one wants to look at, say, gravity COEs versus
time from port for a particular leg, etc.
.TP
\fIdataflags\fP
This is a string of any combination of the following:
.br
        l means list both legnames.
.br
        t means list time.
.br
        x means list longitude.
.br
        y means list latitude.
.br
        g means list gravity COEs.
.br
        m means list magnetics COEs.
.br
        b means list bathymetry COEs.
.br
        G means list average gravity at cross-over.
.br
        M means list average magnetic anomaly at cross-over.
.br
        B means list average bathymetry at cross-over.
.br
        h means list heading of ship at cross-over.
.br
The components are written out in the order they appear in \fIdataflags\fP. The default output is
\fB\-txygmbGMBhl\fP. When internal COEs are desired, the time reported is the elapsed time since
the ship first occupied the cross-over point. For external COEs the time means time from the start
of the year in seconds.
.TP
.B \-R
Only return cross-overs inside the specified region \fIwest, east, south, \fPand \fInorth\fP. [Default is world].
.TP
.B \-X
Indicate alternate \fIxx_base.b\fP file.
.TP
.B \-H
Issue one header record on output.
.TP
.B \-I
Report on internal COEs [Default is external COEs].
.TP
.B \-C
Apply cross-over correction to the data (i.e. reports the cross-over value after the best-fitting
corrections have been applied to both legs). If no \fIcorrfile\fP is given, the default correction file
is assumed.
.TP
.B \-Z
Ignore those legs that appear in the \fIignorefile\fP.
.TP
.B \-V
Operate in verbose mode.
.SH SEE ALSO
.IR gmt (GMTMANSECTION),
.IR x_system (GMTMANSECTION)
.SH REFERENCES
Wessel, P. XOVER: A Cross-over Error Detector for Track Data,
\fIComputers & Geosciences, 15\fP, 333-346.
